/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe;

import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.nfe.Assinar;
import br.com.swconsultoria.nfe.Validar;
import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.nfe.dom.enuns.DocumentoEnum;
import br.com.swconsultoria.nfe.dom.enuns.ServicosEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import br.com.swconsultoria.nfe.util.StubUtil;
import br.com.swconsultoria.nfe.util.WebServiceUtil;
import br.com.swconsultoria.nfe.ws.RetryParameter;
import br.com.swconsultoria.nfe.wsdl.NFeRecepcaoEvento.NFeRecepcaoEvento4Stub;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import lombok.Generated;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class Eventos {
    @Generated
    private static final Logger log = Logger.getLogger(Eventos.class.getName());

    private Eventos() {
    }

    static String enviarEvento(ConfiguracoesNfe config, String xml, ServicosEnum tipoEvento, boolean valida, boolean assina, DocumentoEnum tipoDocumento) throws NfeException {
        try {
            if (assina) {
                xml = Assinar.assinaNfe(config, xml, AssinaturaEnum.EVENTO);
            }
            log.info("[XML-ENVIO-" + (Object)((Object)tipoEvento) + "]: " + xml);
            if (valida) {
                new Validar().validaXml(config, xml, tipoEvento);
            }
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            NFeRecepcaoEvento4Stub.NfeDadosMsg dadosMsg = new NFeRecepcaoEvento4Stub.NfeDadosMsg();
            dadosMsg.setExtraElement(ome);
            String url = WebServiceUtil.getUrl(config, tipoDocumento, tipoEvento);
            NFeRecepcaoEvento4Stub stub = new NFeRecepcaoEvento4Stub(url);
            StubUtil.configuraHttpClient(stub, config, url);
            if (ObjetoUtil.verifica(config.getTimeout()).isPresent()) {
                stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
                stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
            }
            if (ObjetoUtil.verifica(config.getRetry()).isPresent()) {
                RetryParameter.populateRetry(stub, config.getRetry());
            }
            NFeRecepcaoEvento4Stub.NfeResultMsg result = stub.nfeRecepcaoEvento(dadosMsg);
            log.info("[XML-RETORNO-" + (Object)((Object)tipoEvento) + "]: " + result.getExtraElement().toString());
            return result.getExtraElement().toString();
        }
        catch (CertificadoException | RemoteException | XMLStreamException e) {
            throw new NfeException(e.getMessage(), e);
        }
    }
}

