/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe;

import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.nfe.Assinar;
import br.com.swconsultoria.nfe.Validar;
import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.nfe.dom.enuns.DocumentoEnum;
import br.com.swconsultoria.nfe.dom.enuns.EstadosEnum;
import br.com.swconsultoria.nfe.dom.enuns.ServicosEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema_4.inutNFe.TInutNFe;
import br.com.swconsultoria.nfe.schema_4.inutNFe.TRetInutNFe;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import br.com.swconsultoria.nfe.util.StubUtil;
import br.com.swconsultoria.nfe.util.WebServiceUtil;
import br.com.swconsultoria.nfe.util.XmlNfeUtil;
import br.com.swconsultoria.nfe.wsdl.NFeInutilizacao.NFeInutilizacao4Stub;
import br.com.swconsultoria.nfe.wsdl.NFeInutilizacao.ce.NFeInutilizacao4Stub;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import lombok.Generated;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class Inutilizar {
    @Generated
    private static final Logger log = Logger.getLogger(Inutilizar.class.getName());

    private Inutilizar() {
    }

    static TRetInutNFe inutiliza(ConfiguracoesNfe config, TInutNFe inutNFe, DocumentoEnum tipoDocumento, boolean validar) throws NfeException {
        try {
            String xml = XmlNfeUtil.objectToXml(inutNFe, config.getEncode());
            xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
            xml = Assinar.assinaNfe(config, xml, AssinaturaEnum.INUTILIZACAO);
            log.info("[XML-ENVIO]: " + xml);
            if (validar) {
                new Validar().validaXml(config, xml, ServicosEnum.INUTILIZACAO);
            }
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            String url = WebServiceUtil.getUrl(config, tipoDocumento, ServicosEnum.INUTILIZACAO);
            if (EstadosEnum.CE.equals((Object)config.getEstado())) {
                NFeInutilizacao4Stub.NfeDadosMsg dadosMsgCe = new NFeInutilizacao4Stub.NfeDadosMsg();
                dadosMsgCe.setExtraElement(ome);
                NFeInutilizacao4Stub stubCe = new NFeInutilizacao4Stub(url);
                StubUtil.configuraHttpClient(stubCe, config, url);
                if (ObjetoUtil.verifica(config.getTimeout()).isPresent()) {
                    stubCe._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
                    stubCe._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
                }
                NFeInutilizacao4Stub.NfeResultMsg resultCe = stubCe.nfeInutilizacaoNF(dadosMsgCe);
                log.info("[XML-RETORNO]: " + resultCe.getExtraElement().toString());
                return XmlNfeUtil.xmlToObject(resultCe.getExtraElement().toString(), TRetInutNFe.class);
            }
            NFeInutilizacao4Stub.NfeDadosMsg dadosMsg = new NFeInutilizacao4Stub.NfeDadosMsg();
            dadosMsg.setExtraElement(ome);
            br.com.swconsultoria.nfe.wsdl.NFeInutilizacao.NFeInutilizacao4Stub stub = new br.com.swconsultoria.nfe.wsdl.NFeInutilizacao.NFeInutilizacao4Stub(url);
            StubUtil.configuraHttpClient(stub, config, url);
            if (ObjetoUtil.verifica(config.getTimeout()).isPresent()) {
                stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
                stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
            }
            NFeInutilizacao4Stub.NfeResultMsg result = stub.nfeInutilizacaoNF(dadosMsg);
            log.info("[XML-RETORNO]: " + result.getExtraElement().toString());
            return XmlNfeUtil.xmlToObject(result.getExtraElement().toString(), TRetInutNFe.class);
        }
        catch (CertificadoException | RemoteException | JAXBException | XMLStreamException e) {
            throw new NfeException(e.getMessage(), e);
        }
    }
}

