/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe;

import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.dom.enuns.ServicosEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.exception.NfeValidacaoException;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import java.io.File;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class Validar
implements ErrorHandler {
    private String listaComErrosDeValidacao = "";

    public boolean isValidXml(String pastaSchemas, String xml, ServicosEnum servico) {
        return this.isValidXml(pastaSchemas + System.getProperty("file.separator") + servico.getXsd(), xml);
    }

    public boolean isValidXml(ConfiguracoesNfe config, String xml, ServicosEnum servico) {
        return this.isValidXml(config.getPastaSchemas(), xml, servico);
    }

    public boolean isValidXml(String xsd, String xml) {
        try {
            this.validaXml(xsd, xml);
            return true;
        }
        catch (NfeException ex) {
            return false;
        }
    }

    private void validaXml(String xsd, String xml) throws NfeException {
        System.setProperty("jdk.xml.maxOccurLimit", "99999");
        if (!new File(xsd).exists()) {
            throw new NfeException("Schema Nfe n\u00e3o Localizado: " + xsd);
        }
        String errosValidacao = this.validateXml(xml, xsd);
        if (ObjetoUtil.verifica(errosValidacao).isPresent()) {
            throw new NfeValidacaoException("Erro na valida\u00e7\u00e3o: " + errosValidacao);
        }
    }

    void validaXml(ConfiguracoesNfe config, String xml, ServicosEnum servico) throws NfeException {
        this.validaXml(config.getPastaSchemas() + System.getProperty("file.separator") + servico.getXsd(), xml);
    }

    private String validateXml(String xml, String xsd) throws NfeException {
        DocumentBuilder builder;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(true);
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", xsd);
        try {
            builder = docBuilderFactory.newDocumentBuilder();
            builder.setErrorHandler(this);
        }
        catch (ParserConfigurationException ex) {
            throw new NfeException(ex.getMessage());
        }
        try {
            builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception ex) {
            throw new NfeException(ex.toString());
        }
        return this.getListaComErrosDeValidacao();
    }

    @Override
    public void error(SAXParseException exception) {
        if (this.isError(exception)) {
            this.listaComErrosDeValidacao = this.listaComErrosDeValidacao + this.tratamentoRetorno(exception.getMessage());
        }
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.listaComErrosDeValidacao = this.listaComErrosDeValidacao + this.tratamentoRetorno(exception.getMessage());
    }

    @Override
    public void warning(SAXParseException exception) {
        this.listaComErrosDeValidacao = this.listaComErrosDeValidacao + this.tratamentoRetorno(exception.getMessage());
    }

    private String tratamentoRetorno(String message) {
        message = message.replaceAll("cvc-type.3.1.3:", "-");
        message = message.replaceAll("cvc-attribute.3:", "-");
        message = message.replaceAll("cvc-complex-type.2.4.a:", "-");
        message = message.replaceAll("cvc-complex-type.2.4.b:", "-");
        message = message.replaceAll("cvc-complex-type.2.4.c:", "-");
        message = message.replaceAll("cvc-complex-type.2.4.d:", "-");
        message = message.replaceAll("cvc-complex-type.4:", "-");
        message = message.replaceAll("cvc-minLength-valid:", "-");
        message = message.replaceAll("The value", "O valor");
        message = message.replaceAll("Value", "Valor");
        message = message.replaceAll("with length", "com tamanho");
        message = message.replaceAll("is not facet-valid with respect to minLength", "n\u00e3o equivale ao tamanho m\u00ednimo");
        message = message.replaceAll("for type", "para o tipo");
        message = message.replaceAll("The content", "O conte\u00fado");
        message = message.replaceAll("of element", "do campo");
        message = message.replaceAll("is not complete", "n\u00e3o est\u00e1 completo");
        message = message.replaceAll("is not valid", "n\u00e3o \u00e9 v\u00e1lido");
        message = message.replaceAll("Attribute", "Campo");
        message = message.replaceAll("must appear on element", "precisa estar em");
        message = message.replaceAll("Invalid content was found starting with element", "Conte\u00fado inv\u00e1lido encontrado iniciando com o campo");
        message = message.replaceAll("One of", "Um dos Campos");
        message = message.replaceAll("is expected", "\u00e9 esperado");
        message = message.replaceAll("\\{", "");
        message = message.replaceAll("\\}", "");
        message = message.replaceAll("\"", "");
        message = message.replaceAll("http://www.portalfiscal.inf.br/nfe:", "");
        return System.getProperty("line.separator") + message.trim();
    }

    private String getListaComErrosDeValidacao() {
        return this.listaComErrosDeValidacao;
    }

    private boolean isError(SAXParseException exception) {
        return !exception.getMessage().startsWith("cvc-enumeration-valid") && !exception.getMessage().startsWith("cvc-pattern-valid") && !exception.getMessage().startsWith("cvc-maxLength-valid") && !exception.getMessage().startsWith("cvc-datatype");
    }
}

