/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.dom;

import br.com.swconsultoria.certificado.Certificado;
import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.nfe.dom.Proxy;
import br.com.swconsultoria.nfe.dom.enuns.AmbienteEnum;
import br.com.swconsultoria.nfe.dom.enuns.EstadosEnum;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.logging.Logger;
import lombok.Generated;

public class ConfiguracoesNfe {
    @Generated
    private static final Logger log = Logger.getLogger(ConfiguracoesNfe.class.getName());
    private EstadosEnum estado;
    private AmbienteEnum ambiente;
    private Certificado certificado;
    private String pastaSchemas;
    private Proxy proxy;
    private Integer timeout;
    private boolean contigenciaSVC;
    private boolean validacaoDocumento = true;
    private String arquivoWebService;
    private Integer retry;
    private InputStream cacert;
    private Charset encode;
    private ZoneId zoneId;

    public static ConfiguracoesNfe criarConfiguracoes(EstadosEnum estado, AmbienteEnum ambiente, Certificado certificado, String pastaSchemas) throws CertificadoException {
        return ConfiguracoesNfe.criarConfiguracoes(estado, ambiente, certificado, pastaSchemas, ZoneId.of("America/Sao_Paulo"));
    }

    public static ConfiguracoesNfe criarConfiguracoes(EstadosEnum estado, AmbienteEnum ambiente, Certificado certificado, String pastaSchemas, ZoneId zoneId) throws CertificadoException {
        ConfiguracoesNfe configuracoesNfe = new ConfiguracoesNfe();
        configuracoesNfe.setEstado(ObjetoUtil.verifica(estado).orElseThrow(() -> new IllegalArgumentException("Estado n\u00e3o pode ser Nulo.")));
        configuracoesNfe.setAmbiente(ObjetoUtil.verifica(ambiente).orElseThrow(() -> new IllegalArgumentException("Ambiente n\u00e3o pode ser Nulo.")));
        configuracoesNfe.setCertificado(ObjetoUtil.verifica(certificado).orElseThrow(() -> new IllegalArgumentException("Certificado n\u00e3o pode ser Nulo.")));
        configuracoesNfe.setPastaSchemas(pastaSchemas);
        configuracoesNfe.setZoneId(ObjetoUtil.verifica(zoneId).orElseThrow(() -> new IllegalArgumentException("Zone ID n\u00e3o pode ser Nulo.")));
        if (Integer.parseInt(System.getProperty("java.class.version").substring(0, 2)) < 56) {
            try {
                System.setProperty("file.encoding", "UTF-8");
                Field charset = Charset.class.getDeclaredField("defaultCharset");
                charset.setAccessible(true);
                charset.set(null, null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new CertificadoException("Erro ao setar Encoding.");
            }
        }
        log.info(String.format("JAVA-NFE | Samuel Oliveira | samuel@swconsultoria.com.br | VERSAO=%s | DATA_VERSAO=%s | PASTA_SCHEMAS=%s | AMBIENTE=%s | ESTADO=%s", new Object[]{"4.00.47", "10/12/2025", pastaSchemas, ambiente, estado.getNome().toUpperCase()}));
        if (!certificado.isValido()) {
            throw new CertificadoException("Certificado Vencido/Inv\u00e1lido");
        }
        return configuracoesNfe;
    }

    public String getPastaSchemas() {
        return this.pastaSchemas;
    }

    private void setPastaSchemas(String pastaSchemas) {
        this.pastaSchemas = pastaSchemas;
    }

    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    public Certificado getCertificado() {
        return this.certificado;
    }

    private void setCertificado(Certificado certificado) {
        this.certificado = certificado;
    }

    public boolean isContigenciaSVC() {
        return this.contigenciaSVC;
    }

    public void setContigenciaSVC(boolean contigenciaSVC) {
        this.contigenciaSVC = contigenciaSVC;
    }

    public EstadosEnum getEstado() {
        return this.estado;
    }

    public void setEstado(EstadosEnum estado) {
        this.estado = estado;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean isValidacaoDocumento() {
        return this.validacaoDocumento;
    }

    public void setValidacaoDocumento(boolean validacaoDocumento) {
        this.validacaoDocumento = validacaoDocumento;
    }

    public String getArquivoWebService() {
        return this.arquivoWebService;
    }

    public void setArquivoWebService(String arquivoWebService) {
        this.arquivoWebService = arquivoWebService;
    }

    public Integer getRetry() {
        return this.retry;
    }

    public void setRetry(Integer retry) {
        this.retry = retry;
    }

    public InputStream getCacert() {
        return this.cacert;
    }

    public void setCacert(InputStream cacert) {
        this.cacert = cacert;
    }

    public Charset getEncode() {
        return this.encode;
    }

    public void setEncode(Charset encode) {
        this.encode = encode;
    }

    public void setEncode(String nomeEncode) {
        if (nomeEncode != null && !nomeEncode.equals("")) {
            try {
                this.encode = Charset.forName(nomeEncode);
            }
            catch (Exception ex) {
                this.encode = StandardCharsets.UTF_8;
            }
        }
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }
}

