/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.impressao;

import br.com.swconsultoria.nfe.exception.DanfeException;
import br.com.swconsultoria.nfe.impressao.ImpressaoDTO;
import br.com.swconsultoria.nfe.impressao.JasperNFeEnum;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import net.sf.jasperreports.view.JasperViewer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ImpressaoNfeUtil {
    private ImpressaoNfeUtil() {
    }

    public static void impressaoPdfArquivo(ImpressaoDTO impressao, String destinoPdf) throws JRException, ParserConfigurationException, IOException, SAXException {
        JasperPrint jasperPrint = ImpressaoNfeUtil.geraImpressao(impressao);
        JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)destinoPdf);
    }

    public static byte[] impressaoPdfByte(ImpressaoDTO impressao) throws JRException, ParserConfigurationException, IOException, SAXException {
        JasperPrint jasperPrint = ImpressaoNfeUtil.geraImpressao(impressao);
        return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
    }

    public static void impressaoHtml(ImpressaoDTO impressao, String destinoHtml) throws JRException, ParserConfigurationException, IOException, SAXException {
        JasperPrint jasperPrint = ImpressaoNfeUtil.geraImpressao(impressao);
        JasperExportManager.exportReportToHtmlFile((JasperPrint)jasperPrint, (String)destinoHtml);
    }

    public static JasperViewer impressaoPreview(ImpressaoDTO impressao) throws JRException, ParserConfigurationException, IOException, SAXException {
        JasperPrint jasperPrint = ImpressaoNfeUtil.geraImpressao(impressao);
        return new JasperViewer(jasperPrint, true);
    }

    public static void impressaoDireta(ImpressaoDTO impressao) throws JRException, ParserConfigurationException, IOException, SAXException, PrinterException {
        PrintService impressoraPadrao = PrintServiceLookup.lookupDefaultPrintService();
        ImpressaoNfeUtil.impressaoDireta(impressao, impressoraPadrao, null);
    }

    public static void impressaoDireta(ImpressaoDTO impressao, SimplePrintServiceExporterConfiguration configuration) throws JRException, ParserConfigurationException, IOException, SAXException, PrinterException {
        PrintService impressoraPadrao = PrintServiceLookup.lookupDefaultPrintService();
        ImpressaoNfeUtil.impressaoDireta(impressao, impressoraPadrao, configuration);
    }

    public static void impressaoDireta(ImpressaoDTO impressao, PrintService impressora) throws JRException, ParserConfigurationException, IOException, SAXException, PrinterException {
        SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
        configuration.setPrintRequestAttributeSet((PrintRequestAttributeSet)new HashPrintRequestAttributeSet());
        configuration.setDisplayPageDialog(Boolean.valueOf(false));
        configuration.setDisplayPrintDialog(Boolean.valueOf(false));
        ImpressaoNfeUtil.impressaoDireta(impressao, impressora, configuration);
    }

    public static void impressaoDireta(ImpressaoDTO impressao, PrintService impressora, SimplePrintServiceExporterConfiguration configuration) throws JRException, ParserConfigurationException, IOException, SAXException, PrinterException {
        JasperPrint jasperPrint = ImpressaoNfeUtil.geraImpressao(impressao);
        if (impressora == null) {
            throw new DanfeException("Impressora n\u00e3o encontrada");
        }
        if (configuration == null) {
            configuration = new SimplePrintServiceExporterConfiguration();
            configuration.setPrintRequestAttributeSet((PrintRequestAttributeSet)new HashPrintRequestAttributeSet());
            configuration.setDisplayPageDialog(Boolean.valueOf(false));
            configuration.setDisplayPrintDialog(Boolean.valueOf(false));
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(impressora);
        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        configuration.setPrintService(impressora);
        exporter.setConfiguration((ExporterConfiguration)configuration);
        exporter.exportReport();
    }

    public static JasperPrint geraImpressao(ImpressaoDTO impressao) throws IOException, SAXException, ParserConfigurationException, JRException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new InputSource(new StringReader(impressao.getXml())));
        JRXmlDataSource xmlDataSource = new JRXmlDataSource(document, impressao.getPathExpression());
        return JasperFillManager.fillReport((JasperReport)impressao.getJasper(), impressao.getParametros(), (JRDataSource)xmlDataSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JasperReport carregaJasperResources(String caminhoJasper) {
        try (InputStream in = ImpressaoNfeUtil.class.getResourceAsStream(caminhoJasper);){
            if (in == null) {
                throw new DanfeException(String.format("Jasper n\u00e3o encontrado %s", caminhoJasper));
            }
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)in);
            return jasperReport;
        }
        catch (IOException | JRException e) {
            throw new DanfeException(String.format("Erro ao carregar Jasper %s", caminhoJasper), e);
        }
    }

    public static ImpressaoDTO impressaoPadraoNFe(String xml) {
        ImpressaoDTO impressaoNFe = new ImpressaoDTO();
        impressaoNFe.setXml(xml);
        impressaoNFe.setPathExpression("/nfeProc/NFe/infNFe/det");
        impressaoNFe.setJasper(JasperNFeEnum.NFE.getJasper());
        impressaoNFe.getParametros().put("Logo", ImpressaoNfeUtil.class.getResourceAsStream("/img/nfe.png"));
        impressaoNFe.getParametros().put("SUBREPORT", JasperNFeEnum.NFE_FATURA.getJasper());
        return impressaoNFe;
    }

    public static ImpressaoDTO impressaoPadraoNFCe(String xml, String urlConsulta) {
        ImpressaoDTO impressaoNFCe = new ImpressaoDTO();
        impressaoNFCe.setXml(xml);
        impressaoNFCe.setPathExpression("/");
        impressaoNFCe.setJasper(JasperNFeEnum.NFCE.getJasper());
        impressaoNFCe.getParametros().put("Logo", ImpressaoNfeUtil.class.getResourceAsStream("/img/nfce.png"));
        impressaoNFCe.getParametros().put("UrlConsulta", urlConsulta);
        return impressaoNFCe;
    }

    public static ImpressaoDTO impressaoPadraoCCe(String xml) {
        ImpressaoDTO impressaoCCe = new ImpressaoDTO();
        impressaoCCe.setXml(xml);
        impressaoCCe.setPathExpression("/procEventoNFe");
        impressaoCCe.setJasper(JasperNFeEnum.CCE.getJasper());
        return impressaoCCe;
    }
}

