/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.util;

import br.com.swconsultoria.certificado.Certificado;
import br.com.swconsultoria.certificado.CertificadoService;
import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import java.io.InputStream;

public class ConfiguracoesUtil {
    public static ConfiguracoesNfe iniciaConfiguracoes(ConfiguracoesNfe configuracoesNfe) throws NfeException {
        return ConfiguracoesUtil.iniciaConfiguracoes(configuracoesNfe, null);
    }

    public static ConfiguracoesNfe iniciaConfiguracoes(ConfiguracoesNfe configuracoesNfe, String cpfCnpj) throws NfeException {
        ObjetoUtil.verifica(configuracoesNfe).orElseThrow(() -> new NfeException("Configura\u00e7\u00f5es n\u00e3o foram criadas"));
        try {
            if (!configuracoesNfe.getCertificado().isValido()) {
                throw new CertificadoException("Certificado vencido ou inv\u00e1lido.");
            }
            if (configuracoesNfe.isValidacaoDocumento() && cpfCnpj != null && !configuracoesNfe.getCertificado().getCnpjCpf().substring(0, 8).equals(cpfCnpj.substring(0, 8))) {
                throw new CertificadoException("Documento do Certificado(" + configuracoesNfe.getCertificado().getCnpjCpf() + ") n\u00e3o equivale ao Documento do Emissor(" + cpfCnpj + ")");
            }
            if (ObjetoUtil.verifica(configuracoesNfe.getCacert()).isPresent()) {
                CertificadoService.inicializaCertificado((Certificado)configuracoesNfe.getCertificado(), (InputStream)configuracoesNfe.getCacert());
            } else {
                CertificadoService.inicializaCertificado((Certificado)configuracoesNfe.getCertificado());
            }
        }
        catch (CertificadoException e) {
            throw new NfeException(e.getMessage(), e);
        }
        return configuracoesNfe;
    }
}

