/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.util;

import br.com.swconsultoria.nfe.Assinar;
import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.dom.Evento;
import br.com.swconsultoria.nfe.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.nfe.dom.enuns.ManifestacaoEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema.envConfRecebto.TEnvEvento;
import br.com.swconsultoria.nfe.schema.envConfRecebto.TEvento;
import br.com.swconsultoria.nfe.schema.envConfRecebto.TProcEvento;
import br.com.swconsultoria.nfe.schema.envConfRecebto.TretEvento;
import br.com.swconsultoria.nfe.util.ChaveUtil;
import br.com.swconsultoria.nfe.util.ConfiguracoesUtil;
import br.com.swconsultoria.nfe.util.XmlNfeUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.JAXBException;

public class ManifestacaoUtil {
    private ManifestacaoUtil() {
    }

    public static TEnvEvento montaManifestacao(Evento manifesta, ConfiguracoesNfe configuracao) throws NfeException {
        return ManifestacaoUtil.montaManifestacao(Collections.singletonList(manifesta), configuracao);
    }

    public static TEnvEvento montaManifestacao(List<Evento> listaManifestacao, ConfiguracoesNfe configuracao) throws NfeException {
        if (listaManifestacao.size() > 20) {
            throw new NfeException("Podem ser enviados no m\u00e1ximo 20 eventos no Lote.");
        }
        TEnvEvento enviEvento = new TEnvEvento();
        enviEvento.setVersao("1.00");
        enviEvento.setIdLote("1");
        listaManifestacao.forEach(manifestacao -> {
            if (manifestacao.getSequencia() == 0) {
                manifestacao.setSequencia(1);
            }
            String id = "ID" + manifestacao.getTipoManifestacao().getCodigo() + manifestacao.getChave() + ChaveUtil.completarComZerosAEsquerda(String.valueOf(manifestacao.getSequencia()), 2);
            TEvento evento = new TEvento();
            evento.setVersao("1.00");
            TEvento.InfEvento infEvento = new TEvento.InfEvento();
            infEvento.setId(id);
            infEvento.setCOrgao("91");
            infEvento.setTpAmb(configuracao.getAmbiente().getCodigo());
            infEvento.setCPF(manifestacao.getCpf());
            infEvento.setCNPJ(manifestacao.getCnpj());
            infEvento.setChNFe(manifestacao.getChave());
            infEvento.setDhEvento(XmlNfeUtil.dataNfe(manifestacao.getDataEvento(), configuracao.getZoneId()));
            infEvento.setTpEvento(manifestacao.getTipoManifestacao().getCodigo());
            infEvento.setNSeqEvento(String.valueOf(manifestacao.getSequencia()));
            infEvento.setVerEvento("1.00");
            TEvento.InfEvento.DetEvento detEvento = new TEvento.InfEvento.DetEvento();
            detEvento.setVersao("1.00");
            detEvento.setDescEvento(manifestacao.getTipoManifestacao().getValor());
            if (ManifestacaoEnum.OPERACAO_NAO_REALIZADA.equals((Object)manifestacao.getTipoManifestacao())) {
                detEvento.setXJust(manifestacao.getMotivo());
            }
            infEvento.setDetEvento(detEvento);
            evento.setInfEvento(infEvento);
            enviEvento.getEvento().add(evento);
        });
        return enviEvento;
    }

    public static String criaProcEventoManifestacao(ConfiguracoesNfe config, TEnvEvento enviEvento, TretEvento retorno) throws JAXBException, NfeException {
        String xml = XmlNfeUtil.objectToXml(enviEvento, config.getEncode());
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        xml = xml.replace("<evento v", "<evento xmlns=\"http://www.portalfiscal.inf.br/nfe\" v");
        String assinado = Assinar.assinaNfe(ConfiguracoesUtil.iniciaConfiguracoes(config), xml, AssinaturaEnum.EVENTO);
        TProcEvento procEvento = new TProcEvento();
        procEvento.setVersao("1.00");
        Optional<TEvento> optEvento = XmlNfeUtil.xmlToObject(assinado, TEnvEvento.class).getEvento().stream().filter(e -> e.getInfEvento().getChNFe().equalsIgnoreCase(retorno.getInfEvento().getChNFe())).findFirst();
        if (optEvento.isPresent()) {
            procEvento.setEvento(optEvento.get());
        }
        procEvento.setRetEvento(retorno);
        return XmlNfeUtil.objectToXml(procEvento, config.getEncode());
    }
}

