/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.util;

import br.com.swconsultoria.nfe.dom.enuns.StatusEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema.consCad.TRetConsCad;
import br.com.swconsultoria.nfe.schema.envConfRecebto.TRetEnvEvento;
import br.com.swconsultoria.nfe.schema_4.consReciNFe.TRetConsReciNFe;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TRetEnviNFe;
import br.com.swconsultoria.nfe.schema_4.inutNFe.TRetInutNFe;
import br.com.swconsultoria.nfe.util.ObjetoUtil;

public class RetornoUtil {
    public static void validaSincronoTrasmissaoContingencia(TRetEnviNFe retorno) throws NfeException {
        if (!retorno.getCStat().equals(StatusEnum.LOTE_RECEBIDO.getCodigo()) && !retorno.getCStat().equals(StatusEnum.LOTE_PROCESSADO.getCodigo())) {
            throw new NfeException(retorno.getCStat() + " - " + retorno.getXMotivo());
        }
        if (!retorno.getProtNFe().getInfProt().getCStat().equals(StatusEnum.AUTORIZADO.getCodigo()) && !retorno.getProtNFe().getInfProt().getCStat().equals(StatusEnum.AUTORIZADO_FORA_PRAZO.getCodigo())) {
            throw new NfeException(retorno.getProtNFe().getInfProt().getCStat() + " - " + retorno.getProtNFe().getInfProt().getXMotivo());
        }
    }

    public static void validaCancelamento(br.com.swconsultoria.nfe.schema.envEventoCancNFe.TRetEnvEvento retorno) throws NfeException {
        if (!StatusEnum.LOTE_EVENTO_PROCESSADO.getCodigo().equals(retorno.getCStat())) {
            throw new NfeException(retorno.getCStat() + " - " + retorno.getXMotivo());
        }
        String[] erro = new String[]{""};
        retorno.getRetEvento().forEach(retEvento -> {
            if (!StatusEnum.EVENTO_VINCULADO.getCodigo().equals(retEvento.getInfEvento().getCStat()) && !StatusEnum.CANCELAMENTO_FORA_PRAZO.getCodigo().equals(retEvento.getInfEvento().getCStat())) {
                erro[0] = erro[0] + retEvento.getInfEvento().getChNFe() + " - " + retEvento.getInfEvento().getCStat() + " - " + retEvento.getInfEvento().getXMotivo() + System.lineSeparator();
            }
        });
        if (ObjetoUtil.verifica(erro[0]).isPresent()) {
            throw new NfeException(erro[0]);
        }
    }

    public static void validaCancelamentoSubstituicao(br.com.swconsultoria.nfe.schema.envEventoCancSubst.TRetEnvEvento retorno) throws NfeException {
        if (!StatusEnum.LOTE_EVENTO_PROCESSADO.getCodigo().equals(retorno.getCStat())) {
            throw new NfeException(retorno.getCStat() + " - " + retorno.getXMotivo());
        }
        String[] erro = new String[]{""};
        retorno.getRetEvento().forEach(retEvento -> {
            if (!StatusEnum.EVENTO_VINCULADO.getCodigo().equals(retEvento.getInfEvento().getCStat())) {
                erro[0] = erro[0] + retEvento.getInfEvento().getChNFe() + " - " + retEvento.getInfEvento().getCStat() + " - " + retEvento.getInfEvento().getXMotivo() + System.lineSeparator();
            }
        });
        if (ObjetoUtil.verifica(erro[0]).isPresent()) {
            throw new NfeException(erro[0]);
        }
    }

    public static void validaEventoGenerico(br.com.swconsultoria.nfe.schema.eventoGenerico.TRetEnvEvento retorno) throws NfeException {
        if (!StatusEnum.LOTE_EVENTO_PROCESSADO.getCodigo().equals(retorno.getCStat())) {
            throw new NfeException(retorno.getCStat() + " - " + retorno.getXMotivo());
        }
        String[] erro = new String[]{""};
        retorno.getRetEvento().forEach(retEvento -> {
            if (!StatusEnum.EVENTO_VINCULADO.getCodigo().equals(retEvento.getInfEvento().getCStat())) {
                erro[0] = erro[0] + retEvento.getInfEvento().getChNFe() + " - " + retEvento.getInfEvento().getCStat() + " - " + retEvento.getInfEvento().getXMotivo() + System.lineSeparator();
            }
        });
        if (ObjetoUtil.verifica(erro[0]).isPresent()) {
            throw new NfeException(erro[0]);
        }
    }

    public static void validaManifestacao(TRetEnvEvento retorno) throws NfeException {
        if (!StatusEnum.LOTE_EVENTO_PROCESSADO.getCodigo().equals(retorno.getCStat())) {
            throw new NfeException(retorno.getCStat() + " - " + retorno.getXMotivo());
        }
        String[] erro = new String[]{""};
        retorno.getRetEvento().forEach(retEvento -> {
            if (!StatusEnum.EVENTO_VINCULADO.getCodigo().equals(retEvento.getInfEvento().getCStat()) && !StatusEnum.EVENTO_REGISTRADO_NAO_VINCULADO.getCodigo().equals(retEvento.getInfEvento().getCStat())) {
                erro[0] = erro[0] + retEvento.getInfEvento().getChNFe() + " - " + retEvento.getInfEvento().getCStat() + " - " + retEvento.getInfEvento().getXMotivo() + System.lineSeparator();
            }
        });
        if (ObjetoUtil.verifica(erro[0]).isPresent()) {
            throw new NfeException(erro[0]);
        }
    }

    public static void validaCartaCorrecao(br.com.swconsultoria.nfe.schema.envcce.TRetEnvEvento retorno) throws NfeException {
        if (!StatusEnum.LOTE_EVENTO_PROCESSADO.getCodigo().equals(retorno.getCStat())) {
            throw new NfeException(retorno.getCStat() + " - " + retorno.getXMotivo());
        }
        String[] erro = new String[]{""};
        retorno.getRetEvento().forEach(retEvento -> {
            if (!StatusEnum.EVENTO_VINCULADO.getCodigo().equals(retEvento.getInfEvento().getCStat())) {
                erro[0] = erro[0] + retEvento.getInfEvento().getChNFe() + " - " + retEvento.getInfEvento().getCStat() + " - " + retEvento.getInfEvento().getXMotivo() + System.lineSeparator();
            }
        });
        if (ObjetoUtil.verifica(erro[0]).isPresent()) {
            throw new NfeException(erro[0]);
        }
    }

    public static void validaEpec(br.com.swconsultoria.nfe.schema.envEpec.TRetEnvEvento retorno) throws NfeException {
        if (!StatusEnum.LOTE_EVENTO_PROCESSADO.getCodigo().equals(retorno.getCStat())) {
            throw new NfeException(retorno.getCStat() + " - " + retorno.getXMotivo());
        }
        String[] erro = new String[]{""};
        retorno.getRetEvento().forEach(retEvento -> {
            if (!StatusEnum.EVENTO_VINCULADO.getCodigo().equals(retEvento.getInfEvento().getCStat())) {
                erro[0] = erro[0] + retEvento.getInfEvento().getChNFe() + " - " + retEvento.getInfEvento().getCStat() + " - " + retEvento.getInfEvento().getXMotivo() + System.lineSeparator();
            }
        });
        if (ObjetoUtil.verifica(erro[0]).isPresent()) {
            throw new NfeException(erro[0]);
        }
    }

    public static void validaConsultaCadastro(TRetConsCad retorno) throws NfeException {
        if (!retorno.getInfCons().getCStat().equals(StatusEnum.CADASTRO_ENCONTRADO.getCodigo())) {
            throw new NfeException(retorno.getInfCons().getCStat() + " - " + retorno.getInfCons().getXMotivo());
        }
    }

    public static void validaInutilizacao(TRetInutNFe retorno) throws NfeException {
        if (!retorno.getInfInut().getCStat().equals(StatusEnum.INUTILIZADO.getCodigo())) {
            throw new NfeException(retorno.getInfInut().getCStat() + " - " + retorno.getInfInut().getXMotivo());
        }
    }

    public static boolean isRetornoAssincrono(TRetEnviNFe retorno) throws NfeException {
        if (!retorno.getCStat().equals(StatusEnum.LOTE_RECEBIDO.getCodigo()) && !retorno.getCStat().equals(StatusEnum.LOTE_PROCESSADO.getCodigo())) {
            throw new NfeException(retorno.getCStat() + " - " + retorno.getXMotivo());
        }
        return retorno.getCStat().equals(StatusEnum.LOTE_RECEBIDO.getCodigo());
    }

    public static void validaAssincrono(TRetConsReciNFe retorno) throws NfeException {
        if (!retorno.getCStat().equals(StatusEnum.LOTE_PROCESSADO.getCodigo())) {
            throw new NfeException(retorno.getCStat() + " - " + retorno.getXMotivo());
        }
        String[] erro = new String[]{""};
        retorno.getProtNFe().forEach(protNFe -> {
            if (!StatusEnum.AUTORIZADO.getCodigo().equals(protNFe.getInfProt().getCStat()) && !StatusEnum.AUTORIZADO_FORA_PRAZO.getCodigo().equals(protNFe.getInfProt().getCStat())) {
                erro[0] = erro[0] + protNFe.getInfProt().getChNFe() + " - " + protNFe.getInfProt().getCStat() + " - " + protNFe.getInfProt().getXMotivo() + System.lineSeparator();
            }
        });
        if (ObjetoUtil.verifica(erro[0]).isPresent()) {
            throw new NfeException(erro[0]);
        }
    }

    public static void validaSincrono(TRetEnviNFe retorno) throws NfeException {
        if (!retorno.getCStat().equals(StatusEnum.LOTE_RECEBIDO.getCodigo()) && !retorno.getCStat().equals(StatusEnum.LOTE_PROCESSADO.getCodigo())) {
            throw new NfeException(retorno.getCStat() + " - " + retorno.getXMotivo());
        }
        if (!retorno.getProtNFe().getInfProt().getCStat().equals(StatusEnum.AUTORIZADO.getCodigo()) && !retorno.getProtNFe().getInfProt().getCStat().equals(StatusEnum.AUTORIZADO_FORA_PRAZO.getCodigo())) {
            throw new NfeException(retorno.getProtNFe().getInfProt().getCStat() + " - " + retorno.getProtNFe().getInfProt().getXMotivo());
        }
    }
}

