/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback;

import com.opencashback.dto.CustomersResponse;
import com.opencashback.dto.OrdersResponse;
import com.opencashback.dto.PatchOrdersBody;
import com.opencashback.dto.PostAuthResponse;
import com.opencashback.dto.PostCustomersBody;
import com.opencashback.dto.PostOrdersBody;
import com.opencashback.exception.OpenCashBackApiExcecao;
import com.opencashback.exception.OpenCashBackApiFalhaComunicacaoExcecao;
import com.opencashback.model.Cliente;
import com.opencashback.model.Configuracoes;
import com.opencashback.model.Pedido;
import com.opencashback.standalone.ApiResponse;
import com.opencashback.standalone.OpenCashBackStandaloneFacade;
import com.opencashback.util.MoneyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenCashBackUtil {
    private static final Logger log = LoggerFactory.getLogger(OpenCashBackUtil.class);
    private static volatile OpenCashBackStandaloneFacade facade;
    private static volatile Configuracoes config;

    private OpenCashBackUtil() {
    }

    public static synchronized void init(Configuracoes cfg) throws OpenCashBackApiExcecao {
        if (cfg == null) {
            throw new IllegalArgumentException("Configuracoes required");
        }
        if (facade != null && config != null && config.equals(cfg)) {
            log.debug("OpenCashBackUtil j\u00e1 inicializado com a mesma Configuracoes");
            return;
        }
        log.info("Iniciando OpenCashBackUtil (static)...");
        config = cfg;
        facade = new OpenCashBackStandaloneFacade(cfg);
        OpenCashBackUtil.autenticar();
    }

    private static void checkInitialized() {
        if (facade == null) {
            throw new IllegalStateException("OpenCashBackUtil n\u00e3o inicializado. Chame OpenCashBackUtil.init(config) primeiro.");
        }
    }

    private static void autenticar() throws OpenCashBackApiExcecao {
        OpenCashBackUtil.checkInitialized();
        try {
            log.info("Autenticando...");
            PostAuthResponse auth = facade.login(config);
            if (auth == null || auth.getAccessToken() == null) {
                log.error("Falha ao autenticar: token ausente");
                throw new OpenCashBackApiExcecao("Falha ao autenticar: token ausente");
            }
            log.info("Autenticado.");
        }
        catch (OpenCashBackApiExcecao e) {
            log.error("Falha ao autenticar: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Falha ao autenticar: ", (Throwable)e);
            throw new OpenCashBackApiExcecao(e.getMessage());
        }
    }

    public static CustomersResponse consultarCliente(Cliente cliente) throws OpenCashBackApiExcecao {
        OpenCashBackUtil.checkInitialized();
        log.info("Consultando cliente...");
        if (cliente == null) {
            throw new OpenCashBackApiExcecao("Cliente nulo, n\u00e3o pode ser consultado e venda n\u00e3o pode ser enviada a OpenCashBack");
        }
        PostCustomersBody postCustomersBody = cliente.toPostCustomersBody();
        ApiResponse<CustomersResponse> resp = facade.getCustomersComplete(postCustomersBody.getDocument());
        if (resp == null) {
            throw new OpenCashBackApiExcecao("Resposta nula ao consultar cliente");
        }
        if (resp.getStatus() == 200 && resp.getBody() != null) {
            Long idCliente = resp.getBody().getId();
            cliente.setId(idCliente);
            log.info("Cliente j\u00e1 cadastrado! id {}", (Object)idCliente);
            Integer balance = resp.getBody().getBalance();
            if (balance != null && balance > 0) {
                log.info("Cliente com cashback, poderia usar {} !!", (Object)MoneyUtils.fromCents(balance));
            }
            return resp.getBody();
        }
        if (resp.getStatus() == 404 || resp.getStatus() == 500) {
            log.info("Cliente n\u00e3o cadastrado, cadastrando cliente...");
            ApiResponse<CustomersResponse> createResp = facade.postCustomersComplete(postCustomersBody);
            if (createResp == null) {
                throw new OpenCashBackApiExcecao("Resposta nula ao criar cliente");
            }
            if (createResp.getStatus() >= 200 && createResp.getStatus() < 300 && createResp.getBody() != null) {
                Long createdId = createResp.getBody().getId();
                cliente.setId(createdId);
                log.info("Cliente cadastrado com sucesso! id {}", (Object)createdId);
                return createResp.getBody();
            }
            log.error("Erro ao cadastrar o cliente! status {}, rawBody {}, error {}", new Object[]{createResp.getStatus(), createResp.getRawBody(), createResp.getError()});
            throw new OpenCashBackApiExcecao("Erro ao cadastrar cliente: status " + createResp.getStatus());
        }
        log.error("Erro ao consultar cliente. status={}, rawBody={}, error={}", new Object[]{resp.getStatus(), resp.getRawBody(), resp.getError()});
        throw new OpenCashBackApiExcecao("Erro ao consultar cliente: status " + resp.getStatus());
    }

    public static OrdersResponse enviar(Pedido pedido) throws OpenCashBackApiExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        OpenCashBackUtil.checkInitialized();
        log.info("Enviando pedido...");
        if (pedido == null) {
            throw new OpenCashBackApiExcecao("Pedido nulo, n\u00e3o pode ser enviado a OpenCashBack");
        }
        PostOrdersBody pedidoEnvio = pedido.toDTO(config);
        ApiResponse<OrdersResponse> ar = facade.postOrdersComplete(pedidoEnvio);
        if (ar == null) {
            throw new OpenCashBackApiFalhaComunicacaoExcecao("Resposta nula ao enviar pedido");
        }
        if (ar.getStatus() >= 200 && ar.getStatus() < 300 && ar.getBody() != null) {
            OrdersResponse resp = ar.getBody();
            String externalId = resp.getExternalId() != null ? resp.getExternalId() : (resp.getId() != null ? resp.getId().toString() : null);
            pedido.setExternalId(externalId);
            log.info("Pedido enviado com sucesso! externalId={}", (Object)externalId);
            return resp;
        }
        log.error("Erro ao enviar o pedido! status={}, rawBody={}, error={}", new Object[]{ar.getStatus(), ar.getRawBody(), ar.getError()});
        throw new OpenCashBackApiExcecao("Erro ao enviar pedido: status " + ar.getStatus());
    }

    public static OrdersResponse confirmar(Pedido pedido) throws OpenCashBackApiFalhaComunicacaoExcecao, OpenCashBackApiExcecao {
        OpenCashBackUtil.checkInitialized();
        log.info("Enviando patch do pedido...");
        if (pedido == null || pedido.getExternalId() == null) {
            throw new OpenCashBackApiExcecao("Pedido ou externalId ausente para patch");
        }
        PatchOrdersBody body = pedido.toDTO();
        ApiResponse<OrdersResponse> ar = facade.patchOrdersComplete(body, pedido.getExternalId());
        if (ar == null) {
            throw new OpenCashBackApiFalhaComunicacaoExcecao("Resposta nula ao patch do pedido");
        }
        if (ar.getStatus() >= 200 && ar.getStatus() < 300 && ar.getBody() != null) {
            log.info("Pedido patch realizado com sucesso id={}", (Object)ar.getBody().getId());
            return ar.getBody();
        }
        log.error("Erro ao patch do pedido. status={}, rawBody={}, error={}", new Object[]{ar.getStatus(), ar.getRawBody(), ar.getError()});
        throw new OpenCashBackApiExcecao("Erro ao patch do pedido: status " + ar.getStatus());
    }

    public static OrdersResponse cancelar(Pedido pedido) throws OpenCashBackApiFalhaComunicacaoExcecao, OpenCashBackApiExcecao {
        OpenCashBackUtil.checkInitialized();
        log.info("Enviando patch de cancelamento do pedido...");
        if (pedido == null || pedido.getExternalId() == null) {
            throw new OpenCashBackApiExcecao("Pedido ou externalId ausente para patch");
        }
        PatchOrdersBody response = pedido.toDTO(true);
        ApiResponse<OrdersResponse> ar = facade.patchOrdersComplete(response, pedido.getExternalId());
        if (ar == null) {
            throw new OpenCashBackApiFalhaComunicacaoExcecao("Resposta nula ao patch do pedido de cancelamento");
        }
        if (ar.getStatus() >= 200 && ar.getStatus() < 300 && ar.getBody() != null) {
            log.info("Pedido patch de cancelamento realizado com sucesso id={}", (Object)ar.getBody().getId());
            return ar.getBody();
        }
        log.error("Erro ao patch do pedido de cancelamento. status={}, rawBody={}, error={}", new Object[]{ar.getStatus(), ar.getRawBody(), ar.getError()});
        throw new OpenCashBackApiExcecao("Erro ao patch do pedido de cancelamento: status " + ar.getStatus());
    }

    public static synchronized void reinit(Configuracoes cfg) throws OpenCashBackApiExcecao {
        OpenCashBackUtil.init(cfg);
    }
}

