/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.client;

import com.opencashback.client.OpenCashBackFeignClient;
import com.opencashback.client.OpenCashBackFeignFactory;
import com.opencashback.client.TokenProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenCashBackFeignConfiguration {
    private final String baseUrl;
    private final TokenProvider tokenProvider;

    @Autowired
    public OpenCashBackFeignConfiguration(@Value(value="${opencashback.base-url:https://api.staging.opencashback.io/core}") String baseUrl, TokenProvider tokenProvider) {
        this.baseUrl = baseUrl;
        this.tokenProvider = tokenProvider;
    }

    @Bean
    @ConditionalOnMissingBean(value={OpenCashBackFeignClient.class})
    public OpenCashBackFeignClient openCashBackFeignClient() {
        return OpenCashBackFeignFactory.createWithTokenProvider(this.baseUrl, this.tokenProvider);
    }
}

