/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.client;

import com.opencashback.client.OpenCashBackFeignClient;
import com.opencashback.client.TokenProvider;
import com.opencashback.model.Configuracoes;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;

public class OpenCashBackFeignFactory {
    public static OpenCashBackFeignClient create(String baseUrl) {
        return (OpenCashBackFeignClient)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).logger((Logger)new Slf4jLogger(OpenCashBackFeignClient.class)).logLevel(Logger.Level.FULL).target(OpenCashBackFeignClient.class, baseUrl);
    }

    public static OpenCashBackFeignClient createWithTokenProvider(String baseUrl, TokenProvider tokenProvider) {
        RequestInterceptor authInterceptor = template -> {
            String token;
            String string = token = tokenProvider != null ? tokenProvider.getAccessToken() : null;
            if (token != null && !token.trim().isEmpty()) {
                String value = token.trim();
                if (!value.toLowerCase().startsWith("bearer ")) {
                    value = "Bearer " + value;
                }
                template.header("Authorization", new String[]{value});
            }
        };
        return (OpenCashBackFeignClient)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).requestInterceptor(authInterceptor).logger((Logger)new Slf4jLogger(OpenCashBackFeignClient.class)).logLevel(Logger.Level.FULL).target(OpenCashBackFeignClient.class, baseUrl);
    }

    public static OpenCashBackFeignClient create(Configuracoes config) {
        return OpenCashBackFeignFactory.create(config.getUrl());
    }
}

