/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.opencashback.util.MoneyUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OrdersPaymentMethods
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(OrdersPaymentMethods.class);
    private static final long serialVersionUID = 1L;
    private String id;
    private Integer amount;
    private String name;

    public OrdersPaymentMethods(String id, String name, BigDecimal amount) {
        this.id = id;
        this.name = name;
        this.amount = MoneyUtils.toCents(amount);
    }

    public static OrdersPaymentMethodsBuilder builder() {
        return new OrdersPaymentMethodsBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public String getName() {
        return this.name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrdersPaymentMethods)) {
            return false;
        }
        OrdersPaymentMethods other = (OrdersPaymentMethods)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$amount = this.getAmount();
        Integer other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrdersPaymentMethods;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "OrdersPaymentMethods(id=" + this.getId() + ", amount=" + this.getAmount() + ", name=" + this.getName() + ")";
    }

    public OrdersPaymentMethods() {
    }

    public OrdersPaymentMethods(String id, Integer amount, String name) {
        this.id = id;
        this.amount = amount;
        this.name = name;
    }

    public static class OrdersPaymentMethodsBuilder {
        private String id;
        private Integer amount;
        private String name;

        OrdersPaymentMethodsBuilder() {
        }

        public OrdersPaymentMethodsBuilder id(String id) {
            this.id = id;
            return this;
        }

        public OrdersPaymentMethodsBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public OrdersPaymentMethodsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OrdersPaymentMethods build() {
            return new OrdersPaymentMethods(this.id, this.amount, this.name);
        }

        public String toString() {
            return "OrdersPaymentMethods.OrdersPaymentMethodsBuilder(id=" + this.id + ", amount=" + this.amount + ", name=" + this.name + ")";
        }
    }
}

