/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.opencashback.model.Cliente;
import com.opencashback.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PostCustomersBody
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PostCustomersBody.class);
    private static final long serialVersionUID = 1L;
    private String name;
    private String document;
    @JsonProperty(value="birthdate")
    private String birthDate;
    private String email;
    @JsonProperty(value="cellphone")
    private String cellphone;

    public PostCustomersBody(String name, String document, LocalDate birthDate, String email, String cellphone) {
        this.name = name;
        this.document = document;
        if (birthDate != null) {
            String formattedDate;
            LocalDateTime dateTime = birthDate.atStartOfDay();
            ZoneId defaultZoneId = ZoneId.systemDefault();
            ZonedDateTime zonedDateTime = dateTime.atZone(defaultZoneId);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            this.birthDate = formattedDate = zonedDateTime.format(formatter);
        }
        this.email = email;
        this.cellphone = cellphone;
    }

    public PostCustomersBody(Cliente cliente) {
        this.name = cliente.getRazaoSocial();
        this.document = cliente.getDocumento();
        this.birthDate = DateUtils.localDateToOpenCashBack(cliente.getDataAniversario());
        this.email = cliente.getEmail();
        this.cellphone = "55" + cliente.getTelefone();
    }

    public static PostCustomersBodyBuilder builder() {
        return new PostCustomersBodyBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getDocument() {
        return this.document;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCellphone() {
        return this.cellphone;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    @JsonProperty(value="birthdate")
    public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="cellphone")
    public void setCellphone(String cellphone) {
        this.cellphone = cellphone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostCustomersBody)) {
            return false;
        }
        PostCustomersBody other = (PostCustomersBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$document = this.getDocument();
        String other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        String this$birthDate = this.getBirthDate();
        String other$birthDate = other.getBirthDate();
        if (this$birthDate == null ? other$birthDate != null : !this$birthDate.equals(other$birthDate)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$cellphone = this.getCellphone();
        String other$cellphone = other.getCellphone();
        return !(this$cellphone == null ? other$cellphone != null : !this$cellphone.equals(other$cellphone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostCustomersBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        String $birthDate = this.getBirthDate();
        result = result * 59 + ($birthDate == null ? 43 : $birthDate.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $cellphone = this.getCellphone();
        result = result * 59 + ($cellphone == null ? 43 : $cellphone.hashCode());
        return result;
    }

    public String toString() {
        return "PostCustomersBody(name=" + this.getName() + ", document=" + this.getDocument() + ", birthDate=" + this.getBirthDate() + ", email=" + this.getEmail() + ", cellphone=" + this.getCellphone() + ")";
    }

    public PostCustomersBody() {
    }

    public PostCustomersBody(String name, String document, String birthDate, String email, String cellphone) {
        this.name = name;
        this.document = document;
        this.birthDate = birthDate;
        this.email = email;
        this.cellphone = cellphone;
    }

    public static class PostCustomersBodyBuilder {
        private String name;
        private String document;
        private String birthDate;
        private String email;
        private String cellphone;

        PostCustomersBodyBuilder() {
        }

        public PostCustomersBodyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PostCustomersBodyBuilder document(String document) {
            this.document = document;
            return this;
        }

        @JsonProperty(value="birthdate")
        public PostCustomersBodyBuilder birthDate(String birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public PostCustomersBodyBuilder email(String email) {
            this.email = email;
            return this;
        }

        @JsonProperty(value="cellphone")
        public PostCustomersBodyBuilder cellphone(String cellphone) {
            this.cellphone = cellphone;
            return this;
        }

        public PostCustomersBody build() {
            return new PostCustomersBody(this.name, this.document, this.birthDate, this.email, this.cellphone);
        }

        public String toString() {
            return "PostCustomersBody.PostCustomersBodyBuilder(name=" + this.name + ", document=" + this.document + ", birthDate=" + this.birthDate + ", email=" + this.email + ", cellphone=" + this.cellphone + ")";
        }
    }
}

