/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.standalone;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.opencashback.client.OpenCashBackFeignClient;
import com.opencashback.dto.CustomersResponse;
import com.opencashback.dto.OpenCashBackErrorResponse;
import com.opencashback.dto.OrdersResponse;
import com.opencashback.dto.PatchOrdersBody;
import com.opencashback.dto.PostAuthLoginBody;
import com.opencashback.dto.PostAuthRefreshBody;
import com.opencashback.dto.PostAuthResponse;
import com.opencashback.dto.PostCustomersBody;
import com.opencashback.dto.PostOrdersBody;
import com.opencashback.dto.PostOrdersItemBody;
import com.opencashback.exception.OpenCashBackApiExcecao;
import com.opencashback.exception.OpenCashBackApiFalhaComunicacaoExcecao;
import com.opencashback.exception.OpenCashBackApiNaoAutorizadoExcecao;
import com.opencashback.model.Configuracoes;
import com.opencashback.standalone.ApiResponse;
import com.opencashback.standalone.TokenProvider;
import com.opencashback.util.DescriptionSanitizer;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenCashBackStandaloneFacade {
    private static final Logger log = LoggerFactory.getLogger(OpenCashBackStandaloneFacade.class);
    private final OpenCashBackFeignClient feignClient;
    private final TokenProvider tokenProvider;
    private final ObjectMapper mapper;
    private final String baseUrl;
    private PostAuthResponse authResponse;
    private static final long DEFAULT_EXPIRY_SKEW_SECONDS = 60L;

    public OpenCashBackStandaloneFacade(Configuracoes config) {
        TokenProvider tp;
        Objects.requireNonNull(config, "config required");
        this.tokenProvider = tp = new TokenProvider();
        this.feignClient = OpenCashBackStandaloneFacade.createFeignClient(config, tp);
        ObjectMapper m = new ObjectMapper();
        m.registerModule((Module)new JavaTimeModule());
        this.mapper = m;
        this.baseUrl = OpenCashBackStandaloneFacade.normalizeBaseUrl(config.getUrl());
    }

    public OpenCashBackStandaloneFacade(Configuracoes config, TokenProvider tokenProvider) {
        Objects.requireNonNull(config, "config required");
        this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider required");
        this.feignClient = OpenCashBackStandaloneFacade.createFeignClient(config, tokenProvider);
        ObjectMapper m = new ObjectMapper();
        m.registerModule((Module)new JavaTimeModule());
        this.mapper = m;
        this.baseUrl = OpenCashBackStandaloneFacade.normalizeBaseUrl(config.getUrl());
    }

    public OpenCashBackStandaloneFacade(TokenProvider tokenProvider, OpenCashBackFeignClient feignClient, ObjectMapper mapper, String baseUrl) {
        this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider required");
        this.feignClient = Objects.requireNonNull(feignClient, "feignClient required");
        if (mapper != null) {
            this.mapper = mapper;
        } else {
            ObjectMapper m = new ObjectMapper();
            m.registerModule((Module)new JavaTimeModule());
            this.mapper = m;
        }
        this.baseUrl = OpenCashBackStandaloneFacade.normalizeBaseUrl(baseUrl);
    }

    private static String normalizeBaseUrl(String u) {
        if (u == null) {
            return null;
        }
        return u.endsWith("/") ? u.substring(0, u.length() - 1) : u;
    }

    private static OpenCashBackFeignClient createFeignClient(Configuracoes config, TokenProvider tokenProvider) {
        RequestInterceptor authInterceptor = template -> {
            String token;
            String string = token = tokenProvider != null ? tokenProvider.getAccessToken() : null;
            if (token != null && !token.trim().isEmpty()) {
                String value = token.trim();
                if (!value.toLowerCase().startsWith("bearer ")) {
                    value = "Bearer " + value;
                }
                template.header("Authorization", new String[]{value});
            }
        };
        ErrorDecoder.Default errorDecoder = new ErrorDecoder.Default();
        return (OpenCashBackFeignClient)Feign.builder().client((Client)new ApacheHttpClient()).encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).requestInterceptor(authInterceptor).errorDecoder((ErrorDecoder)errorDecoder).logger((feign.Logger)new Slf4jLogger(OpenCashBackFeignClient.class)).logLevel(Logger.Level.BASIC).options(new Request.Options(10000, 60000)).target(OpenCashBackFeignClient.class, config.getUrl());
    }

    private String toJsonSafe(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return this.mapper.writeValueAsString(o);
        }
        catch (Exception ex) {
            log.debug("Failed to serialize object for logging: {}", (Object)ex.getMessage());
            return "<serialization error>";
        }
    }

    private void logRequest(String method, String url, Object request) {
        if (!log.isDebugEnabled()) {
            return;
        }
        String body = request == null ? "null" : this.toJsonSafe(request);
        log.debug("REQUEST -> {} {} | body={}", new Object[]{method, url != null ? url : "<unknown-url>", body});
    }

    private void logResponse(String method, String url, int status, Object response, String rawBody) {
        if (!log.isDebugEnabled()) {
            return;
        }
        String bodyStr = response != null ? this.toJsonSafe(response) : (rawBody != null ? rawBody : "null");
        log.debug("RESPONSE <- {} {} | status={} body={}", new Object[]{method, url != null ? url : "<unknown-url>", status, bodyStr});
    }

    private boolean isAccessTokenExpired(long skewSeconds) {
        Instant exp;
        String token = this.tokenProvider.getAccessToken();
        if (token == null || token.trim().isEmpty()) {
            return true;
        }
        if (this.authResponse != null && this.authResponse.getAccessTokenExpireAt() != null && !this.authResponse.getAccessTokenExpireAt().trim().isEmpty() && (exp = this.parseExpireAtString(this.authResponse.getAccessTokenExpireAt())) != null) {
            long now = Instant.now().getEpochSecond();
            return exp.getEpochSecond() <= now + skewSeconds;
        }
        String raw = token.trim();
        if (raw.toLowerCase().startsWith("bearer ")) {
            raw = raw.substring(7).trim();
        }
        if (!raw.contains(".")) {
            return false;
        }
        Long expFromJwt = this.extractExpFromJwt(raw);
        if (expFromJwt == null) {
            return false;
        }
        long now = Instant.now().getEpochSecond();
        return expFromJwt <= now + skewSeconds;
    }

    private boolean isAccessTokenExpired() {
        return this.isAccessTokenExpired(60L);
    }

    private Instant parseExpireAtString(String s) {
        if (s == null) {
            return null;
        }
        String trimmed = s.trim();
        if (trimmed.matches("^\\d+$")) {
            try {
                long epoch = Long.parseLong(trimmed);
                if (epoch > 1000000000000L) {
                    return Instant.ofEpochMilli(epoch);
                }
                return Instant.ofEpochSecond(epoch);
            }
            catch (NumberFormatException ex) {
                log.debug("Cannot parse numeric expireAt '{}': {}", (Object)s, (Object)ex.getMessage());
                return null;
            }
        }
        try {
            return Instant.parse(trimmed);
        }
        catch (DateTimeParseException ex) {
            try {
                OffsetDateTime odt = OffsetDateTime.parse(trimmed, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                return odt.toInstant();
            }
            catch (DateTimeParseException odt) {
                try {
                    LocalDateTime ldt = LocalDateTime.parse(trimmed, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                    return ldt.atZone(ZoneId.systemDefault()).toInstant();
                }
                catch (DateTimeParseException dateTimeParseException) {
                    log.debug("Unable to parse accessTokenExpireAt value: '{}'", (Object)s);
                    return null;
                }
            }
        }
    }

    private Long extractExpFromJwt(String jwt) {
        try {
            String[] parts = jwt.split("\\.");
            if (parts.length < 2) {
                return null;
            }
            String payload = parts[1];
            byte[] decoded = Base64.getUrlDecoder().decode(payload);
            Map map = (Map)this.mapper.readValue(decoded, Map.class);
            Object expObj = map.get("exp");
            if (expObj == null) {
                return null;
            }
            if (expObj instanceof Number) {
                return ((Number)expObj).longValue();
            }
            return Long.parseLong(expObj.toString());
        }
        catch (Exception ex) {
            log.debug("Failed to parse exp from JWT: {}", (Object)ex.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIfNeeded() throws OpenCashBackApiExcecao, OpenCashBackApiNaoAutorizadoExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        String t = this.tokenProvider.getAccessToken();
        if ((t == null || t.trim().isEmpty()) && (this.authResponse == null || this.authResponse.getAccessToken() == null || this.authResponse.getAccessToken().isEmpty())) {
            throw new IllegalStateException("Access token not defined. Call login(...) before.");
        }
        if (this.isAccessTokenExpired()) {
            OpenCashBackStandaloneFacade openCashBackStandaloneFacade = this;
            synchronized (openCashBackStandaloneFacade) {
                if (!this.isAccessTokenExpired()) {
                    return;
                }
                log.info("Access token locally expired or about to expire \u2014 performing refresh()");
                PostAuthResponse refreshed = this.refresh();
                log.info("Refresh obtained new access token present={}", (Object)(refreshed != null && refreshed.getAccessToken() != null ? 1 : 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ApiResponse<T> executeWithRefresh(String method, String url, Callable<T> action, int successStatus) {
        try {
            this.refreshIfNeeded();
        }
        catch (OpenCashBackApiExcecao | OpenCashBackApiFalhaComunicacaoExcecao | OpenCashBackApiNaoAutorizadoExcecao e) {
            log.warn("refreshIfNeeded failed before executing {} {}: {}", new Object[]{method, url, e.getMessage()});
            return ApiResponse.error(-1, null, null, e);
        }
        try {
            T resp = action.call();
            this.logResponse(method, url, successStatus, resp, null);
            return ApiResponse.success(successStatus, resp);
        }
        catch (FeignException e) {
            int status = this.safeStatus(e);
            String raw = this.safeContent(e);
            this.logResponse(method, url, status, null, raw);
            if (status == 401) {
                log.info("Token returned 401 \u2014 attempting refresh and retry for {} {}", (Object)method, (Object)url);
                try {
                    OpenCashBackStandaloneFacade openCashBackStandaloneFacade = this;
                    synchronized (openCashBackStandaloneFacade) {
                        this.refresh();
                    }
                }
                catch (Exception refreshEx) {
                    log.warn("Refresh failed while handling 401 for {} {}: {}", new Object[]{method, url, refreshEx.getMessage()});
                    OpenCashBackErrorResponse parsed = this.parseErrorSafe(raw);
                    return ApiResponse.error(status, raw, parsed, (Exception)((Object)e));
                }
                try {
                    T resp2 = action.call();
                    this.logResponse(method, url, successStatus, resp2, null);
                    return ApiResponse.success(successStatus, resp2);
                }
                catch (FeignException e2) {
                    int status2 = this.safeStatus(e2);
                    String raw2 = this.safeContent(e2);
                    this.logResponse(method, url, status2, null, raw2);
                    OpenCashBackErrorResponse parsed2 = this.parseErrorSafe(raw2);
                    return ApiResponse.error(status2, raw2, parsed2, (Exception)((Object)e2));
                }
                catch (Exception ex2) {
                    log.error("Unexpected error on retry for {} {}: {}", new Object[]{method, url, ex2.getMessage(), ex2});
                    return ApiResponse.error(-1, null, null, ex2);
                }
            }
            OpenCashBackErrorResponse parsed = this.parseErrorSafe(raw);
            return ApiResponse.error(status, raw, parsed, (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error("Unexpected error while calling {} {}: {}", new Object[]{method, url, e.getMessage(), e});
            return ApiResponse.error(-1, null, null, e);
        }
    }

    public synchronized PostAuthResponse login(PostAuthLoginBody body) throws OpenCashBackApiExcecao, OpenCashBackApiNaoAutorizadoExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        Objects.requireNonNull(body, "PostAuthLoginBody required");
        String url = (this.baseUrl != null ? this.baseUrl : "<unknown>") + "/auth/login";
        this.logRequest("POST", url, body);
        try {
            PostAuthResponse resp;
            this.authResponse = resp = this.feignClient.postAuthLogin(body);
            if (resp != null) {
                this.tokenProvider.setAccessToken(resp.getAccessToken());
                this.tokenProvider.setRefreshToken(resp.getRefreshToken());
            }
            this.logResponse("POST", url, 200, resp, null);
            return resp;
        }
        catch (FeignException e) {
            int status = this.safeStatus(e);
            String raw = this.safeContent(e);
            this.logResponse("POST", url, status, null, raw);
            this.handleFeignException(e);
            return null;
        }
        catch (Exception e) {
            log.error("Unexpected error in POST {}: {}", new Object[]{url, e.getMessage(), e});
            throw new OpenCashBackApiFalhaComunicacaoExcecao(e.getMessage(), e);
        }
    }

    public PostAuthResponse login(Configuracoes config) throws OpenCashBackApiExcecao, OpenCashBackApiNaoAutorizadoExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        return this.login(new PostAuthLoginBody(config.getEmailLogin(), config.getSenhaLogin()));
    }

    public synchronized PostAuthResponse refresh() throws OpenCashBackApiExcecao, OpenCashBackApiNaoAutorizadoExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        String url = (this.baseUrl != null ? this.baseUrl : "<unknown>") + "/auth/refresh";
        String refresh = this.tokenProvider.getRefreshToken();
        if (refresh == null || refresh.isEmpty()) {
            if (this.authResponse == null || this.authResponse.getRefreshToken() == null) {
                throw new IllegalStateException("Refresh token not available. Call login(...) first.");
            }
            refresh = this.authResponse.getRefreshToken();
        }
        PostAuthRefreshBody body = new PostAuthRefreshBody(refresh);
        this.logRequest("POST", url, body);
        try {
            PostAuthResponse resp;
            this.authResponse = resp = this.feignClient.postAuthRefresh(body);
            if (resp != null) {
                this.tokenProvider.setAccessToken(resp.getAccessToken());
                this.tokenProvider.setRefreshToken(resp.getRefreshToken());
            }
            this.logResponse("POST", url, 200, resp, null);
            return resp;
        }
        catch (FeignException e) {
            int status = this.safeStatus(e);
            String raw = this.safeContent(e);
            this.logResponse("POST", url, status, null, raw);
            this.handleFeignException(e);
            return null;
        }
        catch (Exception e) {
            log.error("Unexpected error in POST {}: {}", new Object[]{url, e.getMessage(), e});
            throw new OpenCashBackApiFalhaComunicacaoExcecao(e.getMessage(), e);
        }
    }

    public String currentAccessToken() {
        String t = this.tokenProvider.getAccessToken();
        if (t != null && !t.isEmpty()) {
            return t;
        }
        return this.authResponse != null ? this.authResponse.getAccessToken() : null;
    }

    public ApiResponse<CustomersResponse> getCustomersComplete(String document) {
        String url = (this.baseUrl != null ? this.baseUrl : "<unknown>") + "/customers?document=" + (document != null ? document : "");
        this.logRequest("GET", url, null);
        return this.executeWithRefresh("GET", url, () -> this.feignClient.getCustomers(this.buildAuthHeader(), document), 200);
    }

    public ApiResponse<OrdersResponse> postOrdersComplete(PostOrdersBody body) {
        this.sanitizePostOrdersBody(body);
        String url = (this.baseUrl != null ? this.baseUrl : "<unknown>") + "/orders";
        this.logRequest("POST", url, body);
        return this.executeWithRefresh("POST", url, () -> this.feignClient.postOrders(this.buildAuthHeader(), body), 201);
    }

    public ApiResponse<OrdersResponse> patchOrdersComplete(PatchOrdersBody body, String externalId) {
        String url = (this.baseUrl != null ? this.baseUrl : "<unknown>") + "/orders/" + (externalId != null ? externalId : "<null>");
        this.logRequest("PATCH", url, body);
        return this.executeWithRefresh("PATCH", url, () -> this.feignClient.patchOrders(this.buildAuthHeader(), externalId, body), 200);
    }

    public ApiResponse<CustomersResponse> postCustomersComplete(PostCustomersBody body) {
        String url = (this.baseUrl != null ? this.baseUrl : "<unknown>") + "/customers";
        this.logRequest("POST", url, body);
        return this.executeWithRefresh("POST", url, () -> this.feignClient.postCustomers(this.buildAuthHeader(), body), 201);
    }

    public CustomersResponse getCustomers(String document) throws OpenCashBackApiExcecao, OpenCashBackApiNaoAutorizadoExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        ApiResponse<CustomersResponse> ar = this.getCustomersComplete(document);
        int status = ar.getStatus();
        if (status == 200) {
            return ar.getBody();
        }
        if (status == 404) {
            return null;
        }
        if (ar.getException() instanceof FeignException) {
            FeignException fe = (FeignException)((Object)ar.getException());
            this.handleFeignException(fe);
            return null;
        }
        throw new OpenCashBackApiFalhaComunicacaoExcecao(ar.getException() != null ? ar.getException().getMessage() : "unknown error");
    }

    public OrdersResponse postOrders(PostOrdersBody body) throws OpenCashBackApiExcecao, OpenCashBackApiNaoAutorizadoExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        ApiResponse<OrdersResponse> ar = this.postOrdersComplete(body);
        int status = ar.getStatus();
        if (OpenCashBackStandaloneFacade.isStatusNoError(status)) {
            return ar.getBody();
        }
        if (ar.getException() instanceof FeignException) {
            this.handleFeignException((FeignException)((Object)ar.getException()));
        }
        throw new OpenCashBackApiFalhaComunicacaoExcecao(ar.getException() != null ? ar.getException().getMessage() : "unknown");
    }

    private static boolean isStatusNoError(int status) {
        return status >= 200 && status < 300;
    }

    public OrdersResponse patchOrders(PatchOrdersBody body, String externalId) throws OpenCashBackApiExcecao, OpenCashBackApiNaoAutorizadoExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        ApiResponse<OrdersResponse> ar = this.patchOrdersComplete(body, externalId);
        int status = ar.getStatus();
        if (OpenCashBackStandaloneFacade.isStatusNoError(status)) {
            return ar.getBody();
        }
        if (ar.getException() instanceof FeignException) {
            this.handleFeignException((FeignException)((Object)ar.getException()));
            return null;
        }
        throw new OpenCashBackApiFalhaComunicacaoExcecao(ar.getException() != null ? ar.getException().getMessage() : "unknown");
    }

    public CustomersResponse postCustomers(PostCustomersBody body) throws OpenCashBackApiExcecao, OpenCashBackApiNaoAutorizadoExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        ApiResponse<CustomersResponse> ar = this.postCustomersComplete(body);
        int status = ar.getStatus();
        if (OpenCashBackStandaloneFacade.isStatusNoError(status)) {
            return ar.getBody();
        }
        if (ar.getException() instanceof FeignException) {
            this.handleFeignException((FeignException)((Object)ar.getException()));
        }
        throw new OpenCashBackApiFalhaComunicacaoExcecao(ar.getException() != null ? ar.getException().getMessage() : "unknown");
    }

    private void sanitizePostOrdersBody(PostOrdersBody body) {
        if (body == null) {
            return;
        }
        if (body.getPostOrdersItemBodyList() != null) {
            for (PostOrdersItemBody item : body.getPostOrdersItemBodyList()) {
                String desc;
                if (item == null || (desc = item.getDescription()) == null || desc.trim().isEmpty()) continue;
                item.setDescription(DescriptionSanitizer.sanitizeProductDescricao(desc));
            }
        }
        if (body.getOrigin() != null) {
            body.setOrigin(DescriptionSanitizer.sanitizeForSearch(body.getOrigin()));
        }
        if (body.getSeller() != null) {
            body.setSeller(DescriptionSanitizer.sanitizeForSearch(body.getSeller()));
        }
    }

    private void ensureAccessToken() {
        try {
            this.refreshIfNeeded();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to ensure access token: " + e.getMessage(), e);
        }
    }

    private String buildAuthHeader() {
        String t = this.currentAccessToken();
        if (t == null) {
            return null;
        }
        if (t.toLowerCase().startsWith("bearer ")) {
            return t;
        }
        return "Bearer " + t;
    }

    private int safeStatus(FeignException e) {
        try {
            return e.status();
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private String safeContent(FeignException e) {
        try {
            return e.contentUTF8();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private OpenCashBackErrorResponse parseErrorSafe(String raw) {
        if (raw == null || raw.trim().isEmpty()) {
            return null;
        }
        try {
            return (OpenCashBackErrorResponse)this.mapper.readValue(raw, OpenCashBackErrorResponse.class);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void handleFeignException(FeignException e) throws OpenCashBackApiExcecao, OpenCashBackApiNaoAutorizadoExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        int status = this.safeStatus(e);
        String body = this.safeContent(e);
        if (status == 401) {
            throw new OpenCashBackApiNaoAutorizadoExcecao(e.getMessage());
        }
        if (body != null && !body.trim().isEmpty()) {
            try {
                OpenCashBackErrorResponse err = (OpenCashBackErrorResponse)this.mapper.readValue(body, OpenCashBackErrorResponse.class);
                String msg = err != null && err.getMessage() != null && !err.getMessage().isEmpty() ? err.getMessage().get(0) : "OpenCashBack API error: " + status;
                OpenCashBackApiExcecao ex = new OpenCashBackApiExcecao("HTTP " + status + ": " + msg);
                if (err != null) {
                    ex.setErrorResponse(err);
                }
                ex.addSuppressed(new Throwable("rawBody: " + body));
                throw ex;
            }
            catch (Exception parseEx) {
                OpenCashBackApiExcecao ex = new OpenCashBackApiExcecao("HTTP " + status + ": " + body);
                ex.addSuppressed(parseEx);
                throw ex;
            }
        }
        throw new OpenCashBackApiExcecao("HTTP " + status + ": " + e.getMessage());
    }

    public OpenCashBackFeignClient getFeignClient() {
        return this.feignClient;
    }

    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public PostAuthResponse getAuthResponse() {
        return this.authResponse;
    }
}

