/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.client;

import com.opencashback.dto.ConfigurationsResponse;
import com.opencashback.dto.CustomerResponseDTO;
import com.opencashback.dto.CustomersResponse;
import com.opencashback.dto.OrdersResponse;
import com.opencashback.dto.PatchCustomersBody;
import com.opencashback.dto.PatchOrdersBody;
import com.opencashback.dto.PostAuthLoginBody;
import com.opencashback.dto.PostAuthRefreshBody;
import com.opencashback.dto.PostAuthResponse;
import com.opencashback.dto.PostCustomersBody;
import com.opencashback.dto.PostOrdersBody;
import com.opencashback.dto.PostValidateTokenBody;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import feign.Response;

public interface OpenCashBackFeignClient {
    @RequestLine(value="POST /auth/login")
    @Headers(value={"Content-Type: application/json"})
    public PostAuthResponse postAuthLogin(PostAuthLoginBody var1);

    @RequestLine(value="POST /auth/refresh")
    @Headers(value={"Content-Type: application/json"})
    public PostAuthResponse postAuthRefresh(PostAuthRefreshBody var1);

    @RequestLine(value="GET /configurations")
    @Headers(value={"Content-Type: application/json", "Authorization: {auth}"})
    public ConfigurationsResponse getConfigurations(@Param(value="auth") String var1);

    @RequestLine(value="GET /customers/{document}/wallet")
    @Headers(value={"Content-Type: application/json", "Authorization: {auth}"})
    public CustomersResponse getCustomers(@Param(value="auth") String var1, @Param(value="document") String var2);

    @RequestLine(value="POST /customers")
    @Headers(value={"Content-Type: application/json", "Authorization: {auth}"})
    public CustomersResponse postCustomers(@Param(value="auth") String var1, PostCustomersBody var2);

    @RequestLine(value="PATCH /customers/{document}")
    @Headers(value={"Content-Type: application/json", "Authorization: {auth}"})
    public CustomersResponse patchCustomers(@Param(value="auth") String var1, @Param(value="document") String var2, PatchCustomersBody var3);

    @RequestLine(value="PATCH /customers/{customerID}")
    @Headers(value={"Content-Type: application/json", "Authorization: {auth}"})
    public CustomerResponseDTO patchCustomer(@Param(value="auth") String var1, @Param(value="customerID") String var2, PostCustomersBody var3);

    @RequestLine(value="POST /orders/{external_id}/token")
    @Headers(value={"Authorization: {auth}"})
    public Void customerWalletToken(@Param(value="auth") String var1, @Param(value="external_id") String var2);

    @RequestLine(value="POST /orders/{external_id}/token/validate")
    @Headers(value={"Content-Type: application/json", "Authorization: {auth}"})
    public Response validateCustomerWalletToken(@Param(value="auth") String var1, @Param(value="external_id") String var2, PostValidateTokenBody var3);

    @RequestLine(value="POST /orders")
    @Headers(value={"Content-Type: application/json", "Authorization: {auth}"})
    public OrdersResponse postOrders(@Param(value="auth") String var1, PostOrdersBody var2);

    @RequestLine(value="PATCH /orders/{externalId}")
    @Headers(value={"Content-Type: application/json", "Authorization: {auth}"})
    public OrdersResponse patchOrders(@Param(value="auth") String var1, @Param(value="externalId") String var2, PatchOrdersBody var3);
}

