/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PostAuthResponse
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PostAuthResponse.class);
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="access_token_expire_at")
    private String accessTokenExpireAt;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    private LocalDateTime dataHora;
    private boolean producao;

    public PostAuthResponse() {
        this.dataHora = LocalDateTime.now();
    }

    public static PostAuthResponseBuilder builder() {
        return new PostAuthResponseBuilder();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAccessTokenExpireAt() {
        return this.accessTokenExpireAt;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public LocalDateTime getDataHora() {
        return this.dataHora;
    }

    public boolean isProducao() {
        return this.producao;
    }

    @JsonProperty(value="access_token")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @JsonProperty(value="access_token_expire_at")
    public void setAccessTokenExpireAt(String accessTokenExpireAt) {
        this.accessTokenExpireAt = accessTokenExpireAt;
    }

    @JsonProperty(value="refresh_token")
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setDataHora(LocalDateTime dataHora) {
        this.dataHora = dataHora;
    }

    public void setProducao(boolean producao) {
        this.producao = producao;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostAuthResponse)) {
            return false;
        }
        PostAuthResponse other = (PostAuthResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isProducao() != other.isProducao()) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$accessTokenExpireAt = this.getAccessTokenExpireAt();
        String other$accessTokenExpireAt = other.getAccessTokenExpireAt();
        if (this$accessTokenExpireAt == null ? other$accessTokenExpireAt != null : !this$accessTokenExpireAt.equals(other$accessTokenExpireAt)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        LocalDateTime this$dataHora = this.getDataHora();
        LocalDateTime other$dataHora = other.getDataHora();
        return !(this$dataHora == null ? other$dataHora != null : !((Object)this$dataHora).equals(other$dataHora));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostAuthResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isProducao() ? 79 : 97);
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $accessTokenExpireAt = this.getAccessTokenExpireAt();
        result = result * 59 + ($accessTokenExpireAt == null ? 43 : $accessTokenExpireAt.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        LocalDateTime $dataHora = this.getDataHora();
        result = result * 59 + ($dataHora == null ? 43 : ((Object)$dataHora).hashCode());
        return result;
    }

    public String toString() {
        return "PostAuthResponse(accessToken=" + this.getAccessToken() + ", accessTokenExpireAt=" + this.getAccessTokenExpireAt() + ", refreshToken=" + this.getRefreshToken() + ", dataHora=" + this.getDataHora() + ", producao=" + this.isProducao() + ")";
    }

    public PostAuthResponse(String accessToken, String accessTokenExpireAt, String refreshToken, LocalDateTime dataHora, boolean producao) {
        this.accessToken = accessToken;
        this.accessTokenExpireAt = accessTokenExpireAt;
        this.refreshToken = refreshToken;
        this.dataHora = dataHora;
        this.producao = producao;
    }

    public static class PostAuthResponseBuilder {
        private String accessToken;
        private String accessTokenExpireAt;
        private String refreshToken;
        private LocalDateTime dataHora;
        private boolean producao;

        PostAuthResponseBuilder() {
        }

        @JsonProperty(value="access_token")
        public PostAuthResponseBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @JsonProperty(value="access_token_expire_at")
        public PostAuthResponseBuilder accessTokenExpireAt(String accessTokenExpireAt) {
            this.accessTokenExpireAt = accessTokenExpireAt;
            return this;
        }

        @JsonProperty(value="refresh_token")
        public PostAuthResponseBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public PostAuthResponseBuilder dataHora(LocalDateTime dataHora) {
            this.dataHora = dataHora;
            return this;
        }

        public PostAuthResponseBuilder producao(boolean producao) {
            this.producao = producao;
            return this;
        }

        public PostAuthResponse build() {
            return new PostAuthResponse(this.accessToken, this.accessTokenExpireAt, this.refreshToken, this.dataHora, this.producao);
        }

        public String toString() {
            return "PostAuthResponse.PostAuthResponseBuilder(accessToken=" + this.accessToken + ", accessTokenExpireAt=" + this.accessTokenExpireAt + ", refreshToken=" + this.refreshToken + ", dataHora=" + this.dataHora + ", producao=" + this.producao + ")";
        }
    }
}

