/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.model;

import com.opencashback.dto.OrdersPaymentMethods;
import com.opencashback.dto.PatchOrdersBody;
import com.opencashback.dto.PostOrdersBody;
import com.opencashback.model.Cliente;
import com.opencashback.model.Configuracoes;
import com.opencashback.model.PedidoItem;
import com.opencashback.model.PedidoPagamento;
import com.opencashback.model.Usuario;
import com.opencashback.util.MoneyUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Pedido {
    private String numeroPedido;
    private String externalId;
    private Usuario usuario;
    private Cliente cliente;
    private LocalDateTime dataPedido;
    private BigDecimal valorTotal;
    private BigDecimal desconto;
    private boolean usarCashback;
    private BigDecimal cashback;
    private BigDecimal cashbackGerado;
    private List<PedidoItem> items = new ArrayList<PedidoItem>();
    private List<PedidoPagamento> pagamentos = new ArrayList<PedidoPagamento>();

    public PostOrdersBody toDTO(Configuracoes config) {
        PostOrdersBody order = new PostOrdersBody();
        order.setExternalId(this.numeroPedido);
        order.setDocument(this.cliente.getDocumento());
        order.setTotal(MoneyUtils.toCents(this.valorTotal));
        order.setDiscount(MoneyUtils.toCents(this.desconto));
        order.setFilial(config.getFilial());
        order.setSeller(config.getSeller());
        order.setOrigin(config.getOrigin());
        order.setChannel(config.getChannel());
        this.items.forEach(item -> order.getPostOrdersItemBodyList().add(item.toDTO()));
        return order;
    }

    private PatchOrdersBody toDTOPathIsInUse() {
        return this.toDTOPathIsInUse(false);
    }

    private PatchOrdersBody toDTOPathIsInUse(boolean canceled) {
        PatchOrdersBody patch = new PatchOrdersBody();
        patch.setStatus(canceled ? "cancelled" : "done");
        patch.setCashback(MoneyUtils.toCents(this.cashback));
        this.pagamentos.forEach(pagamento -> {
            OrdersPaymentMethods payment = new OrdersPaymentMethods();
            payment.setId(pagamento.getCodigo());
            payment.setName(pagamento.getNome());
            payment.setAmount(MoneyUtils.toCents(pagamento.getValor()));
            patch.getPatchOrdersPaymentMethodsBodyList().add(payment);
        });
        return patch;
    }

    private PatchOrdersBody toDTOPathIsUnsed() {
        return this.toDTOPathIsUnsed(false);
    }

    private PatchOrdersBody toDTOPathIsUnsed(boolean canceled) {
        PatchOrdersBody patch = new PatchOrdersBody();
        patch.setStatus(canceled ? "cancelled" : "done");
        patch.setCashback(0);
        return patch;
    }

    public PatchOrdersBody toDTO() {
        return this.toDTO(false);
    }

    public PatchOrdersBody toDTO(boolean canceled) {
        return !this.usarCashback ? this.toDTOPathIsUnsed(canceled) : (this.usandoCashback() ? this.toDTOPathIsInUse(canceled) : this.toDTOPathIsUnsed(canceled));
    }

    public boolean usandoCashback() {
        return Optional.of(this.cashback).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) > 0;
    }

    public String getNumeroPedido() {
        return this.numeroPedido;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    public LocalDateTime getDataPedido() {
        return this.dataPedido;
    }

    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    public BigDecimal getDesconto() {
        return this.desconto;
    }

    public boolean isUsarCashback() {
        return this.usarCashback;
    }

    public BigDecimal getCashback() {
        return this.cashback;
    }

    public BigDecimal getCashbackGerado() {
        return this.cashbackGerado;
    }

    public List<PedidoItem> getItems() {
        return this.items;
    }

    public List<PedidoPagamento> getPagamentos() {
        return this.pagamentos;
    }

    public void setNumeroPedido(String numeroPedido) {
        this.numeroPedido = numeroPedido;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public void setDataPedido(LocalDateTime dataPedido) {
        this.dataPedido = dataPedido;
    }

    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    public void setDesconto(BigDecimal desconto) {
        this.desconto = desconto;
    }

    public void setUsarCashback(boolean usarCashback) {
        this.usarCashback = usarCashback;
    }

    public void setCashback(BigDecimal cashback) {
        this.cashback = cashback;
    }

    public void setCashbackGerado(BigDecimal cashbackGerado) {
        this.cashbackGerado = cashbackGerado;
    }

    public void setItems(List<PedidoItem> items) {
        this.items = items;
    }

    public void setPagamentos(List<PedidoPagamento> pagamentos) {
        this.pagamentos = pagamentos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pedido)) {
            return false;
        }
        Pedido other = (Pedido)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUsarCashback() != other.isUsarCashback()) {
            return false;
        }
        String this$numeroPedido = this.getNumeroPedido();
        String other$numeroPedido = other.getNumeroPedido();
        if (this$numeroPedido == null ? other$numeroPedido != null : !this$numeroPedido.equals(other$numeroPedido)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        Usuario this$usuario = this.getUsuario();
        Usuario other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !((Object)this$usuario).equals(other$usuario)) {
            return false;
        }
        Cliente this$cliente = this.getCliente();
        Cliente other$cliente = other.getCliente();
        if (this$cliente == null ? other$cliente != null : !((Object)this$cliente).equals(other$cliente)) {
            return false;
        }
        LocalDateTime this$dataPedido = this.getDataPedido();
        LocalDateTime other$dataPedido = other.getDataPedido();
        if (this$dataPedido == null ? other$dataPedido != null : !((Object)this$dataPedido).equals(other$dataPedido)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        BigDecimal this$desconto = this.getDesconto();
        BigDecimal other$desconto = other.getDesconto();
        if (this$desconto == null ? other$desconto != null : !((Object)this$desconto).equals(other$desconto)) {
            return false;
        }
        BigDecimal this$cashback = this.getCashback();
        BigDecimal other$cashback = other.getCashback();
        if (this$cashback == null ? other$cashback != null : !((Object)this$cashback).equals(other$cashback)) {
            return false;
        }
        BigDecimal this$cashbackGerado = this.getCashbackGerado();
        BigDecimal other$cashbackGerado = other.getCashbackGerado();
        if (this$cashbackGerado == null ? other$cashbackGerado != null : !((Object)this$cashbackGerado).equals(other$cashbackGerado)) {
            return false;
        }
        List<PedidoItem> this$items = this.getItems();
        List<PedidoItem> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        List<PedidoPagamento> this$pagamentos = this.getPagamentos();
        List<PedidoPagamento> other$pagamentos = other.getPagamentos();
        return !(this$pagamentos == null ? other$pagamentos != null : !((Object)this$pagamentos).equals(other$pagamentos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pedido;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUsarCashback() ? 79 : 97);
        String $numeroPedido = this.getNumeroPedido();
        result = result * 59 + ($numeroPedido == null ? 43 : $numeroPedido.hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        Usuario $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : ((Object)$usuario).hashCode());
        Cliente $cliente = this.getCliente();
        result = result * 59 + ($cliente == null ? 43 : ((Object)$cliente).hashCode());
        LocalDateTime $dataPedido = this.getDataPedido();
        result = result * 59 + ($dataPedido == null ? 43 : ((Object)$dataPedido).hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        BigDecimal $desconto = this.getDesconto();
        result = result * 59 + ($desconto == null ? 43 : ((Object)$desconto).hashCode());
        BigDecimal $cashback = this.getCashback();
        result = result * 59 + ($cashback == null ? 43 : ((Object)$cashback).hashCode());
        BigDecimal $cashbackGerado = this.getCashbackGerado();
        result = result * 59 + ($cashbackGerado == null ? 43 : ((Object)$cashbackGerado).hashCode());
        List<PedidoItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        List<PedidoPagamento> $pagamentos = this.getPagamentos();
        result = result * 59 + ($pagamentos == null ? 43 : ((Object)$pagamentos).hashCode());
        return result;
    }

    public String toString() {
        return "Pedido(numeroPedido=" + this.getNumeroPedido() + ", externalId=" + this.getExternalId() + ", usuario=" + this.getUsuario() + ", cliente=" + this.getCliente() + ", dataPedido=" + this.getDataPedido() + ", valorTotal=" + this.getValorTotal() + ", desconto=" + this.getDesconto() + ", usarCashback=" + this.isUsarCashback() + ", cashback=" + this.getCashback() + ", cashbackGerado=" + this.getCashbackGerado() + ", items=" + this.getItems() + ", pagamentos=" + this.getPagamentos() + ")";
    }

    public Pedido(String numeroPedido, String externalId, Usuario usuario, Cliente cliente, LocalDateTime dataPedido, BigDecimal valorTotal, BigDecimal desconto, boolean usarCashback, BigDecimal cashback, BigDecimal cashbackGerado, List<PedidoItem> items, List<PedidoPagamento> pagamentos) {
        this.numeroPedido = numeroPedido;
        this.externalId = externalId;
        this.usuario = usuario;
        this.cliente = cliente;
        this.dataPedido = dataPedido;
        this.valorTotal = valorTotal;
        this.desconto = desconto;
        this.usarCashback = usarCashback;
        this.cashback = cashback;
        this.cashbackGerado = cashbackGerado;
        this.items = items;
        this.pagamentos = pagamentos;
    }

    public Pedido() {
    }
}

