/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.service;

import com.opencashback.OpenCashBackUtil;
import com.opencashback.dto.CustomerResponseDTO;
import com.opencashback.dto.CustomersResponse;
import com.opencashback.exception.OpenCashBackApiExcecao;
import com.opencashback.exception.OpenCashBackApiFalhaComunicacaoExcecao;
import com.opencashback.model.Cliente;
import com.opencashback.util.MoneyUtils;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClienteService {
    private static final Logger log = LoggerFactory.getLogger(ClienteService.class);

    public static CustomersResponse consultarCliente(Cliente cliente) throws OpenCashBackApiExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        log.info("Consultando cliente...");
        CustomersResponse customersResponse = OpenCashBackUtil.consultarCliente(cliente);
        log.info("Cliente consultado {}", (Object)customersResponse);
        return customersResponse;
    }

    public static BigDecimal consultar(Cliente cliente) throws OpenCashBackApiExcecao {
        log.info("Consultando cliente...");
        CustomersResponse customersResponse = OpenCashBackUtil.consultarCliente(cliente);
        BigDecimal valorCashback = MoneyUtils.fromCents(customersResponse.getBalance());
        log.info("Cliente tem {} para gastar em cashback", (Object)valorCashback);
        return valorCashback;
    }

    public static CustomerResponseDTO atualizar(Cliente cliente) throws OpenCashBackApiExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        log.info("Atualizando cliente...");
        CustomerResponseDTO customerResponseDTO = OpenCashBackUtil.atualizarCliente(cliente);
        log.info("Cliente atualizado {} ", (Object)customerResponseDTO);
        return customerResponseDTO;
    }
}

