/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.service;

import com.opencashback.OpenCashBackUtil;
import com.opencashback.dto.OrdersResponse;
import com.opencashback.dto.PostValidateTokenBody;
import com.opencashback.exception.OpenCashBackApiExcecao;
import com.opencashback.exception.OpenCashBackApiFalhaComunicacaoExcecao;
import com.opencashback.model.Pedido;
import com.opencashback.util.MoneyUtils;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PedidoService {
    private static final Logger log = LoggerFactory.getLogger(PedidoService.class);

    public static void registrarPedido(Pedido pedido) throws OpenCashBackApiExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        OrdersResponse consultarUso = OpenCashBackUtil.enviar(pedido);
        if (!pedido.isUsarCashback()) {
            pedido.setCashback(BigDecimal.ZERO);
            log.info("Cliente deseja acumular o cashback para pr\u00f3xima compra..");
        } else {
            pedido.setCashback(MoneyUtils.fromCents(consultarUso.getCashbackLimit()));
            log.info("Cliente pode usar {} de cashback", (Object)pedido.getCashback());
        }
    }

    public static Pedido confirmar(Pedido pedido) throws OpenCashBackApiExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        log.info("Enviando confirma\u00e7\u00e3o de pedido {}", (Object)pedido.getNumeroPedido());
        OrdersResponse response = OpenCashBackUtil.confirmar(pedido);
        if (response != null && "done".equals(response.getStatus())) {
            log.info("Pedido confirmado, consumo de cashback de : R$ {}", (Object)MoneyUtils.fromCents(response.getCashback()));
            pedido.setCashbackGerado(MoneyUtils.fromCents(response.getCashbackReceived()));
            log.info("Pedido teve {} de cashback gerado", (Object)pedido.getCashbackGerado());
        } else {
            log.error("N\u00e3o foi confirmado o cashback usado no pedido {}...", (Object)pedido.getNumeroPedido());
        }
        return pedido;
    }

    public static Pedido cancelar(Pedido pedido) throws OpenCashBackApiExcecao, OpenCashBackApiFalhaComunicacaoExcecao {
        log.info("Enviando confirma\u00e7\u00e3o de pedido de cancelamento {}", (Object)pedido.getNumeroPedido());
        OrdersResponse response = OpenCashBackUtil.cancelar(pedido);
        if (response != null && "cancelled".equals(response.getStatus())) {
            log.info("Pedido confirmado, consumo de cashback de : R$ {} devolvido", (Object)MoneyUtils.fromCents(response.getCashback()));
        } else {
            log.error("N\u00e3o foi confirmado o cancelamento de cashback usado no pedido {}...", (Object)pedido.getNumeroPedido());
        }
        return pedido;
    }

    public static void pedirToken(String external_id) throws OpenCashBackApiExcecao {
        log.info("Validando token");
        OpenCashBackUtil.gerarTokenCarteira(external_id);
    }

    public static boolean validarToken(String documento, PostValidateTokenBody body) throws OpenCashBackApiExcecao {
        log.info("Validando token");
        return OpenCashBackUtil.validarTokenCarteira(documento, body);
    }
}

