/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.standalone;

import com.opencashback.dto.OpenCashBackErrorResponse;

public class ApiResponse<T> {
    private final int status;
    private final T body;
    private final String rawBody;
    private final OpenCashBackErrorResponse error;
    private final Exception exception;

    public ApiResponse(int status, T body, String rawBody, OpenCashBackErrorResponse error, Exception exception) {
        this.status = status;
        this.body = body;
        this.rawBody = rawBody;
        this.error = error;
        this.exception = exception;
    }

    public static <T> ApiResponse<T> success(int status, T body) {
        return new ApiResponse<T>(status, body, null, null, null);
    }

    public static <T> ApiResponse<T> error(int status, String rawBody, OpenCashBackErrorResponse error, Exception exception) {
        return new ApiResponse<Object>(status, null, rawBody, error, exception);
    }

    public String toString() {
        return "ApiResponse{status=" + this.status + ", body=" + this.body + ", rawBody='" + this.rawBody + '\'' + ", error=" + this.error + ", exception=" + this.exception + '}';
    }

    public int getStatus() {
        return this.status;
    }

    public T getBody() {
        return this.body;
    }

    public String getRawBody() {
        return this.rawBody;
    }

    public OpenCashBackErrorResponse getError() {
        return this.error;
    }

    public Exception getException() {
        return this.exception;
    }
}

