/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.standalone;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenProvider {
    private static final Logger log = LoggerFactory.getLogger(TokenProvider.class);
    private volatile String accessToken;
    private volatile String refreshToken;

    public String getAccessToken() {
        return this.accessToken;
    }

    public synchronized void setAccessToken(String token) {
        this.accessToken = token;
        log.debug("[TokenProvider] access token updated (masked) = {}", (Object)this.mask(token));
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public synchronized void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        log.debug("[TokenProvider] refresh token set (masked) = {}", (Object)this.mask(refreshToken));
    }

    public synchronized void clear() {
        this.accessToken = null;
        this.refreshToken = null;
        log.debug("[TokenProvider] tokens cleared");
    }

    private String mask(String t) {
        if (t == null) {
            return null;
        }
        if (t.length() <= 12) {
            return t;
        }
        return t.substring(0, 6) + "..." + t.substring(t.length() - 6);
    }
}

