/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.util;

import java.text.Normalizer;

public final class DescriptionSanitizer {
    private DescriptionSanitizer() {
    }

    public static String sanitizeForSearch(String input) {
        return DescriptionSanitizer.sanitizeCore(input);
    }

    public static String sanitizeForOutput(String input) {
        return DescriptionSanitizer.sanitizeCore(input);
    }

    public static String sanitizeProductDescricao(String input) {
        return DescriptionSanitizer.sanitizeCore(input);
    }

    private static String sanitizeCore(String input) {
        if (input == null) {
            return null;
        }
        String s = input.trim();
        if (s.isEmpty()) {
            return s;
        }
        String normalized = Normalizer.normalize(s, Normalizer.Form.NFD);
        String noAccents = normalized.replaceAll("\\p{M}", "");
        String cleaned = noAccents.replaceAll("[\\p{Cntrl}]", " ");
        cleaned = cleaned.replaceAll("[^A-Za-z0-9 \\-_]", " ");
        cleaned = cleaned.replaceAll("\\s+", " ").trim();
        cleaned = cleaned.toUpperCase();
        return cleaned;
    }
}

