/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;

public final class MoneyUtils {
    private static final BigDecimal HUNDRED = BigDecimal.valueOf(100L);

    private MoneyUtils() {
    }

    public static int toCents(BigDecimal amount) {
        if (amount == null) {
            return 0;
        }
        return MoneyUtils.toMinorUnits(amount, 2, RoundingMode.HALF_UP);
    }

    public static int toMinorUnits(BigDecimal amount, int fractionDigits, RoundingMode roundingMode) {
        Objects.requireNonNull(amount, "amount required");
        if (fractionDigits < 0) {
            throw new IllegalArgumentException("fractionDigits must be >= 0");
        }
        if (roundingMode == null) {
            roundingMode = RoundingMode.HALF_UP;
        }
        BigDecimal multiplier = BigDecimal.ONE.movePointRight(fractionDigits);
        BigDecimal minor = amount.multiply(multiplier).setScale(0, roundingMode);
        return minor.intValueExact();
    }

    public static long toCentsOrZero(BigDecimal amount) {
        if (amount == null) {
            return 0L;
        }
        return MoneyUtils.toCents(amount);
    }

    public static BigDecimal fromCents(Integer cents) {
        if (cents == null) {
            return BigDecimal.ZERO;
        }
        return MoneyUtils.fromMinorUnits(cents.intValue(), 2);
    }

    public static BigDecimal fromMinorUnits(long minorUnits, int fractionDigits) {
        if (fractionDigits < 0) {
            throw new IllegalArgumentException("fractionDigits must be >= 0");
        }
        return new BigDecimal(BigInteger.valueOf(minorUnits), fractionDigits);
    }

    public static BigDecimal fromCentsOrNull(Integer cents) {
        if (cents == null) {
            return BigDecimal.ZERO;
        }
        return MoneyUtils.fromCents(cents);
    }

    public static BigDecimal fromMinorUnitsOrNull(Long minorUnits, int fractionDigits) {
        if (minorUnits == null) {
            return null;
        }
        return MoneyUtils.fromMinorUnits(minorUnits, fractionDigits);
    }

    public static String formatAmount(BigDecimal amount, int fractionDigits) {
        if (amount == null) {
            return "null";
        }
        Objects.requireNonNull(amount);
        if (fractionDigits < 0) {
            throw new IllegalArgumentException("fractionDigits must be >= 0");
        }
        return amount.setScale(fractionDigits).toPlainString();
    }
}

