/*
 * Decompiled with CFR 0.152.
 */
package com.opencashback.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TextoUtils {
    public static final String IGNORA_PARAMETRO_REQUISICAO = "ignoraParametroRequisicao";
    public static final int NOT_FOUND = -1;

    public static String removerAcentos(String src) {
        if (StringUtils.isBlank((String)src)) {
            return src;
        }
        src = src.replace("&amp;", "E").replace("&", "E");
        src = Normalizer.normalize(src, Normalizer.Form.NFD);
        src = src.replaceAll("[^\\p{ASCII}]", "");
        return src;
    }

    public static String retirarAcentos(String s, boolean removeEComecial) {
        if (StringUtils.isBlank((String)s)) {
            return s;
        }
        if (removeEComecial) {
            s = s.replace("&amp;", "E");
            s = s.replace("&", "E");
        }
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        s = s.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return s;
    }

    public static String formatarNumero(Long numero) {
        return NumberFormat.getInstance().format(numero);
    }

    public static String formatarNumero(Double numero) {
        return NumberFormat.getInstance().format(numero);
    }

    public static String formatarNumero(BigDecimal numero, Integer minimumMaximumFractionDigits) {
        if (minimumMaximumFractionDigits != null) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(minimumMaximumFractionDigits);
            numberFormat.setMinimumFractionDigits(minimumMaximumFractionDigits);
            String format = numberFormat.format(numero);
            return format;
        }
        String format = NumberFormat.getInstance().format(numero);
        return format;
    }

    public static String formatarValor(String valor) {
        try {
            Double aDouble = Double.valueOf(valor);
            String valorFormatado = NumberFormat.getCurrencyInstance().format(aDouble);
            return valorFormatado;
        }
        catch (NumberFormatException e) {
            return valor;
        }
    }

    public static String formatarValor(Double valor) {
        String valorFormatado = NumberFormat.getCurrencyInstance().format(valor);
        return valorFormatado;
    }

    public static String formatarValor(BigDecimal valor) {
        if (valor == null) {
            valor = BigDecimal.ZERO;
        }
        String valorFormatado = NumberFormat.getCurrencyInstance().format(valor);
        return valorFormatado;
    }

    public static String formatarValor(BigDecimal valor, Integer minimumMaximumFractionDigits) {
        if (valor == null) {
            valor = BigDecimal.ZERO;
        }
        NumberFormat currencyInstance = NumberFormat.getCurrencyInstance();
        currencyInstance.setMinimumFractionDigits(minimumMaximumFractionDigits);
        currencyInstance.setMaximumFractionDigits(minimumMaximumFractionDigits);
        String valorFormatado = currencyInstance.format(valor);
        return valorFormatado;
    }

    public static String formatarValorSemEspacoSimboloMoeda(BigDecimal valor) {
        if (valor == null) {
            valor = BigDecimal.ZERO;
        }
        String formatarValor = TextoUtils.formatarValor(valor);
        formatarValor = formatarValor.replace("R$ ", "R$");
        return formatarValor;
    }

    public static String formatarValorSemSimboloMoeda(BigDecimal valor) {
        if (valor == null) {
            valor = BigDecimal.ZERO;
        }
        String formatarValor = TextoUtils.formatarValor(valor);
        formatarValor = formatarValor.replace("R$ ", "");
        return formatarValor;
    }

    public static String formatarValorPadraoAmericano(BigDecimal valor) {
        if (valor == null) {
            valor = BigDecimal.ZERO;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        String valorFormatado = numberFormat.format(valor);
        return valorFormatado;
    }

    public static String formatarPorcentagem(BigDecimal valor, Integer digitos) {
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMinimumFractionDigits(digitos);
        BigDecimal valorDividido = valor.setScale(4, RoundingMode.HALF_EVEN).divide(BigDecimal.valueOf(100.0).setScale(4, RoundingMode.HALF_EVEN), RoundingMode.HALF_EVEN);
        String valorFormatado = percentFormat.format(valorDividido);
        return valorFormatado;
    }

    public static String retornaSomenteNumeros(String str) {
        if (str != null) {
            return str.replaceAll("[^0123456789]", "");
        }
        return "";
    }

    public static String removeEspacos(String texto) {
        return StringUtils.isNotBlank((String)texto) ? texto.replace(" ", "") : texto;
    }

    public static String trocaEspacosPorUndeline(String texto) {
        return texto.replace(" ", "_");
    }

    public static String trocaEspacosPorHifem(String texto) {
        return texto.replace(" ", "-");
    }

    public static String ajustaEspacos(String texto) {
        if (StringUtils.isBlank((String)texto)) {
            return texto;
        }
        String textoTratado = texto.replaceAll("\\s+", " ").replaceAll("\\s+$", "").replaceAll("^\\s+", "").replaceAll("\u00a0", " ");
        return textoTratado;
    }

    public static String removeMaiorMenor(String texto) {
        if (StringUtils.isBlank((String)texto)) {
            return texto;
        }
        return texto.replace(">", "").replace("<", "");
    }

    public static String removePontoBarraUnderlineTracoParenteseChaveCochete(String texto) {
        if (StringUtils.isBlank((String)texto)) {
            return texto;
        }
        return texto.replace(".", "").replace("/", "").replace("\\", "").replace("-", "").replace("_", "").replace("(", "").replace(")", "").replace("{", "").replace("}", "").replace("[", "").replace("]", "");
    }

    public static String removeTravessao(String texto) {
        if (StringUtils.isBlank((String)texto)) {
            return texto;
        }
        return texto.replace("\u2013", "");
    }

    public static String removeAlgunsCaracteresEspeciais(String texto) {
        if (StringUtils.isBlank((String)texto)) {
            return texto;
        }
        texto = TextoUtils.removerAcentos(texto);
        return texto.replace("\\", "").replace("(", "").replace(")", "").replace("{", "").replace("}", "").replace("[", "").replace("]", "").replace(";", "").replace("+", "").replace("!", "").replace("@", "").replace("#", "").replace("$", "").replace("%", "").replace("\u00a8", "").replace("&", "").replace("*", "").replace("=", "").replace("'", "").replace("\"", "").replace("\u0007", "");
    }

    public static String removeAlgunsCaracteresEspeciais2(String texto) {
        if (StringUtils.isBlank((String)texto)) {
            return texto;
        }
        texto = TextoUtils.removerAcentos(texto);
        return texto.replace("\\", "").replace("{", "").replace("}", "").replace("[", "").replace("]", "").replace(";", "").replace("+", "").replace("\u00a8", "").replace("&", "").replace("'", "").replace("\"", "").replace("\u0007", "");
    }

    public static String removeTodosCaracteresEspeciais(String texto) {
        if (StringUtils.isBlank((String)texto)) {
            return texto;
        }
        texto = TextoUtils.removerAcentos(texto);
        return texto.replace(".", "").replace(",", "").replace("/", "").replace("\\", "").replace("-", "").replace("_", "").replace("(", "").replace(")", "").replace("{", "").replace("}", "").replace("[", "").replace("]", "").replace("+", "").replace("!", "").replace("@", "").replace("#", "").replace("$", "").replace("%", "").replace("\u00a8", "").replace("&", "").replace("*", "").replace("=", "").replace("'", "").replace("\"", "").replace("\u0007", "");
    }

    public static String ajustaLimiteCaracterToUpperCaseTrim(String campo, int campoInicio, int campoFinal) {
        String retorno = null;
        if (StringUtils.isNotBlank((String)campo)) {
            if (campo.length() > campoFinal) {
                retorno = campo.substring(campoInicio, campoFinal);
            } else if (campo.length() < campoFinal && campo.length() > campoInicio) {
                retorno = campo.substring(campoInicio, campo.length());
            } else {
                campo = StringUtils.rightPad((String)campo, (int)campoFinal, (String)" ");
                retorno = campo.substring(campoInicio, campoFinal);
            }
            retorno = retorno.toUpperCase().trim();
        }
        return retorno;
    }

    public static String ajustaCaracterToLowerCaseTrim(String campo) {
        if (StringUtils.isNotBlank((String)campo)) {
            return campo.toLowerCase().trim();
        }
        return null;
    }

    public static String ajustaCaracterToUpperCaseFirstLetterOnlyTrim(String campo) {
        if (StringUtils.isNotBlank((String)campo)) {
            String lowerCase = campo.toLowerCase();
            String capitalize = StringUtils.capitalize((String)lowerCase);
            return capitalize;
        }
        return null;
    }

    public static String ajustaCaracterToUpperCaseTrim(String campo) {
        if (StringUtils.isNotBlank((String)campo)) {
            return campo.toUpperCase().trim();
        }
        return null;
    }

    public static String ajustaLimiteCaracter(String texto, int tamanhoMaximo) {
        String left = StringUtils.left((String)texto, (int)tamanhoMaximo);
        return left;
    }

    public static String ajustaLimiteCaracterToUpperCaseTrim(String texto, int tamanhoMaximo) {
        String left = StringUtils.left((String)texto, (int)tamanhoMaximo);
        if (StringUtils.isNotBlank((String)left)) {
            return left.toUpperCase().trim();
        }
        return left;
    }

    public static boolean validarPlaca(String placa) {
        boolean placaValida = true;
        if (placa.length() > 0) {
            if (placa.length() < 7) {
                placaValida = false;
            } else if (!placa.matches("[a-zA-Z]{3}[0-9a-zA-Z]{4}")) {
                placaValida = false;
            }
        }
        return placaValida;
    }

    public static String retornaCufChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)0, (int)2);
        return substring;
    }

    public static String retornaAnoChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)2, (int)4);
        return substring;
    }

    public static String retornaMesChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)4, (int)6);
        return substring;
    }

    public static String retornaCnpjChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)6, (int)20);
        return substring;
    }

    public static String retornaModChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)20, (int)22);
        return substring;
    }

    public static String retornaSerieChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)22, (int)25);
        return substring;
    }

    public static String retornaNnfChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)25, (int)34);
        return substring;
    }

    public static String retornaTpEmisChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)34, (int)35);
        return substring;
    }

    public static String retornaCnfChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)35, (int)43);
        return substring;
    }

    public static String retornaDvChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)43, (int)44);
        return substring;
    }

    public static boolean isChaveNf(String chave) {
        if (StringUtils.isBlank((String)chave)) {
            return false;
        }
        if (!StringUtils.isNumeric((String)chave)) {
            return false;
        }
        return chave.length() == 44;
    }

    private static String humanReadableByteCount(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "" + "kMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String removeMascaraTelefone(String telefone, boolean adicona55) {
        if (StringUtils.isNotBlank((String)(telefone = TextoUtils.removePontoBarraUnderlineTracoParenteseChaveCochete(telefone)))) {
            telefone = StringUtils.trim((String)telefone);
        }
        if (StringUtils.isNotBlank((String)telefone)) {
            telefone = TextoUtils.removeEspacos(telefone);
        }
        if (StringUtils.isBlank((String)telefone) || !StringUtils.isNumeric((String)telefone)) {
            return null;
        }
        if (telefone.length() == 8 || telefone.length() == 9) {
            telefone = "00".concat(telefone);
        }
        if (adicona55) {
            telefone = "55".concat(telefone);
        }
        return telefone;
    }

    public static String retornaDddTelefone(String telefone) {
        telefone = TextoUtils.removePontoBarraUnderlineTracoParenteseChaveCochete(telefone);
        if (StringUtils.isBlank((String)(telefone = TextoUtils.removeEspacos(telefone))) || !StringUtils.isNumeric((String)telefone)) {
            return null;
        }
        if (telefone.length() == 8 || telefone.length() == 9) {
            telefone = "00".concat(telefone);
        }
        return telefone.length() >= 2 ? telefone.substring(0, 2) : telefone;
    }

    public static String retornaTelefoneSemDdd(String telefone) {
        telefone = TextoUtils.removePontoBarraUnderlineTracoParenteseChaveCochete(telefone);
        if (StringUtils.isBlank((String)(telefone = TextoUtils.removeEspacos(telefone))) || !StringUtils.isNumeric((String)telefone)) {
            return null;
        }
        if (telefone.length() == 8 || telefone.length() == 9) {
            telefone = "00".concat(telefone);
        }
        String retorno = telefone;
        if (telefone.length() == 10 || telefone.length() == 11) {
            return StringUtils.substring((String)telefone, (int)2);
        }
        return retorno;
    }

    public static boolean validaTelefoneCelular(String telefone) {
        String retornaTelefoneSemDdd = TextoUtils.retornaTelefoneSemDdd(telefone);
        if (retornaTelefoneSemDdd != null) {
            if (retornaTelefoneSemDdd.length() == 9) {
                return true;
            }
            if (retornaTelefoneSemDdd.length() == 8 && retornaTelefoneSemDdd.startsWith("9")) {
                return true;
            }
        }
        return false;
    }

    public static List<String> dividirEmPartes(String texto, int tamanho) {
        if (StringUtils.isEmpty((String)texto)) {
            return null;
        }
        String[] tokens = texto.split("(?<=\\G.{" + tamanho + "})");
        return Arrays.asList(tokens);
    }

    public static List<String> dividirEmPartesTipo2(String texto, int tamanho) {
        if (StringUtils.isEmpty((String)texto)) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        for (int start = 0; start < texto.length(); start += tamanho) {
            tokens.add(texto.substring(start, Math.min(texto.length(), start + tamanho)));
        }
        return tokens;
    }

    public static String retornaValorSemFormatacao(BigDecimal valor) {
        if (valor == null) {
            return "null";
        }
        String toString = valor.toString().replace(".", "");
        return toString;
    }

    public static String ajustaItemListaServicoModernizacaoPublica(String infRpsServicoItemListaServico) {
        if (infRpsServicoItemListaServico != null) {
            if (infRpsServicoItemListaServico.length() == 4) {
                String substring1 = infRpsServicoItemListaServico.substring(0, 2);
                String substring2 = infRpsServicoItemListaServico.substring(2, 4);
                return substring1 + "." + substring2;
            }
            if (infRpsServicoItemListaServico.length() == 3) {
                String substring1 = infRpsServicoItemListaServico.substring(0, 1);
                String substring2 = infRpsServicoItemListaServico.substring(1, 3);
                return substring1 + "." + substring2;
            }
            return infRpsServicoItemListaServico;
        }
        return null;
    }

    public static String formatarData(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "null";
        }
        String format = localDateTime.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        return format;
    }

    public static String formatarDataHora(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "null";
        }
        String format = localDateTime.format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"));
        return format;
    }

    public static String formatarDataHoraCurto(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "null";
        }
        String format = localDateTime.format(DateTimeFormatter.ofPattern("dd/MM HH:mm"));
        return format;
    }

    public static String formatarData(LocalDate localDate) {
        if (localDate == null) {
            return "null";
        }
        String format = localDate.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        return format;
    }

    public static String prettyPrintJSON(String unformattedJsonString) {
        StringBuilder prettyJSONBuilder = new StringBuilder();
        int indentLevel = 0;
        boolean inQuote = false;
        block7: for (char charFromUnformattedJson : unformattedJsonString.toCharArray()) {
            switch (charFromUnformattedJson) {
                case '\"': {
                    inQuote = !inQuote;
                    prettyJSONBuilder.append(charFromUnformattedJson);
                    continue block7;
                }
                case ' ': {
                    if (!inQuote) continue block7;
                    prettyJSONBuilder.append(charFromUnformattedJson);
                    continue block7;
                }
                case '[': 
                case '{': {
                    prettyJSONBuilder.append(charFromUnformattedJson);
                    TextoUtils.appendIndentedNewLine(++indentLevel, prettyJSONBuilder);
                    continue block7;
                }
                case ']': 
                case '}': {
                    TextoUtils.appendIndentedNewLine(--indentLevel, prettyJSONBuilder);
                    prettyJSONBuilder.append(charFromUnformattedJson);
                    continue block7;
                }
                case ',': {
                    prettyJSONBuilder.append(charFromUnformattedJson);
                    if (inQuote) continue block7;
                    TextoUtils.appendIndentedNewLine(indentLevel, prettyJSONBuilder);
                    continue block7;
                }
                default: {
                    prettyJSONBuilder.append(charFromUnformattedJson);
                }
            }
        }
        return prettyJSONBuilder.toString();
    }

    private static void appendIndentedNewLine(int indentLevel, StringBuilder stringBuilder) {
        stringBuilder.append("\n");
        for (int i = 0; i < indentLevel; ++i) {
            stringBuilder.append("  ");
        }
    }

    public static int lastIndexOfRegex(String str, String toFind) {
        Pattern pattern = Pattern.compile(toFind);
        Matcher matcher = pattern.matcher(str);
        int lastIndex = -1;
        while (matcher.find()) {
            lastIndex = matcher.start();
        }
        return lastIndex;
    }

    public static int lastIndexOfRegex(String str, String toFind, int fromIndex) {
        return TextoUtils.lastIndexOfRegex(str.substring(0, fromIndex), toFind);
    }

    public static String breakStringToLines(String str, int maxLength, String newLineString) {
        StringBuilder result = new StringBuilder();
        while (str.length() > maxLength) {
            int breakingIndex = TextoUtils.lastIndexOfRegex(str, "\\s", maxLength);
            if (breakingIndex == -1) {
                breakingIndex = TextoUtils.lastIndexOfRegex(str, "[^a-zA-Z0-9]", maxLength);
            }
            if (breakingIndex == -1) {
                breakingIndex = maxLength;
            }
            result.append(str.substring(0, breakingIndex + 1));
            result.append(newLineString);
            str = str.substring(breakingIndex + 1);
        }
        if (str.length() > 0) {
            result.append(str);
        }
        return result.toString();
    }

    public static String adicionaZeroDireita(String texto, Integer tamanhoTotal) {
        String leftPad = StringUtils.rightPad((String)texto, (int)tamanhoTotal, (String)"0");
        return leftPad;
    }

    public static String adicionaZeroEsquerda(String texto, Integer tamanhoTotal) {
        String leftPad = StringUtils.leftPad((String)texto, (int)tamanhoTotal, (String)"0");
        return leftPad;
    }

    public static String completarComZeroEsquerda(int tamanhoTotal, String texto) {
        String adicionaZeroEsquerda = TextoUtils.adicionaZeroEsquerda(texto, tamanhoTotal);
        return adicionaZeroEsquerda;
    }

    public static String completarComEspacoDireita(int tamanho, String valor) {
        String retorno = null;
        retorno = StringUtils.rightPad((String)valor, (int)tamanho, (String)" ");
        return retorno;
    }

    public static String retornaUuid() {
        UUID randomUUID = UUID.randomUUID();
        return randomUUID.toString();
    }

    public static String toBase64(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String encodeToString = Base64.getEncoder().encodeToString(bytes);
        return encodeToString;
    }

    public static String retornaConteudo(String nomeFantazia, String telefone, String tipoDocumento) {
        StringBuilder stringBuilderConteudo = new StringBuilder();
        stringBuilderConteudo.append("Ol\u00e1, estou enviando o documento " + tipoDocumento + " para visualiza\u00e7\u00e3o!");
        stringBuilderConteudo.append("\n");
        String conterudo = stringBuilderConteudo.toString();
        return conterudo;
    }

    public static String trocaNumroPorPalavras(String texto) {
        if (StringUtils.isBlank((String)texto)) {
            return texto;
        }
        texto = texto.replace("0", "ZERO");
        texto = texto.replace("1", "UM");
        texto = texto.replace("2", "DOIS");
        texto = texto.replace("3", "TR\u00caS");
        texto = texto.replace("4", "QUATRO");
        texto = texto.replace("5", "CINCO");
        texto = texto.replace("6", "SEIS");
        texto = texto.replace("7", "SETE");
        texto = texto.replace("8", "OITO");
        texto = texto.replace("9", "NOVE");
        return texto;
    }

    public static void main(String[] args) {
        String seuTextoAqui = TextoUtils.ajustaCaracterToUpperCaseFirstLetterOnlyTrim("SEU TEXTO AQUI");
        System.out.println("seuTextoAqui = " + seuTextoAqui);
    }

    public static String retornaPrimeiroEmail(String email) {
        if (StringUtils.isBlank((String)email)) {
            return null;
        }
        String[] split = email.split(";");
        return split[0];
    }

    public static String gerarEanBaseadoNoCodigoInterno(Integer codigoNovo) {
        String codigoInterno = StringUtils.leftPad((String)codigoNovo.toString(), (int)9, (String)"0");
        String codigoBarras = "789" + codigoInterno;
        String digitoVerificador = TextoUtils.calcularDigitoVerificadorEan13(codigoBarras);
        String ean13 = codigoBarras + digitoVerificador;
        return ean13;
    }

    private static String calcularDigitoVerificadorEan13(String codigoBarras) {
        int soma = 0;
        for (int i = 0; i < codigoBarras.length(); ++i) {
            int digito = Integer.parseInt(codigoBarras.substring(i, i + 1));
            if (i % 2 == 0) {
                soma += digito * 1;
                continue;
            }
            soma += digito * 3;
        }
        int resto = soma % 10;
        int digitoVerificador = 10 - resto;
        if (digitoVerificador == 10) {
            digitoVerificador = 0;
        }
        return String.valueOf(digitoVerificador);
    }

    public static String removeEspacosQuebraLinha(String clientIdBancoItau) {
        if (StringUtils.isBlank((String)clientIdBancoItau)) {
            return clientIdBancoItau;
        }
        String retorno = clientIdBancoItau.replaceAll("[\\s\\n\\r]", "");
        return retorno;
    }

    public static char[] quebraLinhaWindows() {
        return new char[]{'\r', '\n'};
    }

    public static String formataCodigoCNAE(String cnae) {
        return String.format("%s%s-%s/%s", cnae.substring(0, 2), cnae.substring(2, 4), cnae.substring(4, 5), cnae.substring(5, 7));
    }
}

