/*
 * Decompiled with CFR 0.152.
 */
package com.pinpdv.motor.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.pinpdv.motor.dto.DispositivoPageResponseDTO;
import com.pinpdv.motor.dto.EmpresaResponseDTO;
import com.pinpdv.motor.dto.PosTefRequestDTO;
import com.pinpdv.motor.dto.PosTefResponseDTO;
import com.pinpdv.motor.dto.PreVendaRequestDTO;
import com.pinpdv.motor.dto.PreVendaResponseDTO;
import com.pinpdv.motor.dto.ProdutoRequestDTO;
import com.pinpdv.motor.dto.TokenAPIDTO;
import com.pinpdv.motor.dto.VendaResponse;
import com.pinpdv.motor.exception.PinPdvApiException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinPdvClient {
    private static final Logger log = LoggerFactory.getLogger(PinPdvClient.class);
    private static final String API_URL = "https://api.pinpdv.com.br";
    private final ObjectMapper objectMapper = new ObjectMapper();

    public PinPdvClient() {
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.findAndRegisterModules();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    private String maskToken(TokenAPIDTO token) {
        if (token.getToken() == null) {
            return null;
        }
        if (token.getToken().length() <= 10) {
            return token.getToken();
        }
        return token.getToken().substring(0, 5) + "..." + token.getToken().substring(token.getToken().length() - 5);
    }

    private String doRequest(String method, String endpoint, TokenAPIDTO token, String body) throws IOException, PinPdvApiException {
        StringBuilder response;
        int responseCode;
        block43: {
            log.info("[PINPDV][REQUEST] method={}, endpoint={}, token={}, body={}", new Object[]{method, endpoint, this.maskToken(token), body});
            URL url = new URL(API_URL + endpoint);
            HttpURLConnection conn = null;
            InputStream is = null;
            responseCode = -1;
            response = new StringBuilder();
            try {
                Throwable throwable;
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod(method);
                conn.setRequestProperty("Authorization", token.getToken());
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setConnectTimeout(15000);
                conn.setReadTimeout(15000);
                if (body != null && !body.isEmpty()) {
                    conn.setDoOutput(true);
                    throwable = null;
                    try (OutputStream os = conn.getOutputStream();){
                        os.write(body.getBytes("UTF-8"));
                        os.flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                responseCode = conn.getResponseCode();
                log.info("[PINPDV][HTTP] Status recebido: {}", (Object)responseCode);
                is = responseCode < 400 ? conn.getInputStream() : conn.getErrorStream();
                if (is == null) {
                    log.error("[PINPDV][ERROR] InputStream nulo! Resposta n\u00e3o p\u00f4de ser lida. Endpoint: {}, Status: {}", (Object)endpoint, (Object)responseCode);
                    break block43;
                }
                try {
                    throwable = null;
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
                        String line;
                        while ((line = in.readLine()) != null) {
                            response.append(line);
                        }
                    }
                    catch (Throwable line) {
                        throwable = line;
                        throw line;
                    }
                }
                catch (IOException ioEx) {
                    log.error("[PINPDV][ERROR] IOException ao ler InputStream: {}", (Object)ioEx.getMessage());
                    throw ioEx;
                }
            }
            catch (IOException e) {
                log.error("[PINPDV][ERROR] IOException durante requisi\u00e7\u00e3o HTTP: {}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
            catch (Exception e) {
                log.error("[PINPDV][ERROR] Exception inesperada: {}", (Object)e.getMessage(), (Object)e);
                throw new IOException("Erro inesperado ao executar requisi\u00e7\u00e3o HTTP", e);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        log.info("[PINPDV][RESPONSE] method={}, endpoint={}, status={}, response={}", new Object[]{method, endpoint, responseCode, response});
        if (responseCode >= 400) {
            String responseStr = response.toString();
            String title = "Erro";
            String detail = responseStr;
            Map errors = null;
            try {
                JsonNode node = this.objectMapper.readTree(responseStr);
                if (node.has("title")) {
                    title = node.get("title").asText();
                }
                if (node.has("detail")) {
                    detail = node.get("detail").asText();
                }
                if (node.has("errors")) {
                    errors = (Map)this.objectMapper.convertValue((Object)node.get("errors"), Map.class);
                }
            }
            catch (Exception ex) {
                log.warn("[PINPDV][WARN] N\u00e3o foi poss\u00edvel converter resposta de erro para JSON. Resposta: {}", (Object)responseStr);
            }
            log.error("[PINPDV][API ERROR] C\u00f3digo={}, T\u00edtulo={}, Detalhe={}, Erros={}", new Object[]{responseCode, title, detail, errors});
            throw new PinPdvApiException(responseCode, title, detail, errors);
        }
        return response.toString();
    }

    public List<EmpresaResponseDTO> listarEmpresas(TokenAPIDTO token, String ordenarPor, String ordenarTipo) throws IOException, PinPdvApiException {
        String endpoint = "/empresa?OrdenarPor=" + ordenarPor + "&OrdenarTipo=" + ordenarTipo;
        String json = this.doRequest("GET", endpoint, token, null);
        return (List)this.objectMapper.readValue(json, (TypeReference)new TypeReference<List<EmpresaResponseDTO>>(){});
    }

    public void cadastrarProdutos(TokenAPIDTO token, List<ProdutoRequestDTO> produtos) throws IOException, PinPdvApiException {
        String endpoint = "/produto";
        String body = this.objectMapper.writeValueAsString(produtos);
        this.doRequest("POST", endpoint, token, body);
    }

    public void atualizarProduto(TokenAPIDTO token, ProdutoRequestDTO produto) throws IOException, PinPdvApiException {
        String endpoint = "/produto";
        String body = this.objectMapper.writeValueAsString((Object)produto);
        this.doRequest("PUT", endpoint, token, body);
    }

    public void desativarProduto(TokenAPIDTO token, String identificador) throws IOException, PinPdvApiException {
        String endpoint = "/produto/" + identificador + "/desativar";
        this.doRequest("PUT", endpoint, token, null);
    }

    public void ativarProduto(TokenAPIDTO token, String identificador) throws IOException, PinPdvApiException {
        String endpoint = "/produto/" + identificador + "/ativar";
        this.doRequest("PUT", endpoint, token, null);
    }

    public void deletarProduto(TokenAPIDTO token, String identificador) throws IOException, PinPdvApiException {
        String endpoint = "/produto/" + identificador;
        this.doRequest("DELETE", endpoint, token, null);
    }

    public void criarPreVenda(TokenAPIDTO token, PreVendaRequestDTO request) throws IOException, PinPdvApiException {
        String endpoint = "/pre-venda";
        String body = this.objectMapper.writeValueAsString((Object)request);
        this.doRequest("POST", endpoint, token, body);
    }

    public PreVendaResponseDTO consultarPreVenda(TokenAPIDTO token, String identificador) throws IOException, PinPdvApiException {
        String endpoint = "/pre-venda/" + identificador;
        String json = this.doRequest("GET", endpoint, token, null);
        return (PreVendaResponseDTO)this.objectMapper.readValue(json, PreVendaResponseDTO.class);
    }

    public void cancelarPreVenda(TokenAPIDTO token, String identificador) throws IOException, PinPdvApiException {
        String endpoint = "/pre-venda/" + identificador;
        this.doRequest("DELETE", endpoint, token, null);
    }

    public List<VendaResponse> consultarVendas(TokenAPIDTO token, String dataInicial, String dataFinal, String filtroTipoVenda) throws IOException, PinPdvApiException {
        String endpoint = "/venda?DataInicial=" + dataInicial + "&DataFinal=" + dataFinal;
        if (filtroTipoVenda != null && !filtroTipoVenda.isEmpty()) {
            endpoint = endpoint + "&FiltroTipoVenda=" + filtroTipoVenda;
        }
        String json = this.doRequest("GET", endpoint, token, null);
        return (List)this.objectMapper.readValue(json, (TypeReference)new TypeReference<List<VendaResponse>>(){});
    }

    public PosTefResponseDTO criarPosTef(TokenAPIDTO token, PosTefRequestDTO request) throws IOException, PinPdvApiException {
        String endpoint = "/pos-venda";
        String body = this.objectMapper.writeValueAsString((Object)request);
        String json = this.doRequest("POST", endpoint, token, body);
        return (PosTefResponseDTO)this.objectMapper.readValue(json, PosTefResponseDTO.class);
    }

    public PosTefResponseDTO consultarPosTef(TokenAPIDTO token, String identificador) throws IOException, PinPdvApiException {
        String endpoint = "/pos-venda/" + identificador;
        String json = this.doRequest("GET", endpoint, token, null);
        return (PosTefResponseDTO)this.objectMapper.readValue(json, PosTefResponseDTO.class);
    }

    public void cancelarPosTef(TokenAPIDTO token, String identificador) throws IOException, PinPdvApiException {
        String endpoint = "/pos-venda/" + identificador + "?forca=true";
        this.doRequest("DELETE", endpoint, token, null);
    }

    public DispositivoPageResponseDTO listarDispositivos(TokenAPIDTO token) throws IOException, PinPdvApiException {
        String endpoint = "/dispositivo";
        String json = this.doRequest("GET", endpoint, token, null);
        return (DispositivoPageResponseDTO)this.objectMapper.readValue(json, (TypeReference)new TypeReference<DispositivoPageResponseDTO>(){});
    }
}

