/*
 * Decompiled with CFR 0.152.
 */
package com.pinpdv.motor.service;

import com.pinpdv.motor.client.PinPdvClient;
import com.pinpdv.motor.dto.DispositivoPageResponseDTO;
import com.pinpdv.motor.dto.EmpresaResponseDTO;
import com.pinpdv.motor.dto.PosTefRequestDTO;
import com.pinpdv.motor.dto.PosTefResponseDTO;
import com.pinpdv.motor.dto.PreVendaRequestDTO;
import com.pinpdv.motor.dto.PreVendaResponseDTO;
import com.pinpdv.motor.dto.ProdutoRequestDTO;
import com.pinpdv.motor.dto.TokenAPIDTO;
import com.pinpdv.motor.dto.VendaResponse;
import com.pinpdv.motor.exception.PinPdvApiException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinPdvService {
    private static final Logger log = LoggerFactory.getLogger(PinPdvService.class);
    private final PinPdvClient client;
    private final TokenAPIDTO token;

    public PinPdvService(PinPdvClient client, TokenAPIDTO token) {
        this.client = client;
        this.token = token;
    }

    public List<EmpresaResponseDTO> listarEmpresas() throws Exception {
        log.info("[PINPDV] Buscando empresas...");
        return this.client.listarEmpresas(this.token, "Id", "DESC");
    }

    public void cadastrarProdutos(List<ProdutoRequestDTO> produtos) throws Exception {
        log.info("[PINPDV] Cadastrando produtos: " + produtos);
        this.client.cadastrarProdutos(this.token, produtos);
    }

    public void atualizarProduto(ProdutoRequestDTO produto) throws Exception {
        log.info("[PINPDV] Atualizando produto: " + produto);
        this.client.atualizarProduto(this.token, produto);
    }

    public void desativarProduto(String identificador) throws Exception {
        log.info("[PINPDV] Desativando produto " + identificador);
        this.client.desativarProduto(this.token, identificador);
    }

    public void ativarProduto(String identificador) throws Exception {
        log.info("[PINPDV] Ativando produto " + identificador);
        this.client.ativarProduto(this.token, identificador);
    }

    public void deletarProduto(String identificador) throws Exception {
        log.info("[PINPDV] Deletando produto " + identificador);
        this.client.deletarProduto(this.token, identificador);
    }

    public void criarPreVenda(PreVendaRequestDTO request) throws Exception {
        log.info("[PINPDV] Criando pr\u00e9-venda: " + request);
        this.client.criarPreVenda(this.token, request);
    }

    public PreVendaResponseDTO consultarPreVenda(String identificador) throws Exception {
        log.info("[PINPDV] Consultando pr\u00e9-venda " + identificador);
        return this.client.consultarPreVenda(this.token, identificador);
    }

    public void cancelarPreVenda(String identificador) throws Exception {
        log.info("[PINPDV] Cancelando pr\u00e9-venda " + identificador);
        this.client.cancelarPreVenda(this.token, identificador);
    }

    public List<VendaResponse> consultarVendas(LocalDateTime inicio, LocalDateTime fim, String filtro) throws Exception {
        String dtInicio = inicio.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        String dtFim = fim.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        log.info("[PINPDV] Consultando vendas de " + dtInicio + " at\u00e9 " + dtFim);
        return this.client.consultarVendas(this.token, dtInicio, dtFim, filtro);
    }

    public PosTefResponseDTO criarPosTef(PosTefRequestDTO request) throws Exception {
        log.info("[PINPDV] Criando POS-TEF: " + request);
        return this.client.criarPosTef(this.token, request);
    }

    public PosTefResponseDTO consultarPosTef(String identificador) throws Exception {
        log.info("[PINPDV] Consultando POS-TEF " + identificador);
        return this.client.consultarPosTef(this.token, identificador);
    }

    public void cancelarPosTef(String identificador) throws Exception {
        log.info("[PINPDV] Cancelando POS-TEF " + identificador);
        this.client.cancelarPosTef(this.token, identificador);
    }

    public DispositivoPageResponseDTO listarDispositivos() throws IOException, PinPdvApiException {
        return this.client.listarDispositivos(this.token);
    }
}

