/*
 * Decompiled with CFR 0.152.
 */
package com.pinpdv.motor.util;

import com.pinpdv.motor.dto.PosTefResponseDTO;
import com.pinpdv.motor.dto.PreVendaResponseDTO;
import com.pinpdv.motor.dto.ResultadoValidacaoDTO;
import com.pinpdv.motor.dto.TransacaoDTO;
import com.pinpdv.motor.dto.TransacaoInfoDTO;
import com.pinpdv.motor.dto.VendaDTO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosTefValidator {
    private static final Logger log = LoggerFactory.getLogger(PosTefValidator.class);

    public static ResultadoValidacaoDTO analisar(PosTefResponseDTO response) {
        log.info("Iniciando an\u00e1lise do POS-TEF: identificador={}, status={}", (Object)response.getIdentificador(), (Object)(response.getStatus() != null ? response.getStatus().getValue() : "NULO"));
        ResultadoValidacaoDTO resultado = new ResultadoValidacaoDTO();
        boolean concluido = response.getStatus() != null && "Concluido".equalsIgnoreCase(response.getStatus().getValue());
        resultado.setConcluido(concluido);
        log.info("POS-TEF foi conclu\u00eddo? {}", (Object)concluido);
        List<VendaDTO> vendas = response.getVendas();
        resultado.setVendaRealizada(false);
        resultado.setTodasTransacoesAprovadas(false);
        resultado.setTransacoesAprovadas(new ArrayList<TransacaoInfoDTO>());
        resultado.setTransacoesNaoAutorizadas(new ArrayList<TransacaoInfoDTO>());
        if (vendas != null && !vendas.isEmpty()) {
            log.info("Foram encontradas {} venda(s) no POS-TEF.", (Object)vendas.size());
            for (VendaDTO venda : vendas) {
                log.info("Analisando venda: identificador={}, status={}", (Object)venda.getIdentificador(), (Object)(venda.getStatus() != null ? venda.getStatus().getValue() : "NULO"));
                boolean vendaRealizada = venda.getStatus() != null && "Realizada".equalsIgnoreCase(venda.getStatus().getValue());
                resultado.setVendaRealizada(vendaRealizada);
                log.info("A venda foi realizada? {}", (Object)vendaRealizada);
                if (venda.getTransacoes() != null && !venda.getTransacoes().isEmpty()) {
                    log.info("Foram encontradas {} transa\u00e7\u00e3o(\u00f5es) nesta venda.", (Object)venda.getTransacoes().size());
                    boolean todasAprovadas = true;
                    for (TransacaoDTO transacao : venda.getTransacoes()) {
                        log.info("Analisando transa\u00e7\u00e3o: valor={}, parcelas={}, tipoPagamento={}, status={}", new Object[]{transacao.getValor(), transacao.getParcelas(), transacao.getTipoPagamento(), transacao.getStatus() != null ? transacao.getStatus().getValue() : "NULO"});
                        boolean aprovada = transacao.getStatus() != null && "Aprovada".equalsIgnoreCase(transacao.getStatus().getValue());
                        TransacaoInfoDTO info = new TransacaoInfoDTO();
                        info.setValor(transacao.getValor().doubleValue());
                        info.setParcelas(transacao.getParcelas());
                        info.setTipoPagamento(transacao.getTipoPagamento());
                        info.setStatus(transacao.getStatus() != null ? transacao.getStatus().getValue() : null);
                        if (aprovada && transacao.getDados() != null) {
                            info.setNsu(transacao.getDados().getNsu());
                            info.setAutorizacao(transacao.getDados().getAutorizacao());
                            info.setBandeira(transacao.getDados().getBandeira());
                            info.setAdquirente(transacao.getDados().getAdquirente());
                            info.setDataHora(transacao.getDados().getDataHora());
                            log.info("Transa\u00e7\u00e3o aprovada com dados para NFE: NSU={}, Autorizacao={}, Bandeira={}, Adquirente={}, DataHora={}", new Object[]{info.getNsu(), info.getAutorizacao(), info.getBandeira(), info.getAdquirente(), info.getDataHora()});
                        }
                        if (aprovada) {
                            resultado.getTransacoesAprovadas().add(info);
                            continue;
                        }
                        resultado.getTransacoesNaoAutorizadas().add(info);
                        todasAprovadas = false;
                        log.warn("Transa\u00e7\u00e3o N\u00c3O aprovada: {}", (Object)info);
                    }
                    resultado.setTodasTransacoesAprovadas(todasAprovadas);
                    log.info("Todas as transa\u00e7\u00f5es desta venda foram aprovadas? {}", (Object)todasAprovadas);
                    continue;
                }
                log.warn("Nenhuma transa\u00e7\u00e3o encontrada nesta venda.");
            }
        } else {
            log.warn("Nenhuma venda encontrada neste POS-TEF.");
        }
        log.info("Resultado final da an\u00e1lise do POS-TEF: concluido={}, vendaRealizada={}, todasTransacoesAprovadas={}", new Object[]{resultado.isConcluido(), resultado.isVendaRealizada(), resultado.isTodasTransacoesAprovadas()});
        return resultado;
    }

    public static ResultadoValidacaoDTO analisarPreVenda(PreVendaResponseDTO response) {
        log.info("Iniciando an\u00e1lise do Pr\u00e9-Venda: identificador={}, status={}", (Object)response.getIdentificador(), (Object)(response.getStatus() != null ? response.getStatus().getValue() : "NULO"));
        ResultadoValidacaoDTO resultado = new ResultadoValidacaoDTO();
        boolean concluido = response.getStatus() != null && "Concluido".equalsIgnoreCase(response.getStatus().getValue());
        resultado.setConcluido(concluido);
        log.info("Pr\u00e9-Venda foi conclu\u00edda? {}", (Object)concluido);
        List<VendaDTO> vendas = response.getVendas();
        resultado.setVendaRealizada(false);
        resultado.setTodasTransacoesAprovadas(false);
        resultado.setTransacoesAprovadas(new ArrayList<TransacaoInfoDTO>());
        resultado.setTransacoesNaoAutorizadas(new ArrayList<TransacaoInfoDTO>());
        if (vendas != null && !vendas.isEmpty()) {
            log.info("Foram encontradas {} venda(s) na Pr\u00e9-Venda.", (Object)vendas.size());
            for (VendaDTO venda : vendas) {
                log.info("Analisando venda: identificador={}, status={}", (Object)venda.getIdentificador(), (Object)(venda.getStatus() != null ? venda.getStatus().getValue() : "NULO"));
                boolean vendaRealizada = venda.getStatus() != null && "Realizada".equalsIgnoreCase(venda.getStatus().getValue());
                resultado.setVendaRealizada(vendaRealizada);
                log.info("A venda foi realizada? {}", (Object)vendaRealizada);
                if (venda.getTransacoes() != null && !venda.getTransacoes().isEmpty()) {
                    log.info("Foram encontradas {} transa\u00e7\u00e3o(\u00f5es) nesta venda.", (Object)venda.getTransacoes().size());
                    boolean todasAprovadas = true;
                    for (TransacaoDTO transacao : venda.getTransacoes()) {
                        log.info("Analisando transa\u00e7\u00e3o: valor={}, parcelas={}, tipoPagamento={}, status={}", new Object[]{transacao.getValor(), transacao.getParcelas(), transacao.getTipoPagamento(), transacao.getStatus() != null ? transacao.getStatus().getValue() : "NULO"});
                        boolean aprovada = transacao.getStatus() != null && "Aprovada".equalsIgnoreCase(transacao.getStatus().getValue());
                        TransacaoInfoDTO info = new TransacaoInfoDTO();
                        info.setValor(transacao.getValor().doubleValue());
                        info.setParcelas(transacao.getParcelas());
                        info.setTipoPagamento(transacao.getTipoPagamento());
                        info.setStatus(transacao.getStatus() != null ? transacao.getStatus().getValue() : null);
                        if (aprovada && transacao.getDados() != null) {
                            info.setNsu(transacao.getDados().getNsu());
                            info.setAutorizacao(transacao.getDados().getAutorizacao());
                            info.setBandeira(transacao.getDados().getBandeira());
                            info.setAdquirente(transacao.getDados().getAdquirente());
                            info.setDataHora(transacao.getDados().getDataHora());
                            log.info("Transa\u00e7\u00e3o aprovada com dados para NFE: NSU={}, Autorizacao={}, Bandeira={}, Adquirente={}, DataHora={}", new Object[]{info.getNsu(), info.getAutorizacao(), info.getBandeira(), info.getAdquirente(), info.getDataHora()});
                        }
                        if (aprovada) {
                            resultado.getTransacoesAprovadas().add(info);
                            continue;
                        }
                        resultado.getTransacoesNaoAutorizadas().add(info);
                        todasAprovadas = false;
                        log.warn("Transa\u00e7\u00e3o N\u00c3O aprovada: {}", (Object)info);
                    }
                    resultado.setTodasTransacoesAprovadas(todasAprovadas);
                    log.info("Todas as transa\u00e7\u00f5es desta venda foram aprovadas? {}", (Object)todasAprovadas);
                    continue;
                }
                log.warn("Nenhuma transa\u00e7\u00e3o encontrada nesta venda.");
            }
        } else {
            log.warn("Nenhuma venda encontrada nesta Pr\u00e9-Venda.");
        }
        log.info("Resultado final da an\u00e1lise do Pr\u00e9-Venda: concluido={}, vendaRealizada={}, todasTransacoesAprovadas={}", new Object[]{resultado.isConcluido(), resultado.isVendaRealizada(), resultado.isTodasTransacoesAprovadas()});
        return resultado;
    }
}

