/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor;

import com.formdev.flatlaf.FlatLightLaf;
import com.softjava.motor.model.ConfigApp;
import com.softjava.motor.service.SystemService;
import com.softjava.motor.view.ViewConfigDB;
import java.util.Optional;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@ComponentScan(basePackages={"com.softjava"})
@EnableScheduling
public class MotorApplication
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(MotorApplication.class);
    public static String VERSAO_APP = "Integrador ScannTech | v1.0.2.1 - 11/11/2024";
    public static boolean MODULO_IMENDES_ATIVO;
    public static boolean MODULO_ZAPI_ATIVO;
    public ConfigApp config;
    private static ApplicationContext APPLICATION_CONTEXT;
    private final SystemService systemService;

    public static void main(String[] args) {
        try {
            FlatLightLaf.setup();
            SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{MotorApplication.class});
            builder.headless(false);
            APPLICATION_CONTEXT = builder.run(args);
        }
        catch (Exception e) {
            log.error("Erro ao iniciar o app", (Throwable)e);
            String erro = Optional.ofNullable(e.getMessage()).orElse("Nenhuma informa\u00e7\u00e3o do erro foi encontrada!");
            if (erro.contains("entityManagerFactory")) {
                JOptionPane.showMessageDialog(null, "Problemas ao se conectar com a base de dados\nVerifique usu\u00e1rio, senha e url no arquivo config.ini");
            } else if (erro.contains("database")) {
                JOptionPane.showMessageDialog(null, "Problemas ao se conectar com a base de dados");
            } else if (erro.contains("username")) {
                JOptionPane.showMessageDialog(null, "Usu\u00e1rio da base inv\u00e1lido");
            } else if (erro.contains("password")) {
                JOptionPane.showMessageDialog(null, "Senha da base inv\u00e1lida");
            } else {
                JOptionPane.showMessageDialog(null, e.getMessage());
            }
            ViewConfigDB janela = ViewConfigDB.getIntance();
            janela.setVisible(true);
            log.error(erro, (Throwable)e);
        }
    }

    public void run(String ... args) {
        log.info("------------------------------------------------------------------------");
        log.info("INTEGRADOR SCANNTECH AND SOFTJAVA SISTEMAS -  SYNC V {} INICIALIADO");
        log.info("------------------------------------------------------------------------");
        this.systemService.inicializarApp();
    }

    public static <T> T getBean(Class<T> type) {
        return (T)(APPLICATION_CONTEXT != null ? APPLICATION_CONTEXT.getBean(type) : null);
    }

    public MotorApplication(SystemService systemService) {
        this.systemService = systemService;
    }
}

