/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.componente.botao;

import com.softjava.motor.componente.botao.SwitchButton;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class SwitchButton
extends Component {
    private Timer timer;
    private float location;
    private boolean selected;
    private boolean mouseOver;
    private float speed = 0.5f;
    private List<EventSwitchSelected> events;

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.timer.start();
        this.runEvent();
    }

    public SwitchButton() {
        super.setBackground(new Color(0, 174, 255));
        super.setPreferredSize(new Dimension(40, 18));
        super.setForeground(Color.WHITE);
        super.setCursor(new Cursor(12));
        this.events = new ArrayList();
        this.location = 2.0f;
        this.timer = new Timer(0, ae -> {
            if (this.isSelected()) {
                int endLocation = this.getWidth() - this.getHeight() + 2;
                if (this.location < (float)endLocation) {
                    this.location += this.speed;
                    this.repaint();
                } else {
                    this.timer.stop();
                    this.location = endLocation;
                    this.repaint();
                }
            } else {
                int endLocation = 2;
                if (this.location > (float)endLocation) {
                    this.location -= this.speed;
                    this.repaint();
                } else {
                    this.timer.stop();
                    this.location = endLocation;
                    this.repaint();
                }
            }
        });
        super.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Override
    public void paint(Graphics grphcs) {
        Graphics2D g2 = (Graphics2D)grphcs;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        float alpha = this.getAlpha();
        if (alpha < 1.0f) {
            g2.setColor(Color.GRAY);
            g2.fillRoundRect(0, 0, width, height, height, height);
        }
        g2.setComposite(AlphaComposite.getInstance(3, alpha));
        g2.setColor(this.getBackground());
        g2.fillRoundRect(0, 0, width, height, height, height);
        g2.setColor(this.getForeground());
        g2.setComposite(AlphaComposite.SrcOver);
        g2.fillOval((int)this.location, 2, height - 4, height - 4);
        super.paint(grphcs);
    }

    private float getAlpha() {
        float width = this.getWidth() - this.getHeight();
        float alpha = (this.location - 2.0f) / width;
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        return alpha;
    }

    private void runEvent() {
        for (EventSwitchSelected event : this.events) {
            event.onSelected(this.selected);
        }
    }

    public void addEventSelected(EventSwitchSelected event) {
        this.events.add(event);
    }

    static /* synthetic */ boolean access$002(SwitchButton x0, boolean x1) {
        x0.mouseOver = x1;
        return x0.mouseOver;
    }

    static /* synthetic */ boolean access$000(SwitchButton x0) {
        return x0.mouseOver;
    }

    static /* synthetic */ boolean access$102(SwitchButton x0, boolean x1) {
        x0.selected = x1;
        return x0.selected;
    }

    static /* synthetic */ boolean access$100(SwitchButton x0) {
        return x0.selected;
    }

    static /* synthetic */ Timer access$200(SwitchButton x0) {
        return x0.timer;
    }

    static /* synthetic */ void access$300(SwitchButton x0) {
        x0.runEvent();
    }
}

