/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.componente.label;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ELabel
extends JLabel {
    private boolean borderLineShow;
    private boolean requiredShow;

    public boolean isBorderLineShow() {
        return this.borderLineShow;
    }

    public boolean isRequiredShow() {
        return this.requiredShow;
    }

    public void setRequiredShow(boolean requiredShow) {
        this.requiredShow = requiredShow;
    }

    protected void paintBorder(Graphics grphcs) {
        if (this.borderLineShow) {
            Graphics2D g2 = (Graphics2D)grphcs.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color line = Color.BLACK;
            g2.setColor(line);
            int height = this.getHeight();
            g2.drawRoundRect(0, 0, this.getWidth() - 1, height - 1, height - 3, height - 3);
        }
        super.paintBorder(grphcs);
    }

    public void paintComponent(Graphics grphcs) {
        super.paintComponent(grphcs);
        if (this.requiredShow) {
            this.createRequiredMark(grphcs);
        }
    }

    private void createRequiredMark(Graphics grphcs) {
        int x;
        String requiredText = "*";
        int requiredMargin = 4;
        Insets insets = new Insets(0, requiredMargin, 0, requiredMargin);
        Border border = this.getBorder();
        if (border instanceof EmptyBorder) {
            EmptyBorder emptyBorder = (EmptyBorder)border;
            Insets insetsBorder = emptyBorder.getBorderInsets();
            insets.left = insetsBorder.left;
            insets.right = insetsBorder.right;
        }
        Graphics2D g2d = (Graphics2D)grphcs;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g2d.setColor(Color.red);
        Font font = this.getFont();
        g2d.setFont(new Font(font.getFamily(), 0, font.getSize()));
        FontMetrics fm = g2d.getFontMetrics();
        int y = (this.getHeight() - fm.getHeight()) / 2 + fm.getAscent();
        int align = this.getHorizontalAlignment();
        String text = this.getText();
        switch (align) {
            case 2: 
            case 10: {
                x = fm.stringWidth(text) + insets.left;
                break;
            }
            case 4: {
                x = this.getWidth() - fm.stringWidth(text) - insets.left - 2;
                break;
            }
            default: {
                x = (this.getWidth() - fm.stringWidth(text)) / 2 + fm.stringWidth(text) + insets.right;
            }
        }
        g2d.drawString(requiredText, x, y);
    }
}

