/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.componente.panelborda;

import com.softjava.motor.componente.panelborda.ShadowRenderer;
import com.softjava.motor.componente.panelborda.ShadowType;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class EPanelShadow
extends JPanel {
    private Color color1;
    private Color color2;
    private int arcWidth = 20;
    private int arcHeight = 20;
    private ShadowType shadowType = ShadowType.CENTER;
    private int shadowSize = 5;
    private float shadowOpacity = 0.2f;
    private Color shadowColor = Color.BLACK;

    public EPanelShadow() {
        this(null, null, 20, 20);
    }

    public EPanelShadow(int arcWidth, int arcHeight) {
        this(null, null, arcWidth, arcHeight);
    }

    public EPanelShadow(Color color1, Color color2) {
        this(color1, color2, 20, 20);
    }

    public EPanelShadow(Color color1, Color color2, int arcWidth, int arcHeight) {
        super.setOpaque(false);
        super.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.color1 = color1;
        this.color2 = color2;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public ShadowType getShadowType() {
        return this.shadowType;
    }

    public void setShadowType(ShadowType shadowType) {
        this.shadowType = shadowType;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void setShadowSize(int shadowSize) {
        this.shadowSize = shadowSize;
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setShadowOpacity(float shadowOpacity) {
        this.shadowOpacity = shadowOpacity;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
    }

    protected void paintComponent(Graphics grphcs) {
        this.createShadow(grphcs);
        super.paintComponent(grphcs);
    }

    private void createShadow(Graphics grphcs) {
        Graphics2D g2d = (Graphics2D)grphcs;
        int size = this.shadowSize * 2;
        int x = 0;
        int y = 0;
        int width = this.getWidth() - size;
        int height = this.getHeight() - size;
        if (this.shadowType == ShadowType.TOP) {
            x = this.shadowSize;
            y = size;
        } else if (this.shadowType == ShadowType.BOT) {
            x = this.shadowSize;
            y = 0;
        } else if (this.shadowType == ShadowType.TOP_LEFT) {
            x = size;
            y = size;
        } else if (this.shadowType == ShadowType.TOP_RIGHT) {
            x = 0;
            y = size;
        } else if (this.shadowType == ShadowType.BOT_LEFT) {
            x = size;
            y = 0;
        } else if (this.shadowType == ShadowType.BOT_RIGHT) {
            x = 0;
            y = 0;
        } else {
            x = this.shadowSize;
            y = this.shadowSize;
        }
        Color gradient1 = this.getBackground();
        Color gradient2 = this.getForeground();
        if (this.color1 != null && this.color2 != null) {
            gradient1 = this.color1;
            gradient2 = this.color2;
        }
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D cg = img.createGraphics();
        cg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint g = new GradientPaint(0.0f, 0.0f, gradient1, 0.0f, height, gradient2);
        cg.setPaint(g);
        cg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        cg.fillRoundRect(0, 0, width, height, this.arcWidth, this.arcHeight);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ShadowRenderer render = new ShadowRenderer(this.shadowSize, this.shadowOpacity, this.shadowColor);
        g2d.drawImage((Image)render.createShadow(img), 0, 0, null);
        g2d.drawImage((Image)img, x, y, null);
    }
}

