/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.componente.scrolbar;

import com.softjava.motor.componente.scrolbar.ModernScrollBarUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ModernScrollBarUI
extends BasicScrollBarUI {
    private final int THUMB_SIZE = 60;

    protected Dimension getMaximumThumbSize() {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(0, 60);
        }
        return new Dimension(60, 0);
    }

    protected Dimension getMinimumThumbSize() {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(0, 60);
        }
        return new Dimension(60, 0);
    }

    protected JButton createIncreaseButton(int i) {
        return new ScrollBarButton(this);
    }

    protected JButton createDecreaseButton(int i) {
        return new ScrollBarButton(this);
    }

    protected void paintTrack(Graphics grphcs, JComponent jc, Rectangle rctngl) {
        int height;
        int width;
        int y;
        int x;
        Graphics2D g2 = (Graphics2D)grphcs;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int orientation = this.scrollbar.getOrientation();
        if (orientation == 1) {
            int size = rctngl.width / 2;
            x = rctngl.x + (rctngl.width - size) / 2;
            y = rctngl.y;
            width = size;
            height = rctngl.height;
        } else {
            int size = rctngl.height / 2;
            y = rctngl.y + (rctngl.height - size) / 2;
            x = 0;
            width = rctngl.width;
            height = size;
        }
        g2.setColor(new Color(240, 240, 240));
        g2.fillRect(x, y, width, height);
    }

    protected void paintThumb(Graphics grphcs, JComponent jc, Rectangle rctngl) {
        Graphics2D g2 = (Graphics2D)grphcs;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = rctngl.x;
        int y = rctngl.y;
        int width = rctngl.width;
        int height = rctngl.height;
        if (this.scrollbar.getOrientation() == 1) {
            y += 8;
            height -= 16;
        } else {
            x += 8;
            width -= 16;
        }
        g2.setColor(this.scrollbar.getForeground());
        g2.fillRoundRect(x, y, width, height, 10, 10);
    }
}

