/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.componente.table;

import com.softjava.motor.componente.util.CampoUtil;
import com.softjava.motor.componente.util.DataUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class StripedCellRenderer
extends DefaultTableCellRenderer {
    private Color alternateColor = new Color(153, 204, 255);
    private int tamFonte = 13;

    public StripedCellRenderer(int tamFonte) {
        this.tamFonte = tamFonte;
    }

    public StripedCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Font f = new Font("Segoe UI Semibold", 0, this.tamFonte);
        Color foreground = null;
        Color background = null;
        ImageIcon icon = null;
        BigDecimal quantidadeEstoque = CampoUtil.DF2Exatado((String)String.valueOf(table.getValueAt(row, this.getColumn(table, "Qtde estoque"))));
        if (column == this.getColumn(table, "#") || column == this.getColumn(table, "Anivers\u00e1rio") || column == this.getColumn(table, "Status Atendimento") || column == this.getColumn(table, "Item") || column == this.getColumn(table, "Doc.") || column == this.getColumn(table, "UF") || column == this.getColumn(table, "IBGE") || column == this.getColumn(table, "C\u00f3digo") || column == this.getColumn(table, "Tipo") || column == this.getColumn(table, "Aberto em") || column == this.getColumn(table, "Fechado em") || column == this.getColumn(table, "Status") || column == this.getColumn(table, "Situa\u00e7\u00e3o") || column == this.getColumn(table, "Usu\u00e1rio") || column == this.getColumn(table, "Cliente") || column == this.getColumn(table, "Forn.") || column == this.getColumn(table, "Data") || column == this.getColumn(table, "Hora") || column == this.getColumn(table, "Cpf/Cnpj") || column == this.getColumn(table, "T\u00edtulo") || column == this.getColumn(table, "Data") || column == this.getColumn(table, "Data Emiss\u00e3o") || column == this.getColumn(table, "Data Saida") || column == this.getColumn(table, "Data Saida/Entrega") || column == this.getColumn(table, "Vencimento") || column == this.getColumn(table, "Pagamento") || column == this.getColumn(table, "Emiss\u00e3o") || column == this.getColumn(table, "Baixar") || column == this.getColumn(table, "Parcela") || column == this.getColumn(table, "Forma de Pagamento") || column == this.getColumn(table, "UN")) {
            this.setHorizontalAlignment(0);
        } else if (column == this.getColumn(table, "Valor Unit\u00e1rio") || column == this.getColumn(table, "Vlr. Venda") || column == this.getColumn(table, "Valor Unit") || column == this.getColumn(table, "Valor") || column == this.getColumn(table, "Quantidade") || column == this.getColumn(table, "Saldo Final") || column == this.getColumn(table, "Saldo Inicial") || column == this.getColumn(table, "Valor Saldo") || column == this.getColumn(table, "Valor Entrada") || column == this.getColumn(table, "Valor Saida") || column == this.getColumn(table, "Est Anterior") || column == this.getColumn(table, "Valor Subtotal") || column == this.getColumn(table, "Valor Total") || column == this.getColumn(table, "Total") || column == this.getColumn(table, "Valor T\u00edtulo") || column == this.getColumn(table, "Est Atual")) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        if (row % 2 == 0) {
            foreground = new Color(56, 56, 56);
            background = this.alternateColor;
        } else {
            foreground = new Color(56, 56, 56);
            background = Color.white;
        }
        if (column == this.getColumn(table, "#") || column == this.getColumn(table, "Item")) {
            if (row % 2 == 0) {
                foreground = new Color(56, 56, 56);
                background = this.alternateColor;
            } else {
                foreground = new Color(56, 56, 56);
                background = Color.white;
            }
            if (table.getSelectedRow() == row) {
                URL url = this.getClass().getResource("/icons/icons8_play_15px.png");
                icon = new ImageIcon(url);
                value = null;
            } else {
                icon = null;
                value = String.valueOf(row + 1);
            }
        }
        if (value instanceof BigDecimal) {
            value = CampoUtil.converteBigDecimal2StringMoedaReal((BigDecimal)((BigDecimal)value));
        } else if (value instanceof LocalDate) {
            value = DataUtil.asString((LocalDate)((LocalDate)value));
        } else if (value instanceof LocalDateTime) {
            value = DataUtil.asDate((LocalDateTime)((LocalDateTime)value));
        }
        if (quantidadeEstoque != null && quantidadeEstoque.compareTo(BigDecimal.ZERO) < 0) {
            foreground = Color.RED;
        }
        if (table.isRowSelected(row) && isSelected) {
            foreground = Color.WHITE;
            background = new Color(47, 134, 222);
        }
        if (table.isColumnSelected(column) && isSelected) {
            foreground = Color.WHITE;
            background = new Color(18, 107, 196);
        }
        if (value instanceof String) {
            this.setToolTipText((String)value);
        }
        this.setValue(value);
        this.setIcon((Icon)icon);
        this.setForeground(foreground);
        this.setBackground(background);
        this.setFont(f);
        return this;
    }

    private int getColumn(JTable table, String name) {
        int index = -2;
        try {
            index = table.getColumnModel().getColumnIndex(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return index;
    }

    private TableColumn getTableColumn(JTable table, int index) {
        return table.getColumnModel().getColumn(index);
    }
}

