/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.componente.textfield;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.swing.JTextField;

public class ETextField
extends JTextField {
    private int limitarTamanho = 0;
    private Integer placeholderMargin = 8;
    private String placeholder;
    private boolean exibirLimiteDeTamanho = false;

    public boolean isExibirLimiteDeTamanho() {
        return this.exibirLimiteDeTamanho;
    }

    public void setExibirLimiteDeTamanho(boolean exibirLimiteDeTamanho) {
        this.exibirLimiteDeTamanho = exibirLimiteDeTamanho;
    }

    public Integer getPlaceholderMargin() {
        return this.placeholderMargin;
    }

    public void setPlaceholderMargin(Integer placeholderMargin) {
        this.placeholderMargin = placeholderMargin;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public ETextField() {
        super.setPreferredSize(new Dimension(45, 25));
        super.setFont(new Font("Segoe UI", 0, 12));
        super.setSelectedTextColor(Color.WHITE);
        super.setSelectionColor(new Color(13, 134, 202));
        super.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Override
    public void paste() {
        if (this.limitarTamanho > 0 && this.isEditable() && this.isEnabled()) {
            try {
                String textoCopiado = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                String texto = this.getText() + textoCopiado;
                if (texto.length() <= this.limitarTamanho) {
                    super.paste();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            super.paste();
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.criarPlaceholder(g);
        this.criarLimitarTamanho(g);
    }

    private void criarLimitarTamanho(Graphics g) {
        if (this.exibirLimiteDeTamanho) {
            String limitarTamanhoTexto = this.getText().length() + "/" + this.limitarTamanho;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font font = this.getFont();
            g2d.setFont(new Font(font.getFamily(), 0, font.getSize()));
            FontMetrics fm = g2d.getFontMetrics();
            int x = this.getWidth() - fm.stringWidth(limitarTamanhoTexto) - 12;
            int y = (this.getHeight() - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle2D rect = fm.getStringBounds(limitarTamanhoTexto, g);
            g2d.setColor(new Color(13, 134, 202, 22));
            g2d.fillRoundRect(x - 6, y - fm.getAscent() - 1, (int)rect.getWidth() + 12, (int)rect.getHeight() + 5, (int)rect.getHeight() / 2, (int)rect.getHeight() / 2);
            g2d.setColor(new Color(3, 104, 172, 95));
            g2d.drawString(limitarTamanhoTexto, x, y);
        }
    }

    private void criarPlaceholder(Graphics g) {
        int x;
        if (this.placeholder == null || this.placeholder.length() == 0 || this.getText().length() > 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.getDisabledTextColor());
        Font font = this.getFont();
        g2d.setFont(new Font(font.getFamily(), font.getStyle(), font.getSize()));
        FontMetrics fm = g2d.getFontMetrics();
        int y = (this.getHeight() - fm.getHeight()) / 2 + fm.getAscent();
        int align = this.getHorizontalAlignment();
        switch (align) {
            case 2: 
            case 10: {
                x = this.placeholderMargin;
                break;
            }
            case 4: {
                x = this.getWidth() - fm.stringWidth(this.placeholder) - this.placeholderMargin;
                break;
            }
            default: {
                x = (this.getWidth() - fm.stringWidth(this.placeholder)) / 2;
            }
        }
        g2d.drawString(this.placeholder, x, y);
    }

    public void somenteNumeros() {
        this.limitarCaracteres("0123456789");
    }

    public void somenteNumerosDecimais() {
        this.limitarCaracteres("0123456789,", ",");
    }

    public void somenteCEP() {
        this.limitarCaracteres("0123456789");
        this.limitarTamanho(8);
    }

    public void somenteCpf() {
        this.limitarCaracteres("0123456789");
        this.limitarTamanho(14);
    }

    public void somenteCnpj() {
        this.limitarCaracteres("0123456789");
        this.limitarTamanho(18);
    }

    public void somenteCpfCnpj() {
        this.limitarCaracteres("0123456789");
        this.limitarTamanho(18);
    }

    public void somenteMoeda() {
        this.limitarCaracteres("0123456789,", ",");
        this.limitarTamanho(12);
    }

    public void aplicarMascara(Function<String, String> function) {
        this.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void aplicarMascaraFocus(Function<String, String> function) {
        this.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void limitarCaracteres(String somente) {
        this.limitarCaracteres(somente, ",*");
    }

    public void limitarCaracteres(String somente, String unicos) {
        List<String> unicosList = Arrays.asList(unicos.split(""));
        this.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void limitarTamanho(int tamanho) {
        this.limitarTamanho = tamanho;
        this.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
    }
}

