/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.componente.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.InputMismatchException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatterUtil {
    static final Logger log = Logger.getLogger("FormatterUtil");
    public static DecimalFormat DF2 = new DecimalFormat("#,##0.00");
    public static DecimalFormat DF3 = new DecimalFormat("#,##0.000");
    public static DecimalFormat DF4 = new DecimalFormat("#,##0.0000");
    public static DecimalFormat DFD = new DecimalFormat("R$ #,##0.00");
    public static DecimalFormat DFD3 = new DecimalFormat("R$ #,##0.000");
    public static DecimalFormat DFD4 = new DecimalFormat("R$ #,##0.0000");
    public static DecimalFormat DFP = new DecimalFormat("#,##0.00'%'");
    public static DecimalFormat DFP3 = new DecimalFormat("#,##0.000'%'");
    public static DecimalFormat DFP4 = new DecimalFormat("#,##0.0000'%'");
    public static DecimalFormat DFP5 = new DecimalFormat("#,##0.00000'%'");
    private BigDecimal value;
    private String formattedValue = "";
    private DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
    public static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);

    public FormatterUtil() {
    }

    public FormatterUtil(BigDecimal value) {
        this.value = value;
    }

    public static FormatterUtil build() {
        return new FormatterUtil();
    }

    public static FormatterUtil build(BigDecimal value) {
        return new FormatterUtil(value);
    }

    public FormatterUtil setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
        return this;
    }

    public FormatterUtil setFormat(String format) {
        this.decimalFormat = new DecimalFormat(format);
        return this;
    }

    public FormatterUtil setValue(BigDecimal value) {
        this.value = value;
        return this;
    }

    public FormatterUtil prefix(String txt) {
        this.formattedValue = txt + " " + this.formattedValue;
        return this;
    }

    public FormatterUtil suffix(String txt) {
        this.formattedValue = this.formattedValue + txt;
        return this;
    }

    public String get() {
        if (this.value == null) {
            this.value = BigDecimal.ZERO;
        }
        this.decimalFormat.setRoundingMode(RoundingMode.DOWN);
        this.formattedValue = this.decimalFormat.format(this.value);
        return this.formattedValue;
    }

    public static boolean isEmail(String emailStr) {
        Matcher matcher = VALID_EMAIL_ADDRESS_REGEX.matcher(emailStr);
        return matcher.find();
    }

    public static boolean isCpf(String cpf) {
        cpf = cpf.replace(".", "");
        cpf = cpf.replace("-", "");
        try {
            Long.parseLong(cpf);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int d2 = 0;
        int d1 = 0;
        int resto = 0;
        int digito2 = 0;
        int digito1 = 0;
        for (int nCount = 1; nCount < cpf.length() - 1; ++nCount) {
            int digitoCPF = Integer.parseInt(cpf.substring(nCount - 1, nCount));
            d1 += (11 - nCount) * digitoCPF;
            d2 += (12 - nCount) * digitoCPF;
        }
        resto = d1 % 11;
        digito1 = resto < 2 ? 0 : 11 - resto;
        resto = (d2 += 2 * digito1) % 11;
        digito2 = resto < 2 ? 0 : 11 - resto;
        String nDigVerific = cpf.substring(cpf.length() - 2, cpf.length());
        String nDigResult = String.valueOf(digito1) + String.valueOf(digito2);
        return nDigVerific.equals(nDigResult);
    }

    public static boolean isCnpj(String cnpj) {
        cnpj = cnpj.replace(".", "");
        cnpj = cnpj.replace("-", "");
        cnpj = cnpj.replace("/", "");
        try {
            Long.parseLong(cnpj);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (cnpj.equals("00000000000000") || cnpj.equals("11111111111111") || cnpj.equals("22222222222222") || cnpj.equals("33333333333333") || cnpj.equals("44444444444444") || cnpj.equals("55555555555555") || cnpj.equals("66666666666666") || cnpj.equals("77777777777777") || cnpj.equals("88888888888888") || cnpj.equals("99999999999999") || cnpj.length() != 14) {
            return false;
        }
        try {
            int num;
            int i;
            int sm = 0;
            int peso = 2;
            for (i = 11; i >= 0; --i) {
                num = cnpj.charAt(i) - 48;
                sm += num * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            int r = sm % 11;
            char dig13 = r == 0 || r == 1 ? (char)'0' : (char)((char)(11 - r + 48));
            sm = 0;
            peso = 2;
            for (i = 12; i >= 0; --i) {
                num = cnpj.charAt(i) - 48;
                sm += num * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            r = sm % 11;
            char dig14 = r == 0 || r == 1 ? (char)'0' : (char)((char)(11 - r + 48));
            return dig13 == cnpj.charAt(12) && dig14 == cnpj.charAt(13);
        }
        catch (InputMismatchException erro) {
            return false;
        }
    }

    public static String currency(BigDecimal value, int scale) {
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        return value.setScale(scale, RoundingMode.DOWN).toString();
    }

    public static String currency(BigDecimal value, DecimalFormat DF) {
        if (DF == null) {
            DF = new DecimalFormat("#,##0.00");
        }
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        DF.setRoundingMode(RoundingMode.DOWN);
        return DF.format(value);
    }
}

