/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.config.db;

import com.softjava.motor.util.Encryption;
import java.io.IOException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"file:${user.dir}/config.properties"})
public class DataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(DataSourceConfig.class);
    @Value(value="${database.url}")
    private String url;
    @Value(value="${database.username}")
    private String username;
    @Value(value="${database.password}")
    private String password;

    @Bean
    public DataSource getDataSource() throws IOException, Exception {
        log.info("Configurando o datasource");
        this.username = Encryption.decrypt((String)this.username);
        this.password = Encryption.decrypt((String)this.password);
        return DataSourceBuilder.create().driverClassName("org.postgresql.Driver").url("jdbc:postgresql://" + this.url + "?serverTimezone=UTC").username(this.username).password(this.password).build();
    }
}

