/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.conversor;

import com.softjava.motor.integracao.scanntech.dto.PromotionResponse;
import com.softjava.motor.model.ScannTechPromocao;
import com.softjava.motor.model.ScannTechPromocaoTipoPagamento;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromocaoConversor {
    private static final Logger log = LoggerFactory.getLogger(PromocaoConversor.class);

    public static List<ScannTechPromocao> promocoes(PromotionResponse response) {
        log.info("Convertendo promo\u00e7\u00f5es recebidas da Scanntech.");
        ArrayList<ScannTechPromocao> registros = new ArrayList<ScannTechPromocao>();
        Optional.ofNullable(response.getResults()).orElse(Collections.emptyList()).forEach(r -> {
            if (r.getDetalles() != null && r.getDetalles().getCondiciones() != null) {
                r.getDetalles().getCondiciones().getItems().forEach(i -> i.getArticulos().forEach(reg -> {
                    ScannTechPromocao promocao = new ScannTechPromocao();
                    promocao.setIdscanntech(r.getId());
                    promocao.setTitulo(r.getTitulo());
                    promocao.setDescricao(r.getDescripcion());
                    promocao.setTipo(r.getTipo());
                    if (r.getAutor() != null) {
                        promocao.setAutor_descricao(r.getAutor().getDescripcion());
                    }
                    promocao.setVingencia_inicio(r.getVigenciaDesde());
                    promocao.setVingencia_fim(r.getVigenciaHasta());
                    promocao.setPreco(Optional.ofNullable(r.getDetalles().getPrecio()).orElse(BigDecimal.ZERO));
                    promocao.setDesconto(Optional.ofNullable(r.getDetalles().getDescuento()).orElse(BigDecimal.ZERO));
                    promocao.setPaga(Optional.ofNullable(r.getDetalles().getPaga()).orElse(BigDecimal.ZERO));
                    promocao.setLimite_promocacao_por_ticket(Optional.ofNullable(r.getLimitePromocionesPorTicket()).orElse(0L));
                    promocao.setCodigo(reg.getCodigoBarras());
                    promocao.setNome(reg.getNombre());
                    promocao.setQuantidade(Optional.ofNullable(i.getCantidad()).orElse(BigDecimal.ZERO));
                    promocao.setAtiva(true);
                    promocao.setPorPagamento(!Optional.ofNullable(r.getDetalles().getCondiciones().getFormasPago()).orElse(Collections.emptyList()).isEmpty());
                    if (!Optional.ofNullable(r.getDetalles().getCondiciones().getFormasPago()).orElse(Collections.emptyList()).isEmpty()) {
                        r.getDetalles().getCondiciones().getFormasPago().stream().forEach(p -> {
                            ScannTechPromocaoTipoPagamento tipoPag = new ScannTechPromocaoTipoPagamento();
                            tipoPag.setPromocao(promocao);
                            tipoPag.setCodigoTipoPago(p.getCodigoTipoPago());
                            tipoPag.setDescricao(p.getDescripcion());
                            p.getBines().forEach(bin -> tipoPag.adicionarBin(bin));
                            tipoPag.setTipo_pag_debito(13 == Optional.ofNullable(p.getCodigoTipoPago()).orElse(0));
                            tipoPag.setTipo_pag_credito(10 == Optional.ofNullable(p.getCodigoTipoPago()).orElse(0));
                            promocao.adicionarPag(tipoPag);
                            promocao.setCodigo_tipo_pagamento(Optional.ofNullable(p.getCodigoTipoPago()).orElse(0).intValue());
                            promocao.setTipo_pag_credito(10 == Optional.ofNullable(p.getCodigoTipoPago()).orElse(0));
                            promocao.setTipo_pag_debito(13 == Optional.ofNullable(p.getCodigoTipoPago()).orElse(0));
                        });
                    }
                    registros.add(promocao);
                }));
            }
        });
        return registros;
    }
}

