/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.integracao.scanntech.decoder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.softjava.motor.integracao.scanntech.decoder.ScanntechDecoder;
import com.softjava.motor.util.TextoUtils;
import com.softjava.motor.view.ViewPrincipal;
import feign.FeignException;
import feign.Response;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.gson.GsonDecoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanntechDecoder
implements Decoder {
    private static final Logger log = LoggerFactory.getLogger(ScanntechDecoder.class);
    private static Locale ptBr = new Locale("pt", "BR");

    public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new LocalDateSerializer(this));
        gsonBuilder.registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeSerializer(this));
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new LocalDateDeserializer(this));
        gsonBuilder.registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeDeserializer(this));
        gsonBuilder.setDateFormat("yyyy-MM-dd");
        Gson gson = gsonBuilder.setPrettyPrinting().create();
        GsonDecoder gsonDecoder = new GsonDecoder(gson);
        Object decode = gsonDecoder.decode(response, type);
        String decodificado = TextoUtils.prettyPrintJSON((String)(decode != null ? decode.toString() : ""));
        log.info("decode : " + decodificado);
        if (ViewPrincipal.EXIBIR_LOGGER) {
            ViewPrincipal.getIntance().informarDados("decode : " + decodificado);
        }
        return decode;
    }

    static /* synthetic */ Locale access$000() {
        return ptBr;
    }
}

