/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.integracao.scanntech.decoder;

import com.owlike.genson.Genson;
import com.owlike.genson.GensonBuilder;
import com.softjava.motor.integracao.scanntech.dto.ErroResponse;
import com.softjava.motor.integracao.scanntech.excessoes.ScanntechExcecao;
import feign.FeignException;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanntechErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(ScanntechErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        try {
            Genson genson = new GensonBuilder().setSkipNull(true).useDateAsTimestamp(false).create();
            String toString = response.body() != null ? IOUtils.toString((InputStream)response.body().asInputStream(), (String)"UTF-8") : "C\u00f3digo :" + response.status() + " | Sem informa\u00e7\u00f5es no retorno";
            int status = response.status();
            switch (status) {
                case 200: {
                    ErroResponse errorResponse = (ErroResponse)genson.deserialize(toString, ErroResponse.class);
                    if (errorResponse != null && StringUtils.isNotBlank((CharSequence)errorResponse.getMessage())) {
                        String message = errorResponse.getMessage();
                        ScanntechExcecao exception = new ScanntechExcecao(message);
                        exception.setErro(errorResponse);
                        return exception;
                    }
                    return FeignException.errorStatus((String)methodKey, (Response)response);
                }
                case 400: {
                    return this.converterErro(status, "400 - Dados enviado de maneira errada " + toString, toString);
                }
                case 401: {
                    return this.converterErro(status, "401 - Sem permiss\u00e3o de acesso " + toString, toString);
                }
                case 403: 
                case 404: {
                    return this.converterErro(status, "404 - Solicita\u00e7\u00e3o incorreta: " + toString, toString);
                }
                case 405: {
                    return this.converterErro(status, "405 - M\u00e9todo n\u00e3o permitido: O WebMethod que voc\u00ea est\u00e1 chamando n\u00e3o da suporte para esse tipo de opera\u00e7\u00e3o.", toString);
                }
                case 409: 
                case 429: {
                    return this.converterErro(status, "429 - Muitas requisi\u00e7\u00f5es sumultaneas, \u00e9 necess\u00e1rio aguardar 3 segundos entre uma e outra\n", toString);
                }
                case 500: {
                    return this.converterErro(status, "500 - Existem campos que n\u00e3o podem ser nulos\n" + toString, toString);
                }
            }
            try {
                toString = IOUtils.toString((InputStream)response.body().asInputStream(), (String)"UTF-8");
                ErroResponse erro = (ErroResponse)genson.deserialize(toString, ErroResponse.class);
                if (erro != null) {
                    ScanntechExcecao excessao = new ScanntechExcecao("C\u00f3digo : " + status + " | Erro n\u00e3o identificado");
                    excessao.setErro(erro);
                    return excessao;
                }
            }
            catch (IOException ignored) {
                log.error("N\u00e3o foi possivel identificar o toString do PedidoMobile\nStatus : " + response.status());
            }
        }
        catch (Exception ex) {
            log.error("Erro ao decodificar a resposta do Scanntech", (Throwable)ex);
        }
        return FeignException.errorStatus((String)methodKey, (Response)response);
    }

    private Exception converterErro(int codigo, String msg, String toString) {
        try {
            Genson genson = new GensonBuilder().setSkipNull(true).useDateAsTimestamp(false).create();
            ErroResponse errorResponse = (ErroResponse)genson.deserialize(toString, ErroResponse.class);
            if (errorResponse != null && StringUtils.isNotBlank((CharSequence)errorResponse.getMessage())) {
                String message = errorResponse.getMessage();
                ScanntechExcecao exception = new ScanntechExcecao("C\u00f3digo : " + codigo + " | Mensagem : " + message);
                exception.setErro(errorResponse);
                return exception;
            }
            return new ScanntechExcecao(msg);
        }
        catch (Exception e) {
            log.error("Erro ao converter a mensagem de erro", (Throwable)e);
            return new ScanntechExcecao(msg);
        }
    }
}

