/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.integracao.scanntech.dto;

import com.softjava.motor.integracao.scanntech.dto.CaixaScanntech;
import com.softjava.motor.model.dto.VendaDTO;
import java.math.BigDecimal;
import java.time.LocalDate;

public class CaixaScanntech {
    private LocalDate fechaVentas;
    private BigDecimal montoVentaLiquida;
    private BigDecimal montoCancelaciones;
    private int cantidadMovimientos;
    private int cantidadCancelaciones;

    public void converter(VendaDTO dto) {
        this.fechaVentas = dto.getDataVenda();
        this.montoVentaLiquida = dto.getTotal().subtract(dto.getTotalCancelada());
        this.montoCancelaciones = dto.getTotalCancelada();
        this.cantidadMovimientos = dto.getQuantidade();
        this.cantidadCancelaciones = dto.getQuantidadeCancelada();
    }

    public static CaixaScanntechBuilder builder() {
        return new CaixaScanntechBuilder();
    }

    public LocalDate getFechaVentas() {
        return this.fechaVentas;
    }

    public BigDecimal getMontoVentaLiquida() {
        return this.montoVentaLiquida;
    }

    public BigDecimal getMontoCancelaciones() {
        return this.montoCancelaciones;
    }

    public int getCantidadMovimientos() {
        return this.cantidadMovimientos;
    }

    public int getCantidadCancelaciones() {
        return this.cantidadCancelaciones;
    }

    public void setFechaVentas(LocalDate fechaVentas) {
        this.fechaVentas = fechaVentas;
    }

    public void setMontoVentaLiquida(BigDecimal montoVentaLiquida) {
        this.montoVentaLiquida = montoVentaLiquida;
    }

    public void setMontoCancelaciones(BigDecimal montoCancelaciones) {
        this.montoCancelaciones = montoCancelaciones;
    }

    public void setCantidadMovimientos(int cantidadMovimientos) {
        this.cantidadMovimientos = cantidadMovimientos;
    }

    public void setCantidadCancelaciones(int cantidadCancelaciones) {
        this.cantidadCancelaciones = cantidadCancelaciones;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaixaScanntech)) {
            return false;
        }
        CaixaScanntech other = (CaixaScanntech)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCantidadMovimientos() != other.getCantidadMovimientos()) {
            return false;
        }
        if (this.getCantidadCancelaciones() != other.getCantidadCancelaciones()) {
            return false;
        }
        LocalDate this$fechaVentas = this.getFechaVentas();
        LocalDate other$fechaVentas = other.getFechaVentas();
        if (this$fechaVentas == null ? other$fechaVentas != null : !((Object)this$fechaVentas).equals(other$fechaVentas)) {
            return false;
        }
        BigDecimal this$montoVentaLiquida = this.getMontoVentaLiquida();
        BigDecimal other$montoVentaLiquida = other.getMontoVentaLiquida();
        if (this$montoVentaLiquida == null ? other$montoVentaLiquida != null : !((Object)this$montoVentaLiquida).equals(other$montoVentaLiquida)) {
            return false;
        }
        BigDecimal this$montoCancelaciones = this.getMontoCancelaciones();
        BigDecimal other$montoCancelaciones = other.getMontoCancelaciones();
        return !(this$montoCancelaciones == null ? other$montoCancelaciones != null : !((Object)this$montoCancelaciones).equals(other$montoCancelaciones));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CaixaScanntech;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCantidadMovimientos();
        result = result * 59 + this.getCantidadCancelaciones();
        LocalDate $fechaVentas = this.getFechaVentas();
        result = result * 59 + ($fechaVentas == null ? 43 : ((Object)$fechaVentas).hashCode());
        BigDecimal $montoVentaLiquida = this.getMontoVentaLiquida();
        result = result * 59 + ($montoVentaLiquida == null ? 43 : ((Object)$montoVentaLiquida).hashCode());
        BigDecimal $montoCancelaciones = this.getMontoCancelaciones();
        result = result * 59 + ($montoCancelaciones == null ? 43 : ((Object)$montoCancelaciones).hashCode());
        return result;
    }

    public String toString() {
        return "CaixaScanntech(fechaVentas=" + this.getFechaVentas() + ", montoVentaLiquida=" + this.getMontoVentaLiquida() + ", montoCancelaciones=" + this.getMontoCancelaciones() + ", cantidadMovimientos=" + this.getCantidadMovimientos() + ", cantidadCancelaciones=" + this.getCantidadCancelaciones() + ")";
    }

    public CaixaScanntech() {
    }

    public CaixaScanntech(LocalDate fechaVentas, BigDecimal montoVentaLiquida, BigDecimal montoCancelaciones, int cantidadMovimientos, int cantidadCancelaciones) {
        this.fechaVentas = fechaVentas;
        this.montoVentaLiquida = montoVentaLiquida;
        this.montoCancelaciones = montoCancelaciones;
        this.cantidadMovimientos = cantidadMovimientos;
        this.cantidadCancelaciones = cantidadCancelaciones;
    }
}

