/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.integracao.scanntech.dto;

import com.softjava.motor.componente.util.CampoUtil;
import com.softjava.motor.integracao.scanntech.dto.TicketScanntech;
import com.softjava.motor.model.Venda;
import com.softjava.motor.model.VendaPagamento;
import com.softjava.motor.model.VendaProduto;
import com.softjava.motor.util.CalculosUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

public class TicketScanntech {
    @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ss-0300")
    private LocalDateTime fecha;
    private List<Pago> pagos;
    private BigDecimal total;
    private String numero;
    private List<Detalle> detalles;
    private BigDecimal cotizacion;
    private boolean cancelacion;
    private String codigoMoneda;
    private String descripcionCanalVenta;
    private BigDecimal recargoTotal;
    private BigDecimal descuentoTotal;
    private int codigoCanalVenta;
    private String documentoCliente;

    public void converter(Venda venda) {
        this.converter(venda, true);
    }

    public void converter(Venda venda, boolean validarEstado) {
        this.fecha = venda.getDataFechamento();
        this.total = CampoUtil.DF2((BigDecimal)venda.getTotal());
        this.numero = venda.numero(validarEstado);
        this.cotizacion = CampoUtil.DF2((BigDecimal)BigDecimal.ONE);
        this.recargoTotal = CampoUtil.DF2((BigDecimal)venda.getAcrescimo());
        this.descuentoTotal = CampoUtil.DF2((BigDecimal)venda.getDesconto());
        this.codigoMoneda = "986";
        this.cancelacion = venda.cancelada();
        this.documentoCliente = StringUtils.isBlank((CharSequence)venda.getClienteDocumento()) ? null : (venda.getClienteDocumento().length() <= 14 ? venda.getClienteDocumento() : null);
        this.codigoCanalVenta = 1;
        this.descripcionCanalVenta = "VENDA NA LOJA";
        this.detalles = new ArrayList();
        venda.getItens().forEach(item -> this.criarItem(item));
        this.pagos = new ArrayList();
        venda.getPagamentos().forEach(pag -> this.criarPag(pag));
        BigDecimal somaPagamentos = this.somaPag(this.pagos);
        if (CalculosUtils.isMaior((BigDecimal)this.total, (BigDecimal)somaPagamentos)) {
            this.total = somaPagamentos;
        }
    }

    private void criarItem(VendaProduto item) {
        Detalle detalle = new Detalle();
        detalle.setCodigoArticulo(item.cinterno());
        detalle.setCodigoBarras(item.ean13());
        detalle.setDescripcionArticulo(item.getDescricao());
        detalle.setCantidad(CampoUtil.tresCasasScanntech((BigDecimal)item.getQuantidade()));
        detalle.setImporteUnitario(CampoUtil.duasCasasScanntechHALF_DOWN((BigDecimal)item.getPrecoUnidade()));
        detalle.setDescuento(CampoUtil.duasCasasScanntechHALF_DOWN((BigDecimal)item.getDescontoItem()));
        detalle.setRecargo(CampoUtil.duasCasasScanntechHALF_DOWN((BigDecimal)item.getAcrescimo()));
        detalle.setImporte(CampoUtil.duasCasasScanntechHALF_DOWN((BigDecimal)item.getSubtotal()));
        this.detalles.add(detalle);
    }

    private void criarPag(VendaPagamento pag) {
        Pago pago = new Pago();
        pago.setCodigoTipoPago(Optional.ofNullable(pag.getCodigo()).orElse(1L));
        pago.setCodigoMoneda("986");
        pago.setImporte(CampoUtil.DF2((BigDecimal)pag.getValor().subtract(Optional.ofNullable(pag.getValorTaxa()).orElse(BigDecimal.ZERO))));
        pago.setCotizacion(CampoUtil.DF2((BigDecimal)BigDecimal.ONE));
        if ("10".equals(String.valueOf(pag.getCodigo())) || "13".equals(String.valueOf(pag.getCodigo()))) {
            pago.setBin(pag.getBin());
            pago.setUltimosDigitosTarjeta(pag.getCard_last_four_digits());
            pago.setNumeroAutorizacion(pag.getNsu());
            pago.setCodigoTarjeta(null);
        }
        pago.setDocumentoCliente(null);
        this.pagos.add(pago);
    }

    private BigDecimal somaItens(List<Detalle> itens) {
        return ((List)Optional.ofNullable(itens).orElse(new ArrayList())).stream().map(Detalle::getImporte).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal somaPag(List<Pago> itens) {
        return ((List)Optional.ofNullable(itens).orElse(new ArrayList())).stream().map(Pago::getImporte).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static TicketScanntechBuilder builder() {
        return new TicketScanntechBuilder();
    }

    public LocalDateTime getFecha() {
        return this.fecha;
    }

    public List<Pago> getPagos() {
        return this.pagos;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public String getNumero() {
        return this.numero;
    }

    public List<Detalle> getDetalles() {
        return this.detalles;
    }

    public BigDecimal getCotizacion() {
        return this.cotizacion;
    }

    public boolean isCancelacion() {
        return this.cancelacion;
    }

    public String getCodigoMoneda() {
        return this.codigoMoneda;
    }

    public String getDescripcionCanalVenta() {
        return this.descripcionCanalVenta;
    }

    public BigDecimal getRecargoTotal() {
        return this.recargoTotal;
    }

    public BigDecimal getDescuentoTotal() {
        return this.descuentoTotal;
    }

    public int getCodigoCanalVenta() {
        return this.codigoCanalVenta;
    }

    public String getDocumentoCliente() {
        return this.documentoCliente;
    }

    public void setFecha(LocalDateTime fecha) {
        this.fecha = fecha;
    }

    public void setPagos(List<Pago> pagos) {
        this.pagos = pagos;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public void setDetalles(List<Detalle> detalles) {
        this.detalles = detalles;
    }

    public void setCotizacion(BigDecimal cotizacion) {
        this.cotizacion = cotizacion;
    }

    public void setCancelacion(boolean cancelacion) {
        this.cancelacion = cancelacion;
    }

    public void setCodigoMoneda(String codigoMoneda) {
        this.codigoMoneda = codigoMoneda;
    }

    public void setDescripcionCanalVenta(String descripcionCanalVenta) {
        this.descripcionCanalVenta = descripcionCanalVenta;
    }

    public void setRecargoTotal(BigDecimal recargoTotal) {
        this.recargoTotal = recargoTotal;
    }

    public void setDescuentoTotal(BigDecimal descuentoTotal) {
        this.descuentoTotal = descuentoTotal;
    }

    public void setCodigoCanalVenta(int codigoCanalVenta) {
        this.codigoCanalVenta = codigoCanalVenta;
    }

    public void setDocumentoCliente(String documentoCliente) {
        this.documentoCliente = documentoCliente;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TicketScanntech)) {
            return false;
        }
        TicketScanntech other = (TicketScanntech)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isCancelacion() != other.isCancelacion()) {
            return false;
        }
        if (this.getCodigoCanalVenta() != other.getCodigoCanalVenta()) {
            return false;
        }
        LocalDateTime this$fecha = this.getFecha();
        LocalDateTime other$fecha = other.getFecha();
        if (this$fecha == null ? other$fecha != null : !((Object)this$fecha).equals(other$fecha)) {
            return false;
        }
        List this$pagos = this.getPagos();
        List other$pagos = other.getPagos();
        if (this$pagos == null ? other$pagos != null : !((Object)this$pagos).equals(other$pagos)) {
            return false;
        }
        BigDecimal this$total = this.getTotal();
        BigDecimal other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        List this$detalles = this.getDetalles();
        List other$detalles = other.getDetalles();
        if (this$detalles == null ? other$detalles != null : !((Object)this$detalles).equals(other$detalles)) {
            return false;
        }
        BigDecimal this$cotizacion = this.getCotizacion();
        BigDecimal other$cotizacion = other.getCotizacion();
        if (this$cotizacion == null ? other$cotizacion != null : !((Object)this$cotizacion).equals(other$cotizacion)) {
            return false;
        }
        String this$codigoMoneda = this.getCodigoMoneda();
        String other$codigoMoneda = other.getCodigoMoneda();
        if (this$codigoMoneda == null ? other$codigoMoneda != null : !this$codigoMoneda.equals(other$codigoMoneda)) {
            return false;
        }
        String this$descripcionCanalVenta = this.getDescripcionCanalVenta();
        String other$descripcionCanalVenta = other.getDescripcionCanalVenta();
        if (this$descripcionCanalVenta == null ? other$descripcionCanalVenta != null : !this$descripcionCanalVenta.equals(other$descripcionCanalVenta)) {
            return false;
        }
        BigDecimal this$recargoTotal = this.getRecargoTotal();
        BigDecimal other$recargoTotal = other.getRecargoTotal();
        if (this$recargoTotal == null ? other$recargoTotal != null : !((Object)this$recargoTotal).equals(other$recargoTotal)) {
            return false;
        }
        BigDecimal this$descuentoTotal = this.getDescuentoTotal();
        BigDecimal other$descuentoTotal = other.getDescuentoTotal();
        if (this$descuentoTotal == null ? other$descuentoTotal != null : !((Object)this$descuentoTotal).equals(other$descuentoTotal)) {
            return false;
        }
        String this$documentoCliente = this.getDocumentoCliente();
        String other$documentoCliente = other.getDocumentoCliente();
        return !(this$documentoCliente == null ? other$documentoCliente != null : !this$documentoCliente.equals(other$documentoCliente));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TicketScanntech;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCancelacion() ? 79 : 97);
        result = result * 59 + this.getCodigoCanalVenta();
        LocalDateTime $fecha = this.getFecha();
        result = result * 59 + ($fecha == null ? 43 : ((Object)$fecha).hashCode());
        List $pagos = this.getPagos();
        result = result * 59 + ($pagos == null ? 43 : ((Object)$pagos).hashCode());
        BigDecimal $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        List $detalles = this.getDetalles();
        result = result * 59 + ($detalles == null ? 43 : ((Object)$detalles).hashCode());
        BigDecimal $cotizacion = this.getCotizacion();
        result = result * 59 + ($cotizacion == null ? 43 : ((Object)$cotizacion).hashCode());
        String $codigoMoneda = this.getCodigoMoneda();
        result = result * 59 + ($codigoMoneda == null ? 43 : $codigoMoneda.hashCode());
        String $descripcionCanalVenta = this.getDescripcionCanalVenta();
        result = result * 59 + ($descripcionCanalVenta == null ? 43 : $descripcionCanalVenta.hashCode());
        BigDecimal $recargoTotal = this.getRecargoTotal();
        result = result * 59 + ($recargoTotal == null ? 43 : ((Object)$recargoTotal).hashCode());
        BigDecimal $descuentoTotal = this.getDescuentoTotal();
        result = result * 59 + ($descuentoTotal == null ? 43 : ((Object)$descuentoTotal).hashCode());
        String $documentoCliente = this.getDocumentoCliente();
        result = result * 59 + ($documentoCliente == null ? 43 : $documentoCliente.hashCode());
        return result;
    }

    public String toString() {
        return "TicketScanntech(fecha=" + this.getFecha() + ", pagos=" + this.getPagos() + ", total=" + this.getTotal() + ", numero=" + this.getNumero() + ", detalles=" + this.getDetalles() + ", cotizacion=" + this.getCotizacion() + ", cancelacion=" + this.isCancelacion() + ", codigoMoneda=" + this.getCodigoMoneda() + ", descripcionCanalVenta=" + this.getDescripcionCanalVenta() + ", recargoTotal=" + this.getRecargoTotal() + ", descuentoTotal=" + this.getDescuentoTotal() + ", codigoCanalVenta=" + this.getCodigoCanalVenta() + ", documentoCliente=" + this.getDocumentoCliente() + ")";
    }

    public TicketScanntech() {
    }

    public TicketScanntech(LocalDateTime fecha, List<Pago> pagos, BigDecimal total, String numero, List<Detalle> detalles, BigDecimal cotizacion, boolean cancelacion, String codigoMoneda, String descripcionCanalVenta, BigDecimal recargoTotal, BigDecimal descuentoTotal, int codigoCanalVenta, String documentoCliente) {
        this.fecha = fecha;
        this.pagos = pagos;
        this.total = total;
        this.numero = numero;
        this.detalles = detalles;
        this.cotizacion = cotizacion;
        this.cancelacion = cancelacion;
        this.codigoMoneda = codigoMoneda;
        this.descripcionCanalVenta = descripcionCanalVenta;
        this.recargoTotal = recargoTotal;
        this.descuentoTotal = descuentoTotal;
        this.codigoCanalVenta = codigoCanalVenta;
        this.documentoCliente = documentoCliente;
    }
}

