/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.integracao.scanntech.ws;

import com.softjava.motor.integracao.scanntech.decoder.ScanntechDecoder;
import com.softjava.motor.integracao.scanntech.decoder.ScanntechErrorDecoder;
import com.softjava.motor.integracao.scanntech.dto.CaixaScanntech;
import com.softjava.motor.integracao.scanntech.dto.PromotionResponse;
import com.softjava.motor.integracao.scanntech.dto.ScanntehReenvioDTO;
import com.softjava.motor.integracao.scanntech.dto.TicketScanntech;
import com.softjava.motor.integracao.scanntech.encoder.ScanntechEncoder;
import com.softjava.motor.integracao.scanntech.excessoes.ScanntechExcecao;
import com.softjava.motor.integracao.scanntech.log.LogBean;
import com.softjava.motor.integracao.scanntech.ws.ScannTechWS;
import com.softjava.motor.util.EthernetUtil;
import feign.Feign;
import feign.FeignException;
import feign.Logger;
import feign.Request;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"file:${user.dir}/config.properties"})
public class ScannTechUtils {
    @Value(value="${scanntecth.usuario}")
    private String usuario;
    @Value(value="${scanntecth.senha}")
    private String senha;
    @Value(value="${scanntecth.empresa}")
    private String empresa;
    @Value(value="${scanntecth.local}")
    private String local;
    @Value(value="${scanntecth.url_1}")
    private String url_1;
    @Value(value="${scanntecth.url_2}")
    private String url_2;
    @Value(value="${scanntecth.url_3}")
    private String url_3;
    private Log log = LogFactory.getLog((String)"(ScannTechUtils)");

    public PromotionResponse consultarPromocoes() throws ScanntechExcecao {
        this.log.info((Object)("consultarPromocoes( Empresa : " + this.empresa + " )"));
        try {
            String url = this.url();
            PromotionResponse response = ((ScannTechWS)Feign.builder().encoder((Encoder)new ScanntechEncoder()).decoder((Decoder)new ScanntechDecoder()).errorDecoder((ErrorDecoder)new ScanntechErrorDecoder()).logger((Logger)new LogBean()).logLevel(Logger.Level.FULL).options(new Request.Options(5000, 5000)).target(ScannTechWS.class, url)).promocoesAceitas(this.token(), this.empresa, this.local);
            return response;
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            this.log.error((Object)undeclaredThrowableException.getMessage(), (Throwable)undeclaredThrowableException);
            Throwable undeclaredThrowable = undeclaredThrowableException.getUndeclaredThrowable();
            if (undeclaredThrowable instanceof ScanntechExcecao) {
                ScanntechExcecao excessao = (ScanntechExcecao)undeclaredThrowable;
                throw excessao;
            }
            throw new ScanntechExcecao(undeclaredThrowable.getMessage());
        }
        catch (FeignException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScanntechExcecao(e.getMessage());
        }
    }

    public PromotionResponse consultarPromocoesPorPagamento() throws ScanntechExcecao {
        this.log.info((Object)("consultarPromocoes( Empresa : " + this.empresa + " )"));
        try {
            String url = this.url();
            PromotionResponse response = ((ScannTechWS)Feign.builder().encoder((Encoder)new ScanntechEncoder()).decoder((Decoder)new ScanntechDecoder()).errorDecoder((ErrorDecoder)new ScanntechErrorDecoder()).logger((Logger)new LogBean()).logLevel(Logger.Level.FULL).options(new Request.Options(5000, 5000)).target(ScannTechWS.class, url)).promocoesAceitasPorPag(this.token(), this.empresa, this.local);
            return response;
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            this.log.error((Object)undeclaredThrowableException.getMessage(), (Throwable)undeclaredThrowableException);
            Throwable undeclaredThrowable = undeclaredThrowableException.getUndeclaredThrowable();
            if (undeclaredThrowable instanceof ScanntechExcecao) {
                ScanntechExcecao excessao = (ScanntechExcecao)undeclaredThrowable;
                throw excessao;
            }
            throw new ScanntechExcecao(undeclaredThrowable.getMessage());
        }
        catch (FeignException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScanntechExcecao(e.getMessage());
        }
    }

    public List<ScanntehReenvioDTO> consultaReenvioMovimento() throws ScanntechExcecao {
        this.log.info((Object)("consultaReenvioMovimento( Empresa : " + this.empresa + " )"));
        try {
            String url = this.url();
            List registros = ((ScannTechWS)Feign.builder().encoder((Encoder)new ScanntechEncoder()).decoder((Decoder)new ScanntechDecoder()).errorDecoder((ErrorDecoder)new ScanntechErrorDecoder()).logger((Logger)new LogBean()).logLevel(Logger.Level.FULL).options(new Request.Options(5000, 5000)).target(ScannTechWS.class, url)).consultaReenvioMovimento(this.token(), this.empresa, this.local);
            return Optional.ofNullable(registros).orElse(Collections.emptyList());
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            this.log.error((Object)undeclaredThrowableException.getMessage(), (Throwable)undeclaredThrowableException);
            Throwable undeclaredThrowable = undeclaredThrowableException.getUndeclaredThrowable();
            if (undeclaredThrowable instanceof ScanntechExcecao) {
                ScanntechExcecao excessao = (ScanntechExcecao)undeclaredThrowable;
                throw excessao;
            }
            throw new ScanntechExcecao(undeclaredThrowable.getMessage());
        }
        catch (FeignException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScanntechExcecao(e.getMessage());
        }
    }

    public List<ScanntehReenvioDTO> consultaReenvioFechamento() throws ScanntechExcecao {
        this.log.info((Object)("consultaReenvioFechamento( Empresa : " + this.empresa + " )"));
        try {
            String url = this.url();
            List registros = ((ScannTechWS)Feign.builder().encoder((Encoder)new ScanntechEncoder()).decoder((Decoder)new ScanntechDecoder()).errorDecoder((ErrorDecoder)new ScanntechErrorDecoder()).logger((Logger)new LogBean()).logLevel(Logger.Level.FULL).options(new Request.Options(5000, 5000)).target(ScannTechWS.class, url)).consultaReenvioFechamento(this.token(), this.empresa, this.local);
            return Optional.ofNullable(registros).orElse(Collections.emptyList());
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            this.log.error((Object)undeclaredThrowableException.getMessage(), (Throwable)undeclaredThrowableException);
            Throwable undeclaredThrowable = undeclaredThrowableException.getUndeclaredThrowable();
            if (undeclaredThrowable instanceof ScanntechExcecao) {
                ScanntechExcecao excessao = (ScanntechExcecao)undeclaredThrowable;
                throw excessao;
            }
            throw new ScanntechExcecao(undeclaredThrowable.getMessage());
        }
        catch (FeignException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScanntechExcecao(e.getMessage());
        }
    }

    public void enviarVenda(Integer caixa, TicketScanntech body) throws ScanntechExcecao {
        this.log.info((Object)("enviarVenda( Empresa : " + this.empresa + " )"));
        try {
            String url = this.url();
            ((ScannTechWS)Feign.builder().encoder((Encoder)new ScanntechEncoder()).decoder((Decoder)new ScanntechDecoder()).errorDecoder((ErrorDecoder)new ScanntechErrorDecoder()).logger((Logger)new LogBean()).logLevel(Logger.Level.FULL).options(new Request.Options(5000, 5000)).target(ScannTechWS.class, url)).enviarVenda(this.token(), this.empresa, this.local, caixa, body);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            this.log.error((Object)undeclaredThrowableException.getMessage(), (Throwable)undeclaredThrowableException);
            Throwable undeclaredThrowable = undeclaredThrowableException.getUndeclaredThrowable();
            if (undeclaredThrowable instanceof ScanntechExcecao) {
                ScanntechExcecao excessao = (ScanntechExcecao)undeclaredThrowable;
                throw excessao;
            }
            throw new ScanntechExcecao(undeclaredThrowable.getMessage());
        }
        catch (FeignException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScanntechExcecao(e.getMessage());
        }
    }

    public void enviarCaixa(Integer caixa, CaixaScanntech body) throws ScanntechExcecao {
        this.log.info((Object)("enviarCaixa( Empresa : " + this.empresa + " )"));
        try {
            String url = this.url();
            ((ScannTechWS)Feign.builder().encoder((Encoder)new ScanntechEncoder()).decoder((Decoder)new ScanntechDecoder()).errorDecoder((ErrorDecoder)new ScanntechErrorDecoder()).logger((Logger)new LogBean()).logLevel(Logger.Level.FULL).options(new Request.Options(5000, 5000)).target(ScannTechWS.class, url)).enviarCaixa(this.token(), this.empresa, this.local, caixa, body);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            this.log.error((Object)undeclaredThrowableException.getMessage(), (Throwable)undeclaredThrowableException);
            Throwable undeclaredThrowable = undeclaredThrowableException.getUndeclaredThrowable();
            if (undeclaredThrowable instanceof ScanntechExcecao) {
                ScanntechExcecao excessao = (ScanntechExcecao)undeclaredThrowable;
                throw excessao;
            }
            throw new ScanntechExcecao(undeclaredThrowable.getMessage());
        }
        catch (FeignException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScanntechExcecao(e.getMessage());
        }
    }

    private String token() {
        this.log.info((Object)"Gerando token de acesso ao servi\u00e7o Scanntech");
        String usuarioAndSenha = this.usuario + ":" + this.senha;
        String authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString(usuarioAndSenha.getBytes());
        this.log.info((Object)"Token gerado com sucesso");
        return authorizationHeaderValue;
    }

    private String url() {
        if (EthernetUtil.ping((String)this.url_1)) {
            System.out.println("Usando URL 1");
            return this.url_1;
        }
        if (EthernetUtil.ping((String)this.url_2)) {
            System.out.println("Usando URL 2");
            return this.url_2;
        }
        if (EthernetUtil.ping((String)this.url_3)) {
            System.out.println("Usando URL 3");
            return this.url_3;
        }
        System.out.println("Usando URL padr\u00e3o");
        return this.url_1;
    }
}

