/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.model;

import com.softjava.motor.model.ScannTechPromocaoTipoPagamento;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="scanntech_promocao")
public class ScannTechPromocao
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="scanntech_promocao_sequence", sequenceName="scanntech_promocao_sequence", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="scanntech_promocao_sequence")
    @Column(name="id")
    private Long id;
    @NotFound(action=NotFoundAction.IGNORE)
    @Column(name="idscanntech")
    private Long idscanntech;
    @Column(name="descricao")
    private String descricao;
    @Column(name="titulo")
    private String titulo;
    @Column(name="tipo")
    private String tipo;
    @Column(name="autor_descricao")
    private String autor_descricao;
    @Column(name="quantidade", precision=20, scale=10)
    private BigDecimal quantidade = BigDecimal.ZERO;
    @Column(name="nome")
    private String nome;
    @Column(name="codigo")
    private String codigo;
    @Column(name="beneficios")
    private String beneficios;
    @Column(name="preco", precision=20, scale=10)
    private BigDecimal preco = BigDecimal.ZERO;
    @Column(name="desconto", precision=20, scale=10)
    private BigDecimal desconto = BigDecimal.ZERO;
    @Column(name="paga", precision=20, scale=10)
    private BigDecimal paga = BigDecimal.ZERO;
    @Column(name="vingencia_inicio")
    private LocalDateTime vingencia_inicio = LocalDateTime.now();
    @Column(name="vingencia_fim")
    private LocalDateTime vingencia_fim = LocalDateTime.now();
    @Column(name="data_cadastro")
    private LocalDateTime data_cadastro = LocalDateTime.now();
    @Column(name="data_inativacao")
    private LocalDateTime data_inativacao = LocalDateTime.now();
    @Column(name="limite_promocacao_por_ticket")
    private Long limite_promocacao_por_ticket;
    @Column(name="ativa")
    private boolean ativa;
    @Column(name="por_pagamento")
    private boolean porPagamento;
    @Column(name="codigo_tipo_pagamento")
    private int codigo_tipo_pagamento;
    @Column(name="tipo_pag_credito")
    private boolean tipo_pag_credito;
    @Column(name="tipo_pag_debito")
    private boolean tipo_pag_debito;
    @OneToMany(mappedBy="promocao", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    List<ScannTechPromocaoTipoPagamento> pagamentos = new ArrayList();

    public void adicionarPag(ScannTechPromocaoTipoPagamento tipoPag) {
        this.pagamentos.add(tipoPag);
    }

    public Long getId() {
        return this.id;
    }

    public Long getIdscanntech() {
        return this.idscanntech;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public String getTipo() {
        return this.tipo;
    }

    public String getAutor_descricao() {
        return this.autor_descricao;
    }

    public BigDecimal getQuantidade() {
        return this.quantidade;
    }

    public String getNome() {
        return this.nome;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getBeneficios() {
        return this.beneficios;
    }

    public BigDecimal getPreco() {
        return this.preco;
    }

    public BigDecimal getDesconto() {
        return this.desconto;
    }

    public BigDecimal getPaga() {
        return this.paga;
    }

    public LocalDateTime getVingencia_inicio() {
        return this.vingencia_inicio;
    }

    public LocalDateTime getVingencia_fim() {
        return this.vingencia_fim;
    }

    public LocalDateTime getData_cadastro() {
        return this.data_cadastro;
    }

    public LocalDateTime getData_inativacao() {
        return this.data_inativacao;
    }

    public Long getLimite_promocacao_por_ticket() {
        return this.limite_promocacao_por_ticket;
    }

    public boolean isAtiva() {
        return this.ativa;
    }

    public boolean isPorPagamento() {
        return this.porPagamento;
    }

    public int getCodigo_tipo_pagamento() {
        return this.codigo_tipo_pagamento;
    }

    public boolean isTipo_pag_credito() {
        return this.tipo_pag_credito;
    }

    public boolean isTipo_pag_debito() {
        return this.tipo_pag_debito;
    }

    public List<ScannTechPromocaoTipoPagamento> getPagamentos() {
        return this.pagamentos;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setIdscanntech(Long idscanntech) {
        this.idscanntech = idscanntech;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public void setAutor_descricao(String autor_descricao) {
        this.autor_descricao = autor_descricao;
    }

    public void setQuantidade(BigDecimal quantidade) {
        this.quantidade = quantidade;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setBeneficios(String beneficios) {
        this.beneficios = beneficios;
    }

    public void setPreco(BigDecimal preco) {
        this.preco = preco;
    }

    public void setDesconto(BigDecimal desconto) {
        this.desconto = desconto;
    }

    public void setPaga(BigDecimal paga) {
        this.paga = paga;
    }

    public void setVingencia_inicio(LocalDateTime vingencia_inicio) {
        this.vingencia_inicio = vingencia_inicio;
    }

    public void setVingencia_fim(LocalDateTime vingencia_fim) {
        this.vingencia_fim = vingencia_fim;
    }

    public void setData_cadastro(LocalDateTime data_cadastro) {
        this.data_cadastro = data_cadastro;
    }

    public void setData_inativacao(LocalDateTime data_inativacao) {
        this.data_inativacao = data_inativacao;
    }

    public void setLimite_promocacao_por_ticket(Long limite_promocacao_por_ticket) {
        this.limite_promocacao_por_ticket = limite_promocacao_por_ticket;
    }

    public void setAtiva(boolean ativa) {
        this.ativa = ativa;
    }

    public void setPorPagamento(boolean porPagamento) {
        this.porPagamento = porPagamento;
    }

    public void setCodigo_tipo_pagamento(int codigo_tipo_pagamento) {
        this.codigo_tipo_pagamento = codigo_tipo_pagamento;
    }

    public void setTipo_pag_credito(boolean tipo_pag_credito) {
        this.tipo_pag_credito = tipo_pag_credito;
    }

    public void setTipo_pag_debito(boolean tipo_pag_debito) {
        this.tipo_pag_debito = tipo_pag_debito;
    }

    public void setPagamentos(List<ScannTechPromocaoTipoPagamento> pagamentos) {
        this.pagamentos = pagamentos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScannTechPromocao)) {
            return false;
        }
        ScannTechPromocao other = (ScannTechPromocao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isAtiva() != other.isAtiva()) {
            return false;
        }
        if (this.isPorPagamento() != other.isPorPagamento()) {
            return false;
        }
        if (this.getCodigo_tipo_pagamento() != other.getCodigo_tipo_pagamento()) {
            return false;
        }
        if (this.isTipo_pag_credito() != other.isTipo_pag_credito()) {
            return false;
        }
        if (this.isTipo_pag_debito() != other.isTipo_pag_debito()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idscanntech = this.getIdscanntech();
        Long other$idscanntech = other.getIdscanntech();
        if (this$idscanntech == null ? other$idscanntech != null : !((Object)this$idscanntech).equals(other$idscanntech)) {
            return false;
        }
        Long this$limite_promocacao_por_ticket = this.getLimite_promocacao_por_ticket();
        Long other$limite_promocacao_por_ticket = other.getLimite_promocacao_por_ticket();
        if (this$limite_promocacao_por_ticket == null ? other$limite_promocacao_por_ticket != null : !((Object)this$limite_promocacao_por_ticket).equals(other$limite_promocacao_por_ticket)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        String this$titulo = this.getTitulo();
        String other$titulo = other.getTitulo();
        if (this$titulo == null ? other$titulo != null : !this$titulo.equals(other$titulo)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$autor_descricao = this.getAutor_descricao();
        String other$autor_descricao = other.getAutor_descricao();
        if (this$autor_descricao == null ? other$autor_descricao != null : !this$autor_descricao.equals(other$autor_descricao)) {
            return false;
        }
        BigDecimal this$quantidade = this.getQuantidade();
        BigDecimal other$quantidade = other.getQuantidade();
        if (this$quantidade == null ? other$quantidade != null : !((Object)this$quantidade).equals(other$quantidade)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$codigo = this.getCodigo();
        String other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !this$codigo.equals(other$codigo)) {
            return false;
        }
        String this$beneficios = this.getBeneficios();
        String other$beneficios = other.getBeneficios();
        if (this$beneficios == null ? other$beneficios != null : !this$beneficios.equals(other$beneficios)) {
            return false;
        }
        BigDecimal this$preco = this.getPreco();
        BigDecimal other$preco = other.getPreco();
        if (this$preco == null ? other$preco != null : !((Object)this$preco).equals(other$preco)) {
            return false;
        }
        BigDecimal this$desconto = this.getDesconto();
        BigDecimal other$desconto = other.getDesconto();
        if (this$desconto == null ? other$desconto != null : !((Object)this$desconto).equals(other$desconto)) {
            return false;
        }
        BigDecimal this$paga = this.getPaga();
        BigDecimal other$paga = other.getPaga();
        if (this$paga == null ? other$paga != null : !((Object)this$paga).equals(other$paga)) {
            return false;
        }
        LocalDateTime this$vingencia_inicio = this.getVingencia_inicio();
        LocalDateTime other$vingencia_inicio = other.getVingencia_inicio();
        if (this$vingencia_inicio == null ? other$vingencia_inicio != null : !((Object)this$vingencia_inicio).equals(other$vingencia_inicio)) {
            return false;
        }
        LocalDateTime this$vingencia_fim = this.getVingencia_fim();
        LocalDateTime other$vingencia_fim = other.getVingencia_fim();
        if (this$vingencia_fim == null ? other$vingencia_fim != null : !((Object)this$vingencia_fim).equals(other$vingencia_fim)) {
            return false;
        }
        LocalDateTime this$data_cadastro = this.getData_cadastro();
        LocalDateTime other$data_cadastro = other.getData_cadastro();
        if (this$data_cadastro == null ? other$data_cadastro != null : !((Object)this$data_cadastro).equals(other$data_cadastro)) {
            return false;
        }
        LocalDateTime this$data_inativacao = this.getData_inativacao();
        LocalDateTime other$data_inativacao = other.getData_inativacao();
        if (this$data_inativacao == null ? other$data_inativacao != null : !((Object)this$data_inativacao).equals(other$data_inativacao)) {
            return false;
        }
        List this$pagamentos = this.getPagamentos();
        List other$pagamentos = other.getPagamentos();
        return !(this$pagamentos == null ? other$pagamentos != null : !((Object)this$pagamentos).equals(other$pagamentos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScannTechPromocao;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAtiva() ? 79 : 97);
        result = result * 59 + (this.isPorPagamento() ? 79 : 97);
        result = result * 59 + this.getCodigo_tipo_pagamento();
        result = result * 59 + (this.isTipo_pag_credito() ? 79 : 97);
        result = result * 59 + (this.isTipo_pag_debito() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idscanntech = this.getIdscanntech();
        result = result * 59 + ($idscanntech == null ? 43 : ((Object)$idscanntech).hashCode());
        Long $limite_promocacao_por_ticket = this.getLimite_promocacao_por_ticket();
        result = result * 59 + ($limite_promocacao_por_ticket == null ? 43 : ((Object)$limite_promocacao_por_ticket).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        String $titulo = this.getTitulo();
        result = result * 59 + ($titulo == null ? 43 : $titulo.hashCode());
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $autor_descricao = this.getAutor_descricao();
        result = result * 59 + ($autor_descricao == null ? 43 : $autor_descricao.hashCode());
        BigDecimal $quantidade = this.getQuantidade();
        result = result * 59 + ($quantidade == null ? 43 : ((Object)$quantidade).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : $codigo.hashCode());
        String $beneficios = this.getBeneficios();
        result = result * 59 + ($beneficios == null ? 43 : $beneficios.hashCode());
        BigDecimal $preco = this.getPreco();
        result = result * 59 + ($preco == null ? 43 : ((Object)$preco).hashCode());
        BigDecimal $desconto = this.getDesconto();
        result = result * 59 + ($desconto == null ? 43 : ((Object)$desconto).hashCode());
        BigDecimal $paga = this.getPaga();
        result = result * 59 + ($paga == null ? 43 : ((Object)$paga).hashCode());
        LocalDateTime $vingencia_inicio = this.getVingencia_inicio();
        result = result * 59 + ($vingencia_inicio == null ? 43 : ((Object)$vingencia_inicio).hashCode());
        LocalDateTime $vingencia_fim = this.getVingencia_fim();
        result = result * 59 + ($vingencia_fim == null ? 43 : ((Object)$vingencia_fim).hashCode());
        LocalDateTime $data_cadastro = this.getData_cadastro();
        result = result * 59 + ($data_cadastro == null ? 43 : ((Object)$data_cadastro).hashCode());
        LocalDateTime $data_inativacao = this.getData_inativacao();
        result = result * 59 + ($data_inativacao == null ? 43 : ((Object)$data_inativacao).hashCode());
        List $pagamentos = this.getPagamentos();
        result = result * 59 + ($pagamentos == null ? 43 : ((Object)$pagamentos).hashCode());
        return result;
    }

    public String toString() {
        return "ScannTechPromocao(id=" + this.getId() + ", idscanntech=" + this.getIdscanntech() + ", descricao=" + this.getDescricao() + ", titulo=" + this.getTitulo() + ", tipo=" + this.getTipo() + ", autor_descricao=" + this.getAutor_descricao() + ", quantidade=" + this.getQuantidade() + ", nome=" + this.getNome() + ", codigo=" + this.getCodigo() + ", beneficios=" + this.getBeneficios() + ", preco=" + this.getPreco() + ", desconto=" + this.getDesconto() + ", paga=" + this.getPaga() + ", vingencia_inicio=" + this.getVingencia_inicio() + ", vingencia_fim=" + this.getVingencia_fim() + ", data_cadastro=" + this.getData_cadastro() + ", data_inativacao=" + this.getData_inativacao() + ", limite_promocacao_por_ticket=" + this.getLimite_promocacao_por_ticket() + ", ativa=" + this.isAtiva() + ", porPagamento=" + this.isPorPagamento() + ", codigo_tipo_pagamento=" + this.getCodigo_tipo_pagamento() + ", tipo_pag_credito=" + this.isTipo_pag_credito() + ", tipo_pag_debito=" + this.isTipo_pag_debito() + ", pagamentos=" + this.getPagamentos() + ")";
    }
}

