/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.model;

import com.softjava.motor.model.ScannTechPromocao;
import com.softjava.motor.model.ScannTechPromocaoTipoPagamentoBin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="scanntech_promocao_tipo_pagamento")
public class ScannTechPromocaoTipoPagamento
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="scanntech_promocao_tipo_pagamento_sequence", sequenceName="scanntech_promocao_tipo_pagamento_sequence", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="scanntech_promocao_tipo_pagamento_sequence")
    @Column(name="id")
    private Long id;
    @ManyToOne
    @JoinColumn(name="idscanntech_promocao")
    private ScannTechPromocao promocao;
    @Column(name="codigo_tipo_pago")
    private int codigoTipoPago;
    @Column(name="descricao")
    private String descricao;
    @Column(name="tipo_pag_credito")
    private boolean tipo_pag_credito;
    @Column(name="tipo_pag_debito")
    private boolean tipo_pag_debito;
    @OneToMany(mappedBy="pagamento", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    List<ScannTechPromocaoTipoPagamentoBin> bins = new ArrayList();

    public void adicionarBin(String bin) {
        ScannTechPromocaoTipoPagamentoBin binObj = new ScannTechPromocaoTipoPagamentoBin();
        binObj.setPagamento(this);
        binObj.setBin(bin);
        this.bins.add(binObj);
    }

    public Long getId() {
        return this.id;
    }

    public ScannTechPromocao getPromocao() {
        return this.promocao;
    }

    public int getCodigoTipoPago() {
        return this.codigoTipoPago;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public boolean isTipo_pag_credito() {
        return this.tipo_pag_credito;
    }

    public boolean isTipo_pag_debito() {
        return this.tipo_pag_debito;
    }

    public List<ScannTechPromocaoTipoPagamentoBin> getBins() {
        return this.bins;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPromocao(ScannTechPromocao promocao) {
        this.promocao = promocao;
    }

    public void setCodigoTipoPago(int codigoTipoPago) {
        this.codigoTipoPago = codigoTipoPago;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setTipo_pag_credito(boolean tipo_pag_credito) {
        this.tipo_pag_credito = tipo_pag_credito;
    }

    public void setTipo_pag_debito(boolean tipo_pag_debito) {
        this.tipo_pag_debito = tipo_pag_debito;
    }

    public void setBins(List<ScannTechPromocaoTipoPagamentoBin> bins) {
        this.bins = bins;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScannTechPromocaoTipoPagamento)) {
            return false;
        }
        ScannTechPromocaoTipoPagamento other = (ScannTechPromocaoTipoPagamento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCodigoTipoPago() != other.getCodigoTipoPago()) {
            return false;
        }
        if (this.isTipo_pag_credito() != other.isTipo_pag_credito()) {
            return false;
        }
        if (this.isTipo_pag_debito() != other.isTipo_pag_debito()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        ScannTechPromocao this$promocao = this.getPromocao();
        ScannTechPromocao other$promocao = other.getPromocao();
        if (this$promocao == null ? other$promocao != null : !this$promocao.equals(other$promocao)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        List this$bins = this.getBins();
        List other$bins = other.getBins();
        return !(this$bins == null ? other$bins != null : !((Object)this$bins).equals(other$bins));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScannTechPromocaoTipoPagamento;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCodigoTipoPago();
        result = result * 59 + (this.isTipo_pag_credito() ? 79 : 97);
        result = result * 59 + (this.isTipo_pag_debito() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        ScannTechPromocao $promocao = this.getPromocao();
        result = result * 59 + ($promocao == null ? 43 : $promocao.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        List $bins = this.getBins();
        result = result * 59 + ($bins == null ? 43 : ((Object)$bins).hashCode());
        return result;
    }

    public String toString() {
        return "ScannTechPromocaoTipoPagamento(id=" + this.getId() + ", promocao=" + this.getPromocao() + ", codigoTipoPago=" + this.getCodigoTipoPago() + ", descricao=" + this.getDescricao() + ", tipo_pag_credito=" + this.isTipo_pag_credito() + ", tipo_pag_debito=" + this.isTipo_pag_debito() + ", bins=" + this.getBins() + ")";
    }
}

