/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.model;

import com.softjava.motor.integracao.scanntech.dto.ScanntehReenvioDTO;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="scanntech_reenvio")
public class ScannTechReenvio
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="scanntech_reenvio_sequence", sequenceName="scanntech_reenvio_sequence", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="scanntech_reenvio_sequence")
    @Column(name="id")
    private Long id;
    @Column(name="codigo_caixa")
    private Integer codigoCaixa;
    @Column(name="tipo")
    private String tipo;
    @Column(name="data_registro")
    private LocalDate dataRegistro;
    @Column(name="reenviado")
    private boolean reenviado;
    @Column(name="reenviado_scanntech")
    private boolean reenviadoScanntech;
    @Column(name="reenviado_scanntech_confirmado_caixa")
    private boolean reenviadoScanntechConfirmadoCaixa;

    public void converter(ScanntehReenvioDTO dto) {
        this.codigoCaixa = dto.getCodigoCaja();
        this.dataRegistro = dto.getFecha();
        this.tipo = dto.getTipo();
        this.reenviado = false;
        if ("CIERRES_DIARIOS".equals(dto.getTipo()) && dto.getCodigoCaja() == null) {
            this.reenviadoScanntech = false;
            this.reenviadoScanntechConfirmadoCaixa = false;
        } else {
            this.reenviadoScanntech = true;
            this.reenviadoScanntechConfirmadoCaixa = true;
        }
    }

    public Long getId() {
        return this.id;
    }

    public Integer getCodigoCaixa() {
        return this.codigoCaixa;
    }

    public String getTipo() {
        return this.tipo;
    }

    public LocalDate getDataRegistro() {
        return this.dataRegistro;
    }

    public boolean isReenviado() {
        return this.reenviado;
    }

    public boolean isReenviadoScanntech() {
        return this.reenviadoScanntech;
    }

    public boolean isReenviadoScanntechConfirmadoCaixa() {
        return this.reenviadoScanntechConfirmadoCaixa;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCodigoCaixa(Integer codigoCaixa) {
        this.codigoCaixa = codigoCaixa;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public void setDataRegistro(LocalDate dataRegistro) {
        this.dataRegistro = dataRegistro;
    }

    public void setReenviado(boolean reenviado) {
        this.reenviado = reenviado;
    }

    public void setReenviadoScanntech(boolean reenviadoScanntech) {
        this.reenviadoScanntech = reenviadoScanntech;
    }

    public void setReenviadoScanntechConfirmadoCaixa(boolean reenviadoScanntechConfirmadoCaixa) {
        this.reenviadoScanntechConfirmadoCaixa = reenviadoScanntechConfirmadoCaixa;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScannTechReenvio)) {
            return false;
        }
        ScannTechReenvio other = (ScannTechReenvio)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isReenviado() != other.isReenviado()) {
            return false;
        }
        if (this.isReenviadoScanntech() != other.isReenviadoScanntech()) {
            return false;
        }
        if (this.isReenviadoScanntechConfirmadoCaixa() != other.isReenviadoScanntechConfirmadoCaixa()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$codigoCaixa = this.getCodigoCaixa();
        Integer other$codigoCaixa = other.getCodigoCaixa();
        if (this$codigoCaixa == null ? other$codigoCaixa != null : !((Object)this$codigoCaixa).equals(other$codigoCaixa)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        LocalDate this$dataRegistro = this.getDataRegistro();
        LocalDate other$dataRegistro = other.getDataRegistro();
        return !(this$dataRegistro == null ? other$dataRegistro != null : !((Object)this$dataRegistro).equals(other$dataRegistro));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScannTechReenvio;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReenviado() ? 79 : 97);
        result = result * 59 + (this.isReenviadoScanntech() ? 79 : 97);
        result = result * 59 + (this.isReenviadoScanntechConfirmadoCaixa() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $codigoCaixa = this.getCodigoCaixa();
        result = result * 59 + ($codigoCaixa == null ? 43 : ((Object)$codigoCaixa).hashCode());
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        LocalDate $dataRegistro = this.getDataRegistro();
        result = result * 59 + ($dataRegistro == null ? 43 : ((Object)$dataRegistro).hashCode());
        return result;
    }

    public String toString() {
        return "ScannTechReenvio(id=" + this.getId() + ", codigoCaixa=" + this.getCodigoCaixa() + ", tipo=" + this.getTipo() + ", dataRegistro=" + this.getDataRegistro() + ", reenviado=" + this.isReenviado() + ", reenviadoScanntech=" + this.isReenviadoScanntech() + ", reenviadoScanntechConfirmadoCaixa=" + this.isReenviadoScanntechConfirmadoCaixa() + ")";
    }
}

