/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.model;

import com.softjava.motor.model.Caixa;
import com.softjava.motor.model.VendaPagamento;
import com.softjava.motor.model.VendaProduto;
import com.softjava.motor.model.dto.VendaDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="venda")
public class Venda
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="seq_venda", sequenceName="seq_venda", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_venda")
    @Column(name="id")
    private Long id;
    @ManyToOne
    @JoinColumn(name="idcaixa")
    private Caixa caixa;
    @Column(name="dt_venda")
    private LocalDateTime dataFechamento;
    @Column(name="data_hora_envio_scanntech")
    private LocalDateTime dataHoraEnvioScanntech;
    @Column(name="data_hora_envio_cancelamento_scanntech")
    private LocalDateTime dataHoraEnvioCancelamentoScanntech;
    @Column(name="estado_venda")
    private String estado;
    @Column(name="valor_desconto", precision=20, scale=5)
    private BigDecimal desconto;
    @Column(name="valor_acrescimento", precision=20, scale=5)
    private BigDecimal acrescimo;
    @Column(name="valor_liquido", precision=20, scale=5)
    private BigDecimal total;
    @Column(name="valor_total_taxa_pagamento", precision=20, scale=5)
    private BigDecimal valorTotalTaxaPagamento;
    @Column(name="cpf_cnpj_cliente")
    private String clienteDocumento;
    @Column(name="scanntech_promocao")
    private boolean scanntechPromocao;
    @Column(name="scanntech_promocao_sincronizado")
    private boolean sincronizado;
    @Column(name="scanntech_promocao_sincronizado_cancelada")
    private boolean sincronizadoCancelada;
    @Column(name="json_envio_scanntech")
    private String jsonEnvio;
    @Column(name="json_envio_cancelamento_scanntech")
    private String jsonEnvioCancelamento;
    @Column(name="erro_envio_scanntech")
    private boolean erroEnvioScanntech;
    @Column(name="scanntech_erro_reenvio")
    private boolean scanntechErroReenvio;
    @Column(name="scanntech_erro_400")
    private boolean scanntechErro400;
    @Column(name="erro_envio_scanntech_retorno")
    private String erroEnvioScanntechRetorno;
    @NotFound(action=NotFoundAction.IGNORE)
    @OneToMany(mappedBy="venda", cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<VendaProduto> itens = new ArrayList();
    @NotFound(action=NotFoundAction.IGNORE)
    @OneToMany(mappedBy="venda", cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<VendaPagamento> pagamentos = new ArrayList();

    public String numero() {
        return this.numero(true);
    }

    public String numero(boolean validarEstado) {
        return validarEstado ? ("CANCELADA".equals(this.estado) && this.sincronizado ? "-" + this.id : String.valueOf(this.id)) : String.valueOf(this.id);
    }

    public boolean cancelada() {
        return "CANCELADA".equals(this.estado) && this.sincronizado;
    }

    public VendaDTO toDTO() {
        return VendaDTO.builder().cancelada(this.cancelada()).codigo(this.caixa.getNumero()).total(this.totalSemTaxa()).totalCancelada(this.cancelada() ? this.totalSemTaxa() : BigDecimal.ZERO).quantidade(1).quantidadeCancelada(this.cancelada() ? 1 : 0).dataVenda(this.dataFechamento.toLocalDate()).build();
    }

    public BigDecimal totalSemTaxa() {
        return this.total.subtract(Optional.ofNullable(this.valorTotalTaxaPagamento).orElse(BigDecimal.ZERO));
    }

    public Long getId() {
        return this.id;
    }

    public Caixa getCaixa() {
        return this.caixa;
    }

    public LocalDateTime getDataFechamento() {
        return this.dataFechamento;
    }

    public LocalDateTime getDataHoraEnvioScanntech() {
        return this.dataHoraEnvioScanntech;
    }

    public LocalDateTime getDataHoraEnvioCancelamentoScanntech() {
        return this.dataHoraEnvioCancelamentoScanntech;
    }

    public String getEstado() {
        return this.estado;
    }

    public BigDecimal getDesconto() {
        return this.desconto;
    }

    public BigDecimal getAcrescimo() {
        return this.acrescimo;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public BigDecimal getValorTotalTaxaPagamento() {
        return this.valorTotalTaxaPagamento;
    }

    public String getClienteDocumento() {
        return this.clienteDocumento;
    }

    public boolean isScanntechPromocao() {
        return this.scanntechPromocao;
    }

    public boolean isSincronizado() {
        return this.sincronizado;
    }

    public boolean isSincronizadoCancelada() {
        return this.sincronizadoCancelada;
    }

    public String getJsonEnvio() {
        return this.jsonEnvio;
    }

    public String getJsonEnvioCancelamento() {
        return this.jsonEnvioCancelamento;
    }

    public boolean isErroEnvioScanntech() {
        return this.erroEnvioScanntech;
    }

    public boolean isScanntechErroReenvio() {
        return this.scanntechErroReenvio;
    }

    public boolean isScanntechErro400() {
        return this.scanntechErro400;
    }

    public String getErroEnvioScanntechRetorno() {
        return this.erroEnvioScanntechRetorno;
    }

    public List<VendaProduto> getItens() {
        return this.itens;
    }

    public List<VendaPagamento> getPagamentos() {
        return this.pagamentos;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCaixa(Caixa caixa) {
        this.caixa = caixa;
    }

    public void setDataFechamento(LocalDateTime dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    public void setDataHoraEnvioScanntech(LocalDateTime dataHoraEnvioScanntech) {
        this.dataHoraEnvioScanntech = dataHoraEnvioScanntech;
    }

    public void setDataHoraEnvioCancelamentoScanntech(LocalDateTime dataHoraEnvioCancelamentoScanntech) {
        this.dataHoraEnvioCancelamentoScanntech = dataHoraEnvioCancelamentoScanntech;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public void setDesconto(BigDecimal desconto) {
        this.desconto = desconto;
    }

    public void setAcrescimo(BigDecimal acrescimo) {
        this.acrescimo = acrescimo;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public void setValorTotalTaxaPagamento(BigDecimal valorTotalTaxaPagamento) {
        this.valorTotalTaxaPagamento = valorTotalTaxaPagamento;
    }

    public void setClienteDocumento(String clienteDocumento) {
        this.clienteDocumento = clienteDocumento;
    }

    public void setScanntechPromocao(boolean scanntechPromocao) {
        this.scanntechPromocao = scanntechPromocao;
    }

    public void setSincronizado(boolean sincronizado) {
        this.sincronizado = sincronizado;
    }

    public void setSincronizadoCancelada(boolean sincronizadoCancelada) {
        this.sincronizadoCancelada = sincronizadoCancelada;
    }

    public void setJsonEnvio(String jsonEnvio) {
        this.jsonEnvio = jsonEnvio;
    }

    public void setJsonEnvioCancelamento(String jsonEnvioCancelamento) {
        this.jsonEnvioCancelamento = jsonEnvioCancelamento;
    }

    public void setErroEnvioScanntech(boolean erroEnvioScanntech) {
        this.erroEnvioScanntech = erroEnvioScanntech;
    }

    public void setScanntechErroReenvio(boolean scanntechErroReenvio) {
        this.scanntechErroReenvio = scanntechErroReenvio;
    }

    public void setScanntechErro400(boolean scanntechErro400) {
        this.scanntechErro400 = scanntechErro400;
    }

    public void setErroEnvioScanntechRetorno(String erroEnvioScanntechRetorno) {
        this.erroEnvioScanntechRetorno = erroEnvioScanntechRetorno;
    }

    public void setItens(List<VendaProduto> itens) {
        this.itens = itens;
    }

    public void setPagamentos(List<VendaPagamento> pagamentos) {
        this.pagamentos = pagamentos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Venda)) {
            return false;
        }
        Venda other = (Venda)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isScanntechPromocao() != other.isScanntechPromocao()) {
            return false;
        }
        if (this.isSincronizado() != other.isSincronizado()) {
            return false;
        }
        if (this.isSincronizadoCancelada() != other.isSincronizadoCancelada()) {
            return false;
        }
        if (this.isErroEnvioScanntech() != other.isErroEnvioScanntech()) {
            return false;
        }
        if (this.isScanntechErroReenvio() != other.isScanntechErroReenvio()) {
            return false;
        }
        if (this.isScanntechErro400() != other.isScanntechErro400()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Caixa this$caixa = this.getCaixa();
        Caixa other$caixa = other.getCaixa();
        if (this$caixa == null ? other$caixa != null : !this$caixa.equals(other$caixa)) {
            return false;
        }
        LocalDateTime this$dataFechamento = this.getDataFechamento();
        LocalDateTime other$dataFechamento = other.getDataFechamento();
        if (this$dataFechamento == null ? other$dataFechamento != null : !((Object)this$dataFechamento).equals(other$dataFechamento)) {
            return false;
        }
        LocalDateTime this$dataHoraEnvioScanntech = this.getDataHoraEnvioScanntech();
        LocalDateTime other$dataHoraEnvioScanntech = other.getDataHoraEnvioScanntech();
        if (this$dataHoraEnvioScanntech == null ? other$dataHoraEnvioScanntech != null : !((Object)this$dataHoraEnvioScanntech).equals(other$dataHoraEnvioScanntech)) {
            return false;
        }
        LocalDateTime this$dataHoraEnvioCancelamentoScanntech = this.getDataHoraEnvioCancelamentoScanntech();
        LocalDateTime other$dataHoraEnvioCancelamentoScanntech = other.getDataHoraEnvioCancelamentoScanntech();
        if (this$dataHoraEnvioCancelamentoScanntech == null ? other$dataHoraEnvioCancelamentoScanntech != null : !((Object)this$dataHoraEnvioCancelamentoScanntech).equals(other$dataHoraEnvioCancelamentoScanntech)) {
            return false;
        }
        String this$estado = this.getEstado();
        String other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !this$estado.equals(other$estado)) {
            return false;
        }
        BigDecimal this$desconto = this.getDesconto();
        BigDecimal other$desconto = other.getDesconto();
        if (this$desconto == null ? other$desconto != null : !((Object)this$desconto).equals(other$desconto)) {
            return false;
        }
        BigDecimal this$acrescimo = this.getAcrescimo();
        BigDecimal other$acrescimo = other.getAcrescimo();
        if (this$acrescimo == null ? other$acrescimo != null : !((Object)this$acrescimo).equals(other$acrescimo)) {
            return false;
        }
        BigDecimal this$total = this.getTotal();
        BigDecimal other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        BigDecimal this$valorTotalTaxaPagamento = this.getValorTotalTaxaPagamento();
        BigDecimal other$valorTotalTaxaPagamento = other.getValorTotalTaxaPagamento();
        if (this$valorTotalTaxaPagamento == null ? other$valorTotalTaxaPagamento != null : !((Object)this$valorTotalTaxaPagamento).equals(other$valorTotalTaxaPagamento)) {
            return false;
        }
        String this$clienteDocumento = this.getClienteDocumento();
        String other$clienteDocumento = other.getClienteDocumento();
        if (this$clienteDocumento == null ? other$clienteDocumento != null : !this$clienteDocumento.equals(other$clienteDocumento)) {
            return false;
        }
        String this$jsonEnvio = this.getJsonEnvio();
        String other$jsonEnvio = other.getJsonEnvio();
        if (this$jsonEnvio == null ? other$jsonEnvio != null : !this$jsonEnvio.equals(other$jsonEnvio)) {
            return false;
        }
        String this$jsonEnvioCancelamento = this.getJsonEnvioCancelamento();
        String other$jsonEnvioCancelamento = other.getJsonEnvioCancelamento();
        if (this$jsonEnvioCancelamento == null ? other$jsonEnvioCancelamento != null : !this$jsonEnvioCancelamento.equals(other$jsonEnvioCancelamento)) {
            return false;
        }
        String this$erroEnvioScanntechRetorno = this.getErroEnvioScanntechRetorno();
        String other$erroEnvioScanntechRetorno = other.getErroEnvioScanntechRetorno();
        if (this$erroEnvioScanntechRetorno == null ? other$erroEnvioScanntechRetorno != null : !this$erroEnvioScanntechRetorno.equals(other$erroEnvioScanntechRetorno)) {
            return false;
        }
        List this$itens = this.getItens();
        List other$itens = other.getItens();
        if (this$itens == null ? other$itens != null : !((Object)this$itens).equals(other$itens)) {
            return false;
        }
        List this$pagamentos = this.getPagamentos();
        List other$pagamentos = other.getPagamentos();
        return !(this$pagamentos == null ? other$pagamentos != null : !((Object)this$pagamentos).equals(other$pagamentos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Venda;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isScanntechPromocao() ? 79 : 97);
        result = result * 59 + (this.isSincronizado() ? 79 : 97);
        result = result * 59 + (this.isSincronizadoCancelada() ? 79 : 97);
        result = result * 59 + (this.isErroEnvioScanntech() ? 79 : 97);
        result = result * 59 + (this.isScanntechErroReenvio() ? 79 : 97);
        result = result * 59 + (this.isScanntechErro400() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Caixa $caixa = this.getCaixa();
        result = result * 59 + ($caixa == null ? 43 : $caixa.hashCode());
        LocalDateTime $dataFechamento = this.getDataFechamento();
        result = result * 59 + ($dataFechamento == null ? 43 : ((Object)$dataFechamento).hashCode());
        LocalDateTime $dataHoraEnvioScanntech = this.getDataHoraEnvioScanntech();
        result = result * 59 + ($dataHoraEnvioScanntech == null ? 43 : ((Object)$dataHoraEnvioScanntech).hashCode());
        LocalDateTime $dataHoraEnvioCancelamentoScanntech = this.getDataHoraEnvioCancelamentoScanntech();
        result = result * 59 + ($dataHoraEnvioCancelamentoScanntech == null ? 43 : ((Object)$dataHoraEnvioCancelamentoScanntech).hashCode());
        String $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : $estado.hashCode());
        BigDecimal $desconto = this.getDesconto();
        result = result * 59 + ($desconto == null ? 43 : ((Object)$desconto).hashCode());
        BigDecimal $acrescimo = this.getAcrescimo();
        result = result * 59 + ($acrescimo == null ? 43 : ((Object)$acrescimo).hashCode());
        BigDecimal $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        BigDecimal $valorTotalTaxaPagamento = this.getValorTotalTaxaPagamento();
        result = result * 59 + ($valorTotalTaxaPagamento == null ? 43 : ((Object)$valorTotalTaxaPagamento).hashCode());
        String $clienteDocumento = this.getClienteDocumento();
        result = result * 59 + ($clienteDocumento == null ? 43 : $clienteDocumento.hashCode());
        String $jsonEnvio = this.getJsonEnvio();
        result = result * 59 + ($jsonEnvio == null ? 43 : $jsonEnvio.hashCode());
        String $jsonEnvioCancelamento = this.getJsonEnvioCancelamento();
        result = result * 59 + ($jsonEnvioCancelamento == null ? 43 : $jsonEnvioCancelamento.hashCode());
        String $erroEnvioScanntechRetorno = this.getErroEnvioScanntechRetorno();
        result = result * 59 + ($erroEnvioScanntechRetorno == null ? 43 : $erroEnvioScanntechRetorno.hashCode());
        List $itens = this.getItens();
        result = result * 59 + ($itens == null ? 43 : ((Object)$itens).hashCode());
        List $pagamentos = this.getPagamentos();
        result = result * 59 + ($pagamentos == null ? 43 : ((Object)$pagamentos).hashCode());
        return result;
    }

    public String toString() {
        return "Venda(id=" + this.getId() + ", caixa=" + this.getCaixa() + ", dataFechamento=" + this.getDataFechamento() + ", dataHoraEnvioScanntech=" + this.getDataHoraEnvioScanntech() + ", dataHoraEnvioCancelamentoScanntech=" + this.getDataHoraEnvioCancelamentoScanntech() + ", estado=" + this.getEstado() + ", desconto=" + this.getDesconto() + ", acrescimo=" + this.getAcrescimo() + ", total=" + this.getTotal() + ", valorTotalTaxaPagamento=" + this.getValorTotalTaxaPagamento() + ", clienteDocumento=" + this.getClienteDocumento() + ", scanntechPromocao=" + this.isScanntechPromocao() + ", sincronizado=" + this.isSincronizado() + ", sincronizadoCancelada=" + this.isSincronizadoCancelada() + ", jsonEnvio=" + this.getJsonEnvio() + ", jsonEnvioCancelamento=" + this.getJsonEnvioCancelamento() + ", erroEnvioScanntech=" + this.isErroEnvioScanntech() + ", scanntechErroReenvio=" + this.isScanntechErroReenvio() + ", scanntechErro400=" + this.isScanntechErro400() + ", erroEnvioScanntechRetorno=" + this.getErroEnvioScanntechRetorno() + ", itens=" + this.getItens() + ", pagamentos=" + this.getPagamentos() + ")";
    }
}

