/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.model;

import com.softjava.motor.model.Venda;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="venda_pagamento")
public class VendaPagamento
implements Serializable {
    @Id
    @SequenceGenerator(name="seq_venda_pagamento", sequenceName="seq_venda_pagamento", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_venda_pagamento")
    @Column(name="id")
    private Long id;
    @ManyToOne
    @JoinColumn(name="idvenda")
    private Venda venda;
    @Column(name="scanntech_idpagamento")
    private Long codigo;
    @Column(name="valor", precision=20, scale=5)
    private BigDecimal valor;
    @Column(name="valor_taxa", precision=20, scale=5)
    private BigDecimal valorTaxa;
    @Column(name="card_bin")
    private String bin;
    @Column(name="codigo_autorizacao_cartao")
    private String nsu;
    @Column(name="card_first_six_digits")
    private String card_first_six_digits;
    @Column(name="card_last_four_digits")
    private String card_last_four_digits;

    public BigDecimal total() {
        return this.valor.subtract(Optional.ofNullable(this.valorTaxa).orElse(BigDecimal.ZERO));
    }

    public Long getId() {
        return this.id;
    }

    public Venda getVenda() {
        return this.venda;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public BigDecimal getValorTaxa() {
        return this.valorTaxa;
    }

    public String getBin() {
        return this.bin;
    }

    public String getNsu() {
        return this.nsu;
    }

    public String getCard_first_six_digits() {
        return this.card_first_six_digits;
    }

    public String getCard_last_four_digits() {
        return this.card_last_four_digits;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setVenda(Venda venda) {
        this.venda = venda;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public void setValorTaxa(BigDecimal valorTaxa) {
        this.valorTaxa = valorTaxa;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    public void setNsu(String nsu) {
        this.nsu = nsu;
    }

    public void setCard_first_six_digits(String card_first_six_digits) {
        this.card_first_six_digits = card_first_six_digits;
    }

    public void setCard_last_four_digits(String card_last_four_digits) {
        this.card_last_four_digits = card_last_four_digits;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VendaPagamento)) {
            return false;
        }
        VendaPagamento other = (VendaPagamento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        Venda this$venda = this.getVenda();
        Venda other$venda = other.getVenda();
        if (this$venda == null ? other$venda != null : !this$venda.equals(other$venda)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorTaxa = this.getValorTaxa();
        BigDecimal other$valorTaxa = other.getValorTaxa();
        if (this$valorTaxa == null ? other$valorTaxa != null : !((Object)this$valorTaxa).equals(other$valorTaxa)) {
            return false;
        }
        String this$bin = this.getBin();
        String other$bin = other.getBin();
        if (this$bin == null ? other$bin != null : !this$bin.equals(other$bin)) {
            return false;
        }
        String this$nsu = this.getNsu();
        String other$nsu = other.getNsu();
        if (this$nsu == null ? other$nsu != null : !this$nsu.equals(other$nsu)) {
            return false;
        }
        String this$card_first_six_digits = this.getCard_first_six_digits();
        String other$card_first_six_digits = other.getCard_first_six_digits();
        if (this$card_first_six_digits == null ? other$card_first_six_digits != null : !this$card_first_six_digits.equals(other$card_first_six_digits)) {
            return false;
        }
        String this$card_last_four_digits = this.getCard_last_four_digits();
        String other$card_last_four_digits = other.getCard_last_four_digits();
        return !(this$card_last_four_digits == null ? other$card_last_four_digits != null : !this$card_last_four_digits.equals(other$card_last_four_digits));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VendaPagamento;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        Venda $venda = this.getVenda();
        result = result * 59 + ($venda == null ? 43 : $venda.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorTaxa = this.getValorTaxa();
        result = result * 59 + ($valorTaxa == null ? 43 : ((Object)$valorTaxa).hashCode());
        String $bin = this.getBin();
        result = result * 59 + ($bin == null ? 43 : $bin.hashCode());
        String $nsu = this.getNsu();
        result = result * 59 + ($nsu == null ? 43 : $nsu.hashCode());
        String $card_first_six_digits = this.getCard_first_six_digits();
        result = result * 59 + ($card_first_six_digits == null ? 43 : $card_first_six_digits.hashCode());
        String $card_last_four_digits = this.getCard_last_four_digits();
        result = result * 59 + ($card_last_four_digits == null ? 43 : $card_last_four_digits.hashCode());
        return result;
    }

    public String toString() {
        return "VendaPagamento(id=" + this.getId() + ", venda=" + this.getVenda() + ", codigo=" + this.getCodigo() + ", valor=" + this.getValor() + ", valorTaxa=" + this.getValorTaxa() + ", bin=" + this.getBin() + ", nsu=" + this.getNsu() + ", card_first_six_digits=" + this.getCard_first_six_digits() + ", card_last_four_digits=" + this.getCard_last_four_digits() + ")";
    }
}

