/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.model;

import com.softjava.motor.componente.util.CampoUtil;
import com.softjava.motor.model.Venda;
import com.softjava.motor.util.GTINUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="venda_produto")
public class VendaProduto
implements Serializable {
    @Id
    @SequenceGenerator(name="seq_venda_produto", sequenceName="seq_venda_produto", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_venda_produto")
    @Column(name="id")
    private Long id;
    @Column(name="idproduto")
    private Long codigoInterno;
    @ManyToOne
    @JoinColumn(name="idvenda")
    private Venda venda;
    @Column(name="codigo")
    private String codigo;
    @Column(name="descricao")
    private String descricao;
    @Column(name="quantidade", precision=20, scale=5)
    private BigDecimal quantidade;
    @Column(name="preco_unidade", precision=20, scale=5)
    private BigDecimal precoUnidade;
    @Column(name="valor_acrescimo", precision=20, scale=5)
    private BigDecimal acrescimo;
    @Column(name="scanntech_promocao_desconto", precision=20, scale=5)
    private BigDecimal desconto;
    @Column(name="valor_desconto", precision=10, scale=5)
    private BigDecimal descontoItem;
    @Column(name="valor_total_processado", precision=20, scale=5)
    private BigDecimal subtotal;

    public String cinterno() {
        return String.valueOf(this.codigoInterno);
    }

    public String ean13() {
        String GTIN;
        if (StringUtils.isBlank((CharSequence)this.codigo)) {
            return "";
        }
        String string = GTIN = StringUtils.length((CharSequence)this.codigo) > 8 ? GTINUtil.validaGTIN13((String)this.codigo) : GTINUtil.validaGTIN8((String)this.codigo);
        if ("SEM GTIN".equals(GTIN) && StringUtils.length((CharSequence)this.codigo) > 13) {
            GTIN = this.codigo;
        }
        return "SEM GTIN".equals(GTIN) ? String.valueOf(this.codigoInterno) : this.codigo;
    }

    public BigDecimal valor() {
        return CampoUtil.duasCasasScanntechHALF_DOWN((BigDecimal)this.subtotal);
    }

    public Long getId() {
        return this.id;
    }

    public Long getCodigoInterno() {
        return this.codigoInterno;
    }

    public Venda getVenda() {
        return this.venda;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public BigDecimal getQuantidade() {
        return this.quantidade;
    }

    public BigDecimal getPrecoUnidade() {
        return this.precoUnidade;
    }

    public BigDecimal getAcrescimo() {
        return this.acrescimo;
    }

    public BigDecimal getDesconto() {
        return this.desconto;
    }

    public BigDecimal getDescontoItem() {
        return this.descontoItem;
    }

    public BigDecimal getSubtotal() {
        return this.subtotal;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCodigoInterno(Long codigoInterno) {
        this.codigoInterno = codigoInterno;
    }

    public void setVenda(Venda venda) {
        this.venda = venda;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setQuantidade(BigDecimal quantidade) {
        this.quantidade = quantidade;
    }

    public void setPrecoUnidade(BigDecimal precoUnidade) {
        this.precoUnidade = precoUnidade;
    }

    public void setAcrescimo(BigDecimal acrescimo) {
        this.acrescimo = acrescimo;
    }

    public void setDesconto(BigDecimal desconto) {
        this.desconto = desconto;
    }

    public void setDescontoItem(BigDecimal descontoItem) {
        this.descontoItem = descontoItem;
    }

    public void setSubtotal(BigDecimal subtotal) {
        this.subtotal = subtotal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VendaProduto)) {
            return false;
        }
        VendaProduto other = (VendaProduto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$codigoInterno = this.getCodigoInterno();
        Long other$codigoInterno = other.getCodigoInterno();
        if (this$codigoInterno == null ? other$codigoInterno != null : !((Object)this$codigoInterno).equals(other$codigoInterno)) {
            return false;
        }
        Venda this$venda = this.getVenda();
        Venda other$venda = other.getVenda();
        if (this$venda == null ? other$venda != null : !this$venda.equals(other$venda)) {
            return false;
        }
        String this$codigo = this.getCodigo();
        String other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !this$codigo.equals(other$codigo)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        BigDecimal this$quantidade = this.getQuantidade();
        BigDecimal other$quantidade = other.getQuantidade();
        if (this$quantidade == null ? other$quantidade != null : !((Object)this$quantidade).equals(other$quantidade)) {
            return false;
        }
        BigDecimal this$precoUnidade = this.getPrecoUnidade();
        BigDecimal other$precoUnidade = other.getPrecoUnidade();
        if (this$precoUnidade == null ? other$precoUnidade != null : !((Object)this$precoUnidade).equals(other$precoUnidade)) {
            return false;
        }
        BigDecimal this$acrescimo = this.getAcrescimo();
        BigDecimal other$acrescimo = other.getAcrescimo();
        if (this$acrescimo == null ? other$acrescimo != null : !((Object)this$acrescimo).equals(other$acrescimo)) {
            return false;
        }
        BigDecimal this$desconto = this.getDesconto();
        BigDecimal other$desconto = other.getDesconto();
        if (this$desconto == null ? other$desconto != null : !((Object)this$desconto).equals(other$desconto)) {
            return false;
        }
        BigDecimal this$descontoItem = this.getDescontoItem();
        BigDecimal other$descontoItem = other.getDescontoItem();
        if (this$descontoItem == null ? other$descontoItem != null : !((Object)this$descontoItem).equals(other$descontoItem)) {
            return false;
        }
        BigDecimal this$subtotal = this.getSubtotal();
        BigDecimal other$subtotal = other.getSubtotal();
        return !(this$subtotal == null ? other$subtotal != null : !((Object)this$subtotal).equals(other$subtotal));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VendaProduto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $codigoInterno = this.getCodigoInterno();
        result = result * 59 + ($codigoInterno == null ? 43 : ((Object)$codigoInterno).hashCode());
        Venda $venda = this.getVenda();
        result = result * 59 + ($venda == null ? 43 : $venda.hashCode());
        String $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : $codigo.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        BigDecimal $quantidade = this.getQuantidade();
        result = result * 59 + ($quantidade == null ? 43 : ((Object)$quantidade).hashCode());
        BigDecimal $precoUnidade = this.getPrecoUnidade();
        result = result * 59 + ($precoUnidade == null ? 43 : ((Object)$precoUnidade).hashCode());
        BigDecimal $acrescimo = this.getAcrescimo();
        result = result * 59 + ($acrescimo == null ? 43 : ((Object)$acrescimo).hashCode());
        BigDecimal $desconto = this.getDesconto();
        result = result * 59 + ($desconto == null ? 43 : ((Object)$desconto).hashCode());
        BigDecimal $descontoItem = this.getDescontoItem();
        result = result * 59 + ($descontoItem == null ? 43 : ((Object)$descontoItem).hashCode());
        BigDecimal $subtotal = this.getSubtotal();
        result = result * 59 + ($subtotal == null ? 43 : ((Object)$subtotal).hashCode());
        return result;
    }

    public String toString() {
        return "VendaProduto(id=" + this.getId() + ", codigoInterno=" + this.getCodigoInterno() + ", venda=" + this.getVenda() + ", codigo=" + this.getCodigo() + ", descricao=" + this.getDescricao() + ", quantidade=" + this.getQuantidade() + ", precoUnidade=" + this.getPrecoUnidade() + ", acrescimo=" + this.getAcrescimo() + ", desconto=" + this.getDesconto() + ", descontoItem=" + this.getDescontoItem() + ", subtotal=" + this.getSubtotal() + ")";
    }
}

