/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.model.dto;

import com.softjava.motor.model.dto.VendaDTO;
import java.math.BigDecimal;
import java.time.LocalDate;

public class VendaDTO {
    private Integer codigo;
    private BigDecimal total;
    private BigDecimal totalCancelada;
    private int quantidade;
    private int quantidadeCancelada;
    private LocalDate dataVenda;
    private boolean cancelada;
    private boolean sincronizada;

    public static VendaDTO aggregation(VendaDTO inicial, VendaDTO entrada) {
        inicial.setTotal(inicial.getTotal().add(entrada.getTotal()));
        inicial.setTotalCancelada(inicial.getTotalCancelada().add(entrada.getTotalCancelada()));
        inicial.setQuantidade(inicial.getQuantidade() + entrada.getQuantidade());
        inicial.setQuantidadeCancelada(inicial.getQuantidadeCancelada() + entrada.getQuantidadeCancelada());
        return inicial;
    }

    public static VendaDTOBuilder builder() {
        return new VendaDTOBuilder();
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public BigDecimal getTotalCancelada() {
        return this.totalCancelada;
    }

    public int getQuantidade() {
        return this.quantidade;
    }

    public int getQuantidadeCancelada() {
        return this.quantidadeCancelada;
    }

    public LocalDate getDataVenda() {
        return this.dataVenda;
    }

    public boolean isCancelada() {
        return this.cancelada;
    }

    public boolean isSincronizada() {
        return this.sincronizada;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public void setTotalCancelada(BigDecimal totalCancelada) {
        this.totalCancelada = totalCancelada;
    }

    public void setQuantidade(int quantidade) {
        this.quantidade = quantidade;
    }

    public void setQuantidadeCancelada(int quantidadeCancelada) {
        this.quantidadeCancelada = quantidadeCancelada;
    }

    public void setDataVenda(LocalDate dataVenda) {
        this.dataVenda = dataVenda;
    }

    public void setCancelada(boolean cancelada) {
        this.cancelada = cancelada;
    }

    public void setSincronizada(boolean sincronizada) {
        this.sincronizada = sincronizada;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VendaDTO)) {
            return false;
        }
        VendaDTO other = (VendaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getQuantidade() != other.getQuantidade()) {
            return false;
        }
        if (this.getQuantidadeCancelada() != other.getQuantidadeCancelada()) {
            return false;
        }
        if (this.isCancelada() != other.isCancelada()) {
            return false;
        }
        if (this.isSincronizada() != other.isSincronizada()) {
            return false;
        }
        Integer this$codigo = this.getCodigo();
        Integer other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        BigDecimal this$total = this.getTotal();
        BigDecimal other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        BigDecimal this$totalCancelada = this.getTotalCancelada();
        BigDecimal other$totalCancelada = other.getTotalCancelada();
        if (this$totalCancelada == null ? other$totalCancelada != null : !((Object)this$totalCancelada).equals(other$totalCancelada)) {
            return false;
        }
        LocalDate this$dataVenda = this.getDataVenda();
        LocalDate other$dataVenda = other.getDataVenda();
        return !(this$dataVenda == null ? other$dataVenda != null : !((Object)this$dataVenda).equals(other$dataVenda));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VendaDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQuantidade();
        result = result * 59 + this.getQuantidadeCancelada();
        result = result * 59 + (this.isCancelada() ? 79 : 97);
        result = result * 59 + (this.isSincronizada() ? 79 : 97);
        Integer $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        BigDecimal $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        BigDecimal $totalCancelada = this.getTotalCancelada();
        result = result * 59 + ($totalCancelada == null ? 43 : ((Object)$totalCancelada).hashCode());
        LocalDate $dataVenda = this.getDataVenda();
        result = result * 59 + ($dataVenda == null ? 43 : ((Object)$dataVenda).hashCode());
        return result;
    }

    public String toString() {
        return "VendaDTO(codigo=" + this.getCodigo() + ", total=" + this.getTotal() + ", totalCancelada=" + this.getTotalCancelada() + ", quantidade=" + this.getQuantidade() + ", quantidadeCancelada=" + this.getQuantidadeCancelada() + ", dataVenda=" + this.getDataVenda() + ", cancelada=" + this.isCancelada() + ", sincronizada=" + this.isSincronizada() + ")";
    }

    public VendaDTO() {
    }

    public VendaDTO(Integer codigo, BigDecimal total, BigDecimal totalCancelada, int quantidade, int quantidadeCancelada, LocalDate dataVenda, boolean cancelada, boolean sincronizada) {
        this.codigo = codigo;
        this.total = total;
        this.totalCancelada = totalCancelada;
        this.quantidade = quantidade;
        this.quantidadeCancelada = quantidadeCancelada;
        this.dataVenda = dataVenda;
        this.cancelada = cancelada;
        this.sincronizada = sincronizada;
    }
}

