/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.repository;

import com.softjava.motor.model.Caixa;
import com.softjava.motor.model.dto.CaixaDTO;
import com.softjava.motor.model.dto.CaixaFechamentoDTO;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

public interface CaixaRepository
extends JpaRepository<Caixa, Long> {
    @Query(value="select id as codigo, cast(dt_fechamento as date) as dfechamento, round(COALESCE((select sum(valor_liquido) from venda where idcaixa=c.id and estado_venda='FECHADA' and scanntech_promocao_sincronizado=true),0.0),2) as vfechadas, round(COALESCE((select sum(valor_liquido) from venda where idcaixa=c.id and estado_venda='CANCELADA' and scanntech_promocao_sincronizado_cancelada=true),0.0),2) as vcanceladas, COALESCE((select count(id) from venda where idcaixa=c.id AND estado_venda='FECHADA' and scanntech_promocao_sincronizado=true),0) as qfechadas, COALESCE((select count(id) from venda where idcaixa=c.id and estado_venda='CANCELADA' and scanntech_promocao_sincronizado=true),0) as qcanceladas from caixa as c where  status=false and erro_envio_scanntech=false and scanntech_promocao_sincronizado=false and dt_fechamento>=:dataParametro and id not in(select idcaixa from venda where estado_venda='FECHADA' and scanntech_promocao_sincronizado=false and scanntech_promocao=true and erro_envio_scanntech=false group by idcaixa) group by codigo,dfechamento LIMIT 100", nativeQuery=true)
    public List<CaixaDTO> findCaixasPendenteEnvio(LocalDate var1);

    @Query(value="SELECT DISTINCT v.id as venda, v.idcaixa AS codigo, CAST(v.dt_venda AS DATE) AS dtfechamento, ROUND(v.valor_liquido, 2) AS vfechadas, v.scanntech_promocao_sincronizado AS fechada, v.scanntech_promocao_sincronizado_cancelada AS cancelada  FROM venda AS v INNER JOIN  caixa AS c ON v.idcaixa = c.id  WHERE c.status = FALSE  AND v.dt_venda >= :dataParametro   ORDER BY  venda ", nativeQuery=true)
    public List<CaixaFechamentoDTO> findCaixasEnvio(LocalDate var1);

    @Query(value="SELECT COUNT(*) FROM venda AS v INNER JOIN caixa AS c ON v.idcaixa = c.id WHERE c.status = FALSE AND v.numero = :numeroCaixa AND v.scanntech_erro_reenvio = true ORDER BY v.id", nativeQuery=true)
    public long ticketComErroReenvioByCaixa(Integer var1);

    @Transactional
    @Modifying
    @Query(value="UPDATE Caixa c SET c.erroEnvioScanntech=true, c.jsonEnvio=:json,c.erroEnvioScanntechRetorno=:erro WHERE c.numero=:numero")
    public void marcarComErroAoEnviar(Integer var1, String var2, String var3);

    @Transactional
    @Modifying
    @Query(value="UPDATE Caixa c SET c.sincronizado = true, c.jsonEnvio=:json,c.dataHoraEnvioScanntech=current_timestamp WHERE c.numero=:numero")
    public void marcarComoSincronizada(Integer var1, String var2);

    @Transactional
    @Modifying
    @Query(value="UPDATE Caixa AS c SET c.sincronizado = false,c.dataHoraEnvioScanntech=null,c.jsonEnvio=null WHERE DATE(c.dataAbertura)=:data")
    public void marcarComoNaoSincronizadaByData(LocalDate var1);

    @Transactional
    @Modifying
    @Query(value="UPDATE Caixa c SET c.sincronizado = false,c.dataHoraEnvioScanntech=null,c.jsonEnvio=null WHERE c.numero=:numero")
    public void marcarComoNaoSincronizadaPorId(Integer var1);
}

